package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariablevalueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "valueschema", 
    "createdon", 
    "overwritetime", 
    "defaultvalue", 
    "_owninguser_value", 
    "utcconversiontimezonecode", 
    "statecode", 
    "ismanaged", 
    "description", 
    "_createdby_value", 
    "iscustomizable", 
    "_owningbusinessunit_value", 
    "hint", 
    "isrequired", 
    "versionnumber", 
    "environmentvariabledefinitionid", 
    "_ownerid_value", 
    "displayname", 
    "overriddencreatedon", 
    "schemaname", 
    "importsequencenumber", 
    "introducedversion", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "environmentvariabledefinitionidunique", 
    "_modifiedby_value", 
    "_owningteam_value", 
    "type", 
    "modifiedon", 
    "timezoneruleversionnumber", 
    "componentstate", 
    "_createdonbehalfby_value", 
    "solutionid"})
@JsonInclude(Include.NON_NULL)
public class Environmentvariabledefinition extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.environmentvariabledefinition";
    }

    @JsonProperty("valueschema")
    protected String valueschema;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("defaultvalue")
    protected String defaultvalue;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("hint")
    protected String hint;

    @JsonProperty("isrequired")
    protected Boolean isrequired;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("environmentvariabledefinitionid")
    protected String environmentvariabledefinitionid;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("displayname")
    protected String displayname;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("schemaname")
    protected String schemaname;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("environmentvariabledefinitionidunique")
    protected String environmentvariabledefinitionidunique;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    protected Environmentvariabledefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnvironmentvariabledefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String valueschema;
        private OffsetDateTime createdon;
        private OffsetDateTime overwritetime;
        private String defaultvalue;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private Integer statecode;
        private Boolean ismanaged;
        private String description;
        private String _createdby_value;
        private BooleanManagedProperty iscustomizable;
        private String _owningbusinessunit_value;
        private String hint;
        private Boolean isrequired;
        private Long versionnumber;
        private String environmentvariabledefinitionid;
        private String _ownerid_value;
        private String displayname;
        private OffsetDateTime overriddencreatedon;
        private String schemaname;
        private Integer importsequencenumber;
        private String introducedversion;
        private Integer statuscode;
        private String _modifiedonbehalfby_value;
        private String environmentvariabledefinitionidunique;
        private String _modifiedby_value;
        private String _owningteam_value;
        private Integer type;
        private OffsetDateTime modifiedon;
        private Integer timezoneruleversionnumber;
        private Integer componentstate;
        private String _createdonbehalfby_value;
        private String solutionid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder valueschema(String valueschema) {
            this.valueschema = valueschema;
            this.changedFields = changedFields.add("valueschema");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder defaultvalue(String defaultvalue) {
            this.defaultvalue = defaultvalue;
            this.changedFields = changedFields.add("defaultvalue");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder hint(String hint) {
            this.hint = hint;
            this.changedFields = changedFields.add("hint");
            return this;
        }

        public Builder isrequired(Boolean isrequired) {
            this.isrequired = isrequired;
            this.changedFields = changedFields.add("isrequired");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder environmentvariabledefinitionid(String environmentvariabledefinitionid) {
            this.environmentvariabledefinitionid = environmentvariabledefinitionid;
            this.changedFields = changedFields.add("environmentvariabledefinitionid");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder displayname(String displayname) {
            this.displayname = displayname;
            this.changedFields = changedFields.add("displayname");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder schemaname(String schemaname) {
            this.schemaname = schemaname;
            this.changedFields = changedFields.add("schemaname");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder environmentvariabledefinitionidunique(String environmentvariabledefinitionidunique) {
            this.environmentvariabledefinitionidunique = environmentvariabledefinitionidunique;
            this.changedFields = changedFields.add("environmentvariabledefinitionidunique");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Environmentvariabledefinition build() {
            Environmentvariabledefinition _x = new Environmentvariabledefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.environmentvariabledefinition";
            _x.valueschema = valueschema;
            _x.createdon = createdon;
            _x.overwritetime = overwritetime;
            _x.defaultvalue = defaultvalue;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statecode = statecode;
            _x.ismanaged = ismanaged;
            _x.description = description;
            _x._createdby_value = _createdby_value;
            _x.iscustomizable = iscustomizable;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.hint = hint;
            _x.isrequired = isrequired;
            _x.versionnumber = versionnumber;
            _x.environmentvariabledefinitionid = environmentvariabledefinitionid;
            _x._ownerid_value = _ownerid_value;
            _x.displayname = displayname;
            _x.overriddencreatedon = overriddencreatedon;
            _x.schemaname = schemaname;
            _x.importsequencenumber = importsequencenumber;
            _x.introducedversion = introducedversion;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.environmentvariabledefinitionidunique = environmentvariabledefinitionidunique;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningteam_value = _owningteam_value;
            _x.type = type;
            _x.modifiedon = modifiedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.componentstate = componentstate;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.solutionid = solutionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && environmentvariabledefinitionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(environmentvariabledefinitionid.toString()));
        }
    }

    @Property(name="valueschema")
    @JsonIgnore
    public Optional<String> getValueschema() {
        return Optional.ofNullable(valueschema);
    }

    public Environmentvariabledefinition withValueschema(String valueschema) {
        Checks.checkIsAscii(valueschema);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("valueschema");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.valueschema = valueschema;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Environmentvariabledefinition withCreatedon(OffsetDateTime createdon) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Environmentvariabledefinition withOverwritetime(OffsetDateTime overwritetime) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="defaultvalue")
    @JsonIgnore
    public Optional<String> getDefaultvalue() {
        return Optional.ofNullable(defaultvalue);
    }

    public Environmentvariabledefinition withDefaultvalue(String defaultvalue) {
        Checks.checkIsAscii(defaultvalue);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("defaultvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.defaultvalue = defaultvalue;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Environmentvariabledefinition with_owninguser_value(String _owninguser_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Environmentvariabledefinition withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Environmentvariabledefinition withStatecode(Integer statecode) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Environmentvariabledefinition withIsmanaged(Boolean ismanaged) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Environmentvariabledefinition withDescription(String description) {
        Checks.checkIsAscii(description);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.description = description;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Environmentvariabledefinition with_createdby_value(String _createdby_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Environmentvariabledefinition withIscustomizable(BooleanManagedProperty iscustomizable) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Environmentvariabledefinition with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="hint")
    @JsonIgnore
    public Optional<String> getHint() {
        return Optional.ofNullable(hint);
    }

    public Environmentvariabledefinition withHint(String hint) {
        Checks.checkIsAscii(hint);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("hint");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.hint = hint;
        return _x;
    }

    @Property(name="isrequired")
    @JsonIgnore
    public Optional<Boolean> getIsrequired() {
        return Optional.ofNullable(isrequired);
    }

    public Environmentvariabledefinition withIsrequired(Boolean isrequired) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("isrequired");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.isrequired = isrequired;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Environmentvariabledefinition withVersionnumber(Long versionnumber) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="environmentvariabledefinitionid")
    @JsonIgnore
    public Optional<String> getEnvironmentvariabledefinitionid() {
        return Optional.ofNullable(environmentvariabledefinitionid);
    }

    public Environmentvariabledefinition withEnvironmentvariabledefinitionid(String environmentvariabledefinitionid) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("environmentvariabledefinitionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.environmentvariabledefinitionid = environmentvariabledefinitionid;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Environmentvariabledefinition with_ownerid_value(String _ownerid_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="displayname")
    @JsonIgnore
    public Optional<String> getDisplayname() {
        return Optional.ofNullable(displayname);
    }

    public Environmentvariabledefinition withDisplayname(String displayname) {
        Checks.checkIsAscii(displayname);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.displayname = displayname;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Environmentvariabledefinition withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="schemaname")
    @JsonIgnore
    public Optional<String> getSchemaname() {
        return Optional.ofNullable(schemaname);
    }

    public Environmentvariabledefinition withSchemaname(String schemaname) {
        Checks.checkIsAscii(schemaname);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("schemaname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.schemaname = schemaname;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Environmentvariabledefinition withImportsequencenumber(Integer importsequencenumber) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Environmentvariabledefinition withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Environmentvariabledefinition withStatuscode(Integer statuscode) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Environmentvariabledefinition with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="environmentvariabledefinitionidunique")
    @JsonIgnore
    public Optional<String> getEnvironmentvariabledefinitionidunique() {
        return Optional.ofNullable(environmentvariabledefinitionidunique);
    }

    public Environmentvariabledefinition withEnvironmentvariabledefinitionidunique(String environmentvariabledefinitionidunique) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("environmentvariabledefinitionidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.environmentvariabledefinitionidunique = environmentvariabledefinitionidunique;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Environmentvariabledefinition with_modifiedby_value(String _modifiedby_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Environmentvariabledefinition with_owningteam_value(String _owningteam_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Environmentvariabledefinition withType(Integer type) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.type = type;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Environmentvariabledefinition withModifiedon(OffsetDateTime modifiedon) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Environmentvariabledefinition withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Environmentvariabledefinition withComponentstate(Integer componentstate) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Environmentvariabledefinition with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Environmentvariabledefinition withSolutionid(String solutionid) {
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariabledefinition");
        _x.solutionid = solutionid;
        return _x;
    }

    public Environmentvariabledefinition withUnmappedField(String name, String value) {
        Environmentvariabledefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="environmentvariabledefinition_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getEnvironmentvariabledefinition_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_SyncErrors"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_SyncErrors"));
    }

    @NavigationProperty(name="environmentvariabledefinition_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getEnvironmentvariabledefinition_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="environmentvariabledefinition_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getEnvironmentvariabledefinition_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="environmentvariabledefinition_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getEnvironmentvariabledefinition_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_AsyncOperations"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_AsyncOperations"));
    }

    @NavigationProperty(name="environmentvariabledefinition_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getEnvironmentvariabledefinition_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="environmentvariabledefinition_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getEnvironmentvariabledefinition_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_ProcessSession"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_ProcessSession"));
    }

    @NavigationProperty(name="environmentvariabledefinition_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getEnvironmentvariabledefinition_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_BulkDeleteFailures"));
    }

    @NavigationProperty(name="environmentvariabledefinition_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getEnvironmentvariabledefinition_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="environmentvariabledefinition_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueCollectionRequest getEnvironmentvariabledefinition_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("environmentvariabledefinition_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "environmentvariabledefinition_environmentvariablevalue"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Environmentvariabledefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Environmentvariabledefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Environmentvariabledefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Environmentvariabledefinition _copy() {
        Environmentvariabledefinition _x = new Environmentvariabledefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.valueschema = valueschema;
        _x.createdon = createdon;
        _x.overwritetime = overwritetime;
        _x.defaultvalue = defaultvalue;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statecode = statecode;
        _x.ismanaged = ismanaged;
        _x.description = description;
        _x._createdby_value = _createdby_value;
        _x.iscustomizable = iscustomizable;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.hint = hint;
        _x.isrequired = isrequired;
        _x.versionnumber = versionnumber;
        _x.environmentvariabledefinitionid = environmentvariabledefinitionid;
        _x._ownerid_value = _ownerid_value;
        _x.displayname = displayname;
        _x.overriddencreatedon = overriddencreatedon;
        _x.schemaname = schemaname;
        _x.importsequencenumber = importsequencenumber;
        _x.introducedversion = introducedversion;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.environmentvariabledefinitionidunique = environmentvariabledefinitionidunique;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningteam_value = _owningteam_value;
        _x.type = type;
        _x.modifiedon = modifiedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.componentstate = componentstate;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.solutionid = solutionid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Environmentvariabledefinition[");
        b.append("valueschema=");
        b.append(this.valueschema);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("defaultvalue=");
        b.append(this.defaultvalue);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("hint=");
        b.append(this.hint);
        b.append(", ");
        b.append("isrequired=");
        b.append(this.isrequired);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("environmentvariabledefinitionid=");
        b.append(this.environmentvariabledefinitionid);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("displayname=");
        b.append(this.displayname);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("schemaname=");
        b.append(this.schemaname);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("environmentvariabledefinitionidunique=");
        b.append(this.environmentvariabledefinitionidunique);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
