package microsoft.dynamics.crm.container;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.AddSolutionComponentResponse;
import microsoft.dynamics.crm.complex.AlmHandlerResponse;
import microsoft.dynamics.crm.complex.AnalyzeSentimentResponse;
import microsoft.dynamics.crm.complex.BackgroundSendEmailResponse;
import microsoft.dynamics.crm.complex.BookResponse;
import microsoft.dynamics.crm.complex.BulkDeleteResponse;
import microsoft.dynamics.crm.complex.BulkDetectDuplicatesResponse;
import microsoft.dynamics.crm.complex.CanBeReferencedResponse;
import microsoft.dynamics.crm.complex.CanBeReferencingResponse;
import microsoft.dynamics.crm.complex.CanManyToManyResponse;
import microsoft.dynamics.crm.complex.CategorizeTextResponse;
import microsoft.dynamics.crm.complex.ChannelAccessProfilePrivilege;
import microsoft.dynamics.crm.complex.CheckIncomingEmailResponse;
import microsoft.dynamics.crm.complex.CheckPromoteEmailResponse;
import microsoft.dynamics.crm.complex.CloneAsPatchResponse;
import microsoft.dynamics.crm.complex.CloneAsSolutionResponse;
import microsoft.dynamics.crm.complex.CommitAnnotationBlocksUploadResponse;
import microsoft.dynamics.crm.complex.CommitAttachmentBlocksUploadResponse;
import microsoft.dynamics.crm.complex.CommitFileBlocksUploadResponse;
import microsoft.dynamics.crm.complex.ComplexLookupAttributeMetadata;
import microsoft.dynamics.crm.complex.ComplexOneToManyRelationshipMetadata;
import microsoft.dynamics.crm.complex.CreateCustomerRelationshipsResponse;
import microsoft.dynamics.crm.complex.CreateInstanceResponse;
import microsoft.dynamics.crm.complex.DeleteAndPromoteResponse;
import microsoft.dynamics.crm.complex.DeleteAuditDataResponse;
import microsoft.dynamics.crm.complex.DeleteRecordChangeHistoryResponse;
import microsoft.dynamics.crm.complex.DetectLanguageResponse;
import microsoft.dynamics.crm.complex.DownloadBlockResponse;
import microsoft.dynamics.crm.complex.DownloadSolutionExportDataResponse;
import microsoft.dynamics.crm.complex.EntityQueryExpression;
import microsoft.dynamics.crm.complex.ExportFieldTranslationResponse;
import microsoft.dynamics.crm.complex.ExportSolutionAsyncResponse;
import microsoft.dynamics.crm.complex.ExportSolutionResponse;
import microsoft.dynamics.crm.complex.ExtractKeyPhrasesResponse;
import microsoft.dynamics.crm.complex.ExtractTextEntitiesResponse;
import microsoft.dynamics.crm.complex.FetchXmlToQueryExpressionResponse;
import microsoft.dynamics.crm.complex.FormatAddressResponse;
import microsoft.dynamics.crm.complex.GetAutoNumberSeedResponse;
import microsoft.dynamics.crm.complex.GetFileSasUrlResponse;
import microsoft.dynamics.crm.complex.GetJobStatusResponse;
import microsoft.dynamics.crm.complex.GetNextAutoNumberValueResponse;
import microsoft.dynamics.crm.complex.GetTimeZoneCodeByLocalizedNameResponse;
import microsoft.dynamics.crm.complex.GetTrackingTokenEmailResponse;
import microsoft.dynamics.crm.complex.GetValidManyToManyResponse;
import microsoft.dynamics.crm.complex.GetValidReferencedEntitiesResponse;
import microsoft.dynamics.crm.complex.GetValidReferencingEntitiesResponse;
import microsoft.dynamics.crm.complex.ImmediateBookResponse;
import microsoft.dynamics.crm.complex.ImportCardTypeSchemaResponse;
import microsoft.dynamics.crm.complex.InitializeAnnotationBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeAnnotationBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InitializeAttachmentBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeAttachmentBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InitializeFileBlocksDownloadResponse;
import microsoft.dynamics.crm.complex.InitializeFileBlocksUploadResponse;
import microsoft.dynamics.crm.complex.InsertOptionValueResponse;
import microsoft.dynamics.crm.complex.InsertStatusValueResponse;
import microsoft.dynamics.crm.complex.IsComponentCustomizableResponse;
import microsoft.dynamics.crm.complex.IsDataEncryptionActiveResponse;
import microsoft.dynamics.crm.complex.IsPaiEnabledResponse;
import microsoft.dynamics.crm.complex.IsValidStateTransitionResponse;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.LayerDesiredOrder;
import microsoft.dynamics.crm.complex.LocalTimeFromUtcTimeResponse;
import microsoft.dynamics.crm.complex.LocalizedLabel;
import microsoft.dynamics.crm.complex.Msdyn_ActivateProcessesResponse;
import microsoft.dynamics.crm.complex.Msdyn_ActivateSdkMessageProcessingStepsResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedOptionSetResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedSitemapResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForCustomizedWebResourcesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedProcessResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForDeletedWebResourcesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckForPendingProcessesResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfProcessesAreActiveResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse;
import microsoft.dynamics.crm.complex.Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse;
import microsoft.dynamics.crm.complex.Msdyn_ConditionXmlConversionResponse;
import microsoft.dynamics.crm.complex.Msdyn_DeleteCalendarResponse;
import microsoft.dynamics.crm.complex.Msdyn_RegisterSolutionHealthRuleResponse;
import microsoft.dynamics.crm.complex.Msdyn_SaveCalendarResponse;
import microsoft.dynamics.crm.complex.PagingInfo;
import microsoft.dynamics.crm.complex.PrincipalAccess;
import microsoft.dynamics.crm.complex.QueryBase;
import microsoft.dynamics.crm.complex.QueryExpression;
import microsoft.dynamics.crm.complex.QueryExpressionToFetchXmlResponse;
import microsoft.dynamics.crm.complex.QueryScheduleResponse;
import microsoft.dynamics.crm.complex.RecognizeTextResponse;
import microsoft.dynamics.crm.complex.RemoveActiveCustomizationsResponse;
import microsoft.dynamics.crm.complex.RemoveSolutionComponentResponse;
import microsoft.dynamics.crm.complex.RescheduleResponse;
import microsoft.dynamics.crm.complex.RetrieveAccessOriginResponse;
import microsoft.dynamics.crm.complex.RetrieveAllEntitiesResponse;
import microsoft.dynamics.crm.complex.RetrieveAnalyticsStoreDetailsResponse;
import microsoft.dynamics.crm.complex.RetrieveAppSettingListResponse;
import microsoft.dynamics.crm.complex.RetrieveAppSettingResponse;
import microsoft.dynamics.crm.complex.RetrieveApplicationRibbonResponse;
import microsoft.dynamics.crm.complex.RetrieveAttributeChangeHistoryResponse;
import microsoft.dynamics.crm.complex.RetrieveAuditPartitionListResponse;
import microsoft.dynamics.crm.complex.RetrieveAvailableLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveChannelAccessProfilePrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrieveCurrentOrganizationResponse;
import microsoft.dynamics.crm.complex.RetrieveDataEncryptionKeyResponse;
import microsoft.dynamics.crm.complex.RetrieveDeploymentLicenseTypeResponse;
import microsoft.dynamics.crm.complex.RetrieveDeprovisionedLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveEntityResponse;
import microsoft.dynamics.crm.complex.RetrieveEntityRibbonResponse;
import microsoft.dynamics.crm.complex.RetrieveExchangeRateResponse;
import microsoft.dynamics.crm.complex.RetrieveFormattedImportJobResultsResponse;
import microsoft.dynamics.crm.complex.RetrieveInstalledLanguagePackVersionResponse;
import microsoft.dynamics.crm.complex.RetrieveInstalledLanguagePacksResponse;
import microsoft.dynamics.crm.complex.RetrieveLicenseInfoResponse;
import microsoft.dynamics.crm.complex.RetrieveLocLabelsResponse;
import microsoft.dynamics.crm.complex.RetrieveMailboxTrackingFoldersResponse;
import microsoft.dynamics.crm.complex.RetrieveMetadataChangesResponse;
import microsoft.dynamics.crm.complex.RetrieveMissingComponentsResponse;
import microsoft.dynamics.crm.complex.RetrieveOrganizationInfoResponse;
import microsoft.dynamics.crm.complex.RetrieveOrganizationResourcesResponse;
import microsoft.dynamics.crm.complex.RetrieveParsedDataImportFileResponse;
import microsoft.dynamics.crm.complex.RetrieveProvisionedLanguagePackVersionResponse;
import microsoft.dynamics.crm.complex.RetrieveProvisionedLanguagesResponse;
import microsoft.dynamics.crm.complex.RetrieveRecordChangeHistoryResponse;
import microsoft.dynamics.crm.complex.RetrieveRolePrivilegesRoleResponse;
import microsoft.dynamics.crm.complex.RetrieveSharedPrincipalsAndAccessResponse;
import microsoft.dynamics.crm.complex.RetrieveTimestampResponse;
import microsoft.dynamics.crm.complex.RetrieveTotalRecordCountResponse;
import microsoft.dynamics.crm.complex.RetrieveVersionResponse;
import microsoft.dynamics.crm.complex.SearchResponse;
import microsoft.dynamics.crm.complex.StageAndUpgradeResponse;
import microsoft.dynamics.crm.complex.SyncBulkOperationResponse;
import microsoft.dynamics.crm.complex.ValidateAIConfigurationResponse;
import microsoft.dynamics.crm.complex.ValidateAppResponse;
import microsoft.dynamics.crm.complex.ValidateFetchXmlExpressionResponse;
import microsoft.dynamics.crm.complex.ValidateRecurrenceRuleResponse;
import microsoft.dynamics.crm.complex.ValidateResponse;
import microsoft.dynamics.crm.complex.WhoAmIResponse;
import microsoft.dynamics.crm.entity.Activityparty;
import microsoft.dynamics.crm.entity.Activitypointer;
import microsoft.dynamics.crm.entity.Asyncoperation;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Dependency;
import microsoft.dynamics.crm.entity.Email;
import microsoft.dynamics.crm.entity.Importjob;
import microsoft.dynamics.crm.entity.Importmap;
import microsoft.dynamics.crm.entity.Msdyn_analysisjob;
import microsoft.dynamics.crm.entity.Msdyn_solutionhealthruleset;
import microsoft.dynamics.crm.entity.Processstage;
import microsoft.dynamics.crm.entity.Queueitem;
import microsoft.dynamics.crm.entity.Recurrencerule;
import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.Solutioncomponent;
import microsoft.dynamics.crm.entity.Workflow;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.AciviewmapperRequest;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActioncarduserstateRequest;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppconfiginstanceRequest;
import microsoft.dynamics.crm.entity.request.AppconfigmasterRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserroleRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AppmodulecomponentRequest;
import microsoft.dynamics.crm.entity.request.AppmodulerolesRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.AttachmentRequest;
import microsoft.dynamics.crm.entity.request.AttributeRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.AuditRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CalendarruleRequest;
import microsoft.dynamics.crm.entity.request.CallbackregistrationRequest;
import microsoft.dynamics.crm.entity.request.CanvasappRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.ChannelaccessprofileentityaccesslevelRequest;
import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.ComplexcontrolRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleassociationRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolRequest;
import microsoft.dynamics.crm.entity.request.CustomcontroldefaultconfigRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolresourceRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DataperformanceRequest;
import microsoft.dynamics.crm.entity.request.DependencyRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;
import microsoft.dynamics.crm.entity.request.DocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleconditionRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EntityMetadataRequest;
import microsoft.dynamics.crm.entity.request.EntityRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.EntitydataproviderRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.EntitykeyRequest;
import microsoft.dynamics.crm.entity.request.EntityrelationshipRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExchangesyncidmappingRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.FieldpermissionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.FixedmonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_ggw_crew_ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportentitymappingRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportjobRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;
import microsoft.dynamics.crm.entity.request.InvaliddependencyRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticlescategoriesRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LanguagelocaleRequest;
import microsoft.dynamics.crm.entity.request.LanguageprovisioningstateRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.LookupmappingRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.ManagedPropertyMetadataRequest;
import microsoft.dynamics.crm.entity.request.ManagedpropertyRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemassociationRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabel_msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_componentlayerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_componentlayerdatasourceRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_nonrelationaldsRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_odatav4dsRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutioncomponentdatasourceRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutioncomponentsummaryRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhistoryRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhistorydatasourceRequest;
import microsoft.dynamics.crm.entity.request.NavigationsettingRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.OfficegraphdocumentRequest;
import microsoft.dynamics.crm.entity.request.OptionSetMetadataBaseRequest;
import microsoft.dynamics.crm.entity.request.OptionsetRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.OwnermappingRequest;
import microsoft.dynamics.crm.entity.request.PersonaldocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PicklistmappingRequest;
import microsoft.dynamics.crm.entity.request.PluginassemblyRequest;
import microsoft.dynamics.crm.entity.request.PlugintracelogRequest;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.PlugintypestatisticRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalentitymapRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectaccessRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.PublisheraddressRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.QueuemembershipRequest;
import microsoft.dynamics.crm.entity.request.RecommendeddocumentRequest;
import microsoft.dynamics.crm.entity.request.RecurrenceruleRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.RelationshipMetadataBaseRequest;
import microsoft.dynamics.crm.entity.request.RelationshipRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.ReportcategoryRequest;
import microsoft.dynamics.crm.entity.request.RibbonmetadatatoprocessRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoleprivilegesRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateprivilegesRequest;
import microsoft.dynamics.crm.entity.request.RollupfieldRequest;
import microsoft.dynamics.crm.entity.request.RuntimedependencyRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepimageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepsecureconfigRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ServiceendpointRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanappmodulesRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SimilarityruleRequest;
import microsoft.dynamics.crm.entity.request.SitemapRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutionhistorydataRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionmanuallytrackedobjectRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionstatisticsofflineRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionstatisticsoutlookRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionsyncentryofflineRequest;
import microsoft.dynamics.crm.entity.request.SubscriptionsyncentryoutlookRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.SystemuserlicensesRequest;
import microsoft.dynamics.crm.entity.request.SystemuserprofilesRequest;
import microsoft.dynamics.crm.entity.request.SystemuserrolesRequest;
import microsoft.dynamics.crm.entity.request.SystemusersyncmappingprofilesRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TeammembershipRequest;
import microsoft.dynamics.crm.entity.request.TeamprofilesRequest;
import microsoft.dynamics.crm.entity.request.TeamrolesRequest;
import microsoft.dynamics.crm.entity.request.TeamsyncattributemappingprofilesRequest;
import microsoft.dynamics.crm.entity.request.TeamtemplateRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.TimestampdatemappingRequest;
import microsoft.dynamics.crm.entity.request.TimezonedefinitionRequest;
import microsoft.dynamics.crm.entity.request.TimezonelocalizednameRequest;
import microsoft.dynamics.crm.entity.request.TimezoneruleRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.TransformationmappingRequest;
import microsoft.dynamics.crm.entity.request.TransformationparametermappingRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.UserformRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;
import microsoft.dynamics.crm.entity.request.UserqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.UsersettingsRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;
import microsoft.dynamics.crm.entity.request.WebwizardRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;
import microsoft.dynamics.crm.entity.set.Accounts;
import microsoft.dynamics.crm.entity.set.Aciviewmappers;
import microsoft.dynamics.crm.entity.set.Actioncards;
import microsoft.dynamics.crm.entity.set.Actioncarduserstates;
import microsoft.dynamics.crm.entity.set.Activitymimeattachments;
import microsoft.dynamics.crm.entity.set.Activityparties;
import microsoft.dynamics.crm.entity.set.Activitypointers;
import microsoft.dynamics.crm.entity.set.Annotations;
import microsoft.dynamics.crm.entity.set.Annualfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Appconfiginstances;
import microsoft.dynamics.crm.entity.set.Appconfigmasters;
import microsoft.dynamics.crm.entity.set.Appconfigs;
import microsoft.dynamics.crm.entity.set.Applicationuserroleset;
import microsoft.dynamics.crm.entity.set.Applicationusers;
import microsoft.dynamics.crm.entity.set.Appmodulecomponents;
import microsoft.dynamics.crm.entity.set.Appmodulerolescollection;
import microsoft.dynamics.crm.entity.set.Appmodules;
import microsoft.dynamics.crm.entity.set.Appointments;
import microsoft.dynamics.crm.entity.set.Asyncoperations;
import microsoft.dynamics.crm.entity.set.Attachments;
import microsoft.dynamics.crm.entity.set.Attributeimageconfigs;
import microsoft.dynamics.crm.entity.set.Attributes;
import microsoft.dynamics.crm.entity.set.Audits;
import microsoft.dynamics.crm.entity.set.Bulkdeletefailures;
import microsoft.dynamics.crm.entity.set.Bulkdeleteoperations;
import microsoft.dynamics.crm.entity.set.Businessunitnewsarticles;
import microsoft.dynamics.crm.entity.set.Businessunits;
import microsoft.dynamics.crm.entity.set.Calendarrules;
import microsoft.dynamics.crm.entity.set.Calendars;
import microsoft.dynamics.crm.entity.set.Callbackregistrations;
import microsoft.dynamics.crm.entity.set.Canvasapps;
import microsoft.dynamics.crm.entity.set.Cascadegrantrevokeaccessrecordstrackers;
import microsoft.dynamics.crm.entity.set.Cascadegrantrevokeaccessversiontrackers;
import microsoft.dynamics.crm.entity.set.Categories;
import microsoft.dynamics.crm.entity.set.Channelaccessprofileentityaccesslevels;
import microsoft.dynamics.crm.entity.set.Columnmappings;
import microsoft.dynamics.crm.entity.set.Complexcontrols;
import microsoft.dynamics.crm.entity.set.Connectionreferences;
import microsoft.dynamics.crm.entity.set.Connectionroleassociations;
import microsoft.dynamics.crm.entity.set.Connectionroles;
import microsoft.dynamics.crm.entity.set.Connections;
import microsoft.dynamics.crm.entity.set.Connectors;
import microsoft.dynamics.crm.entity.set.Contacts;
import microsoft.dynamics.crm.entity.set.Customcontroldefaultconfigs;
import microsoft.dynamics.crm.entity.set.Customcontrolresources;
import microsoft.dynamics.crm.entity.set.Customcontrols;
import microsoft.dynamics.crm.entity.set.Customeraddresses;
import microsoft.dynamics.crm.entity.set.Datalakeworkspacepermissions;
import microsoft.dynamics.crm.entity.set.Datalakeworkspaces;
import microsoft.dynamics.crm.entity.set.Dataperformances;
import microsoft.dynamics.crm.entity.set.Dependencies;
import microsoft.dynamics.crm.entity.set.Displaystrings;
import microsoft.dynamics.crm.entity.set.Documenttemplates;
import microsoft.dynamics.crm.entity.set.Duplicaterecords;
import microsoft.dynamics.crm.entity.set.Duplicateruleconditions;
import microsoft.dynamics.crm.entity.set.Duplicaterules;
import microsoft.dynamics.crm.entity.set.Emails;
import microsoft.dynamics.crm.entity.set.Emailserverprofiles;
import microsoft.dynamics.crm.entity.set.Entities;
import microsoft.dynamics.crm.entity.set.EntityDefinitions;
import microsoft.dynamics.crm.entity.set.Entityanalyticsconfigs;
import microsoft.dynamics.crm.entity.set.Entitydataproviders;
import microsoft.dynamics.crm.entity.set.Entityimageconfigs;
import microsoft.dynamics.crm.entity.set.Entitykeys;
import microsoft.dynamics.crm.entity.set.Entityrelationships;
import microsoft.dynamics.crm.entity.set.Environmentvariabledefinitions;
import microsoft.dynamics.crm.entity.set.Environmentvariablevalues;
import microsoft.dynamics.crm.entity.set.Exchangesyncidmappings;
import microsoft.dynamics.crm.entity.set.Expiredprocesses;
import microsoft.dynamics.crm.entity.set.Exportsolutionuploads;
import microsoft.dynamics.crm.entity.set.Faxes;
import microsoft.dynamics.crm.entity.set.Feedback;
import microsoft.dynamics.crm.entity.set.Fieldpermissions;
import microsoft.dynamics.crm.entity.set.Fieldsecurityprofiles;
import microsoft.dynamics.crm.entity.set.Fileattachments;
import microsoft.dynamics.crm.entity.set.Fixedmonthlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Flowsessions;
import microsoft.dynamics.crm.entity.set.Ggw_crews;
import microsoft.dynamics.crm.entity.set.Ggw_events;
import microsoft.dynamics.crm.entity.set.Ggw_ggw_crew_ggw_teamset;
import microsoft.dynamics.crm.entity.set.Ggw_team_applications;
import microsoft.dynamics.crm.entity.set.Ggw_teams;
import microsoft.dynamics.crm.entity.set.GlobalOptionSetDefinitions;
import microsoft.dynamics.crm.entity.set.Goalrollupqueries;
import microsoft.dynamics.crm.entity.set.Goals;
import microsoft.dynamics.crm.entity.set.Importdataset;
import microsoft.dynamics.crm.entity.set.Importentitymappings;
import microsoft.dynamics.crm.entity.set.Importfiles;
import microsoft.dynamics.crm.entity.set.Importjobs;
import microsoft.dynamics.crm.entity.set.Importlogs;
import microsoft.dynamics.crm.entity.set.Importmaps;
import microsoft.dynamics.crm.entity.set.Imports;
import microsoft.dynamics.crm.entity.set.Interactionforemails;
import microsoft.dynamics.crm.entity.set.Invaliddependencies;
import microsoft.dynamics.crm.entity.set.Kbarticlecomments;
import microsoft.dynamics.crm.entity.set.Kbarticles;
import microsoft.dynamics.crm.entity.set.Kbarticletemplates;
import microsoft.dynamics.crm.entity.set.Knowledgearticlecategories;
import microsoft.dynamics.crm.entity.set.Knowledgearticles;
import microsoft.dynamics.crm.entity.set.Knowledgearticleviews;
import microsoft.dynamics.crm.entity.set.Knowledgebaserecords;
import microsoft.dynamics.crm.entity.set.Languagelocale;
import microsoft.dynamics.crm.entity.set.Languageprovisioningstates;
import microsoft.dynamics.crm.entity.set.Letters;
import microsoft.dynamics.crm.entity.set.Lookupmappings;
import microsoft.dynamics.crm.entity.set.Mailboxes;
import microsoft.dynamics.crm.entity.set.Mailboxtrackingfolders;
import microsoft.dynamics.crm.entity.set.Mailmergetemplates;
import microsoft.dynamics.crm.entity.set.ManagedPropertyDefinitions;
import microsoft.dynamics.crm.entity.set.Managedproperties;
import microsoft.dynamics.crm.entity.set.Metrics;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofileitemassociations;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofileitems;
import microsoft.dynamics.crm.entity.set.Mobileofflineprofiles;
import microsoft.dynamics.crm.entity.set.Monthlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetrecords;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasets;
import microsoft.dynamics.crm.entity.set.Msdyn_aibdatasetscontainers;
import microsoft.dynamics.crm.entity.set.Msdyn_aibfileattacheddatas;
import microsoft.dynamics.crm.entity.set.Msdyn_aibfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_aiconfigurations;
import microsoft.dynamics.crm.entity.set.Msdyn_aifptrainingdocuments;
import microsoft.dynamics.crm.entity.set.Msdyn_aimodels;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodimages;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodlabel_msdyn_aiconfigurationset;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodlabels;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodtrainingboundingboxes;
import microsoft.dynamics.crm.entity.set.Msdyn_aiodtrainingimages;
import microsoft.dynamics.crm.entity.set.Msdyn_aitemplates;
import microsoft.dynamics.crm.entity.set.Msdyn_analysiscomponents;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisjobs;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisresultdetails;
import microsoft.dynamics.crm.entity.set.Msdyn_analysisresults;
import microsoft.dynamics.crm.entity.set.Msdyn_componentlayerdatasources;
import microsoft.dynamics.crm.entity.set.Msdyn_componentlayers;
import microsoft.dynamics.crm.entity.set.Msdyn_dataflows;
import microsoft.dynamics.crm.entity.set.Msdyn_helppages;
import microsoft.dynamics.crm.entity.set.Msdyn_knowledgearticleimages;
import microsoft.dynamics.crm.entity.set.Msdyn_knowledgearticletemplates;
import microsoft.dynamics.crm.entity.set.Msdyn_nonrelationaldses;
import microsoft.dynamics.crm.entity.set.Msdyn_odatav4ds;
import microsoft.dynamics.crm.entity.set.Msdyn_richtextfiles;
import microsoft.dynamics.crm.entity.set.Msdyn_serviceconfigurations;
import microsoft.dynamics.crm.entity.set.Msdyn_slakpis;
import microsoft.dynamics.crm.entity.set.Msdyn_solutioncomponentdatasources;
import microsoft.dynamics.crm.entity.set.Msdyn_solutioncomponentsummaries;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrulearguments;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrules;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhealthrulesets;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhistories;
import microsoft.dynamics.crm.entity.set.Msdyn_solutionhistorydatasources;
import microsoft.dynamics.crm.entity.set.Navigationsettings;
import microsoft.dynamics.crm.entity.set.Newprocesses;
import microsoft.dynamics.crm.entity.set.Officegraphdocuments;
import microsoft.dynamics.crm.entity.set.Optionsets;
import microsoft.dynamics.crm.entity.set.Organizations;
import microsoft.dynamics.crm.entity.set.Ownermappings;
import microsoft.dynamics.crm.entity.set.Personaldocumenttemplates;
import microsoft.dynamics.crm.entity.set.Phonecalls;
import microsoft.dynamics.crm.entity.set.Picklistmappings;
import microsoft.dynamics.crm.entity.set.Pluginassemblies;
import microsoft.dynamics.crm.entity.set.Plugintracelogs;
import microsoft.dynamics.crm.entity.set.Plugintypes;
import microsoft.dynamics.crm.entity.set.Plugintypestatistics;
import microsoft.dynamics.crm.entity.set.Positions;
import microsoft.dynamics.crm.entity.set.Postcomments;
import microsoft.dynamics.crm.entity.set.Postfollows;
import microsoft.dynamics.crm.entity.set.Postlikes;
import microsoft.dynamics.crm.entity.set.Postregardings;
import microsoft.dynamics.crm.entity.set.Posts;
import microsoft.dynamics.crm.entity.set.Principalentitymaps;
import microsoft.dynamics.crm.entity.set.Principalobjectaccessset;
import microsoft.dynamics.crm.entity.set.Principalobjectattributeaccessset;
import microsoft.dynamics.crm.entity.set.Privileges;
import microsoft.dynamics.crm.entity.set.Processsessions;
import microsoft.dynamics.crm.entity.set.Processstageparameters;
import microsoft.dynamics.crm.entity.set.Processstages;
import microsoft.dynamics.crm.entity.set.Processtriggers;
import microsoft.dynamics.crm.entity.set.Publisheraddresses;
import microsoft.dynamics.crm.entity.set.Publishers;
import microsoft.dynamics.crm.entity.set.Quarterlyfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Queueitems;
import microsoft.dynamics.crm.entity.set.Queuememberships;
import microsoft.dynamics.crm.entity.set.Queues;
import microsoft.dynamics.crm.entity.set.Recommendeddocuments;
import microsoft.dynamics.crm.entity.set.Recurrencerules;
import microsoft.dynamics.crm.entity.set.Recurringappointmentmasters;
import microsoft.dynamics.crm.entity.set.RelationshipDefinitions;
import microsoft.dynamics.crm.entity.set.Relationshipattributes;
import microsoft.dynamics.crm.entity.set.Relationships;
import microsoft.dynamics.crm.entity.set.Reportcategories;
import microsoft.dynamics.crm.entity.set.Reports;
import microsoft.dynamics.crm.entity.set.Ribbonmetadatasettoprocess;
import microsoft.dynamics.crm.entity.set.Roleprivilegescollection;
import microsoft.dynamics.crm.entity.set.Roles;
import microsoft.dynamics.crm.entity.set.Roletemplateprivilegescollection;
import microsoft.dynamics.crm.entity.set.Roletemplates;
import microsoft.dynamics.crm.entity.set.Rollupfields;
import microsoft.dynamics.crm.entity.set.Runtimedependencies;
import microsoft.dynamics.crm.entity.set.Savedqueries;
import microsoft.dynamics.crm.entity.set.Savedqueryvisualizations;
import microsoft.dynamics.crm.entity.set.Sdkmessagefilters;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingstepimages;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingsteps;
import microsoft.dynamics.crm.entity.set.Sdkmessageprocessingstepsecureconfigs;
import microsoft.dynamics.crm.entity.set.Sdkmessages;
import microsoft.dynamics.crm.entity.set.Semiannualfiscalcalendars;
import microsoft.dynamics.crm.entity.set.Serviceendpoints;
import microsoft.dynamics.crm.entity.set.Serviceplanappmodulesset;
import microsoft.dynamics.crm.entity.set.Serviceplans;
import microsoft.dynamics.crm.entity.set.Sharepointdocumentlocations;
import microsoft.dynamics.crm.entity.set.Sharepointsites;
import microsoft.dynamics.crm.entity.set.Similarityrules;
import microsoft.dynamics.crm.entity.set.Sitemaps;
import microsoft.dynamics.crm.entity.set.Slaitems;
import microsoft.dynamics.crm.entity.set.Slakpiinstances;
import microsoft.dynamics.crm.entity.set.Slas;
import microsoft.dynamics.crm.entity.set.Socialactivities;
import microsoft.dynamics.crm.entity.set.Socialprofiles;
import microsoft.dynamics.crm.entity.set.Solutioncomponentattributeconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponentconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponentrelationshipconfigurations;
import microsoft.dynamics.crm.entity.set.Solutioncomponents;
import microsoft.dynamics.crm.entity.set.Solutionhistories;
import microsoft.dynamics.crm.entity.set.Solutions;
import microsoft.dynamics.crm.entity.set.Stagesolutionuploads;
import microsoft.dynamics.crm.entity.set.Subjects;
import microsoft.dynamics.crm.entity.set.Subscriptionmanuallytrackedobjects;
import microsoft.dynamics.crm.entity.set.Subscriptionstatisticsofflineset;
import microsoft.dynamics.crm.entity.set.Subscriptionstatisticsoutlookset;
import microsoft.dynamics.crm.entity.set.Subscriptionsyncentriesoffline;
import microsoft.dynamics.crm.entity.set.Subscriptionsyncentriesoutlook;
import microsoft.dynamics.crm.entity.set.Syncerrors;
import microsoft.dynamics.crm.entity.set.Systemforms;
import microsoft.dynamics.crm.entity.set.Systemuserlicensescollection;
import microsoft.dynamics.crm.entity.set.Systemuserprofilescollection;
import microsoft.dynamics.crm.entity.set.Systemuserrolescollection;
import microsoft.dynamics.crm.entity.set.Systemusers;
import microsoft.dynamics.crm.entity.set.Systemusersyncmappingprofilescollection;
import microsoft.dynamics.crm.entity.set.Tasks;
import microsoft.dynamics.crm.entity.set.Teammemberships;
import microsoft.dynamics.crm.entity.set.Teamprofilescollection;
import microsoft.dynamics.crm.entity.set.Teamrolescollection;
import microsoft.dynamics.crm.entity.set.Teams;
import microsoft.dynamics.crm.entity.set.Teamsyncattributemappingprofilescollection;
import microsoft.dynamics.crm.entity.set.Teamtemplates;
import microsoft.dynamics.crm.entity.set.Templates;
import microsoft.dynamics.crm.entity.set.Territories;
import microsoft.dynamics.crm.entity.set.Themes;
import microsoft.dynamics.crm.entity.set.Timestampdatemappings;
import microsoft.dynamics.crm.entity.set.Timezonedefinitions;
import microsoft.dynamics.crm.entity.set.Timezonelocalizednames;
import microsoft.dynamics.crm.entity.set.Timezonerules;
import microsoft.dynamics.crm.entity.set.Tracelogs;
import microsoft.dynamics.crm.entity.set.Transactioncurrencies;
import microsoft.dynamics.crm.entity.set.Transformationmappings;
import microsoft.dynamics.crm.entity.set.Transformationparametermappings;
import microsoft.dynamics.crm.entity.set.Translationprocesses;
import microsoft.dynamics.crm.entity.set.Userforms;
import microsoft.dynamics.crm.entity.set.Usermappings;
import microsoft.dynamics.crm.entity.set.Userqueries;
import microsoft.dynamics.crm.entity.set.Userqueryvisualizations;
import microsoft.dynamics.crm.entity.set.Usersettingscollection;
import microsoft.dynamics.crm.entity.set.Webresourceset;
import microsoft.dynamics.crm.entity.set.Webwizards;
import microsoft.dynamics.crm.entity.set.Workflowbinaries;
import microsoft.dynamics.crm.entity.set.Workflowlogs;
import microsoft.dynamics.crm.entity.set.Workflows;
import microsoft.dynamics.crm.enums.DeletedMetadataFilters;
import microsoft.dynamics.crm.enums.EndpointAccessType;
import microsoft.dynamics.crm.enums.EntityFilters;
import microsoft.dynamics.crm.enums.RibbonLocationFilters;
import microsoft.dynamics.crm.enums.RollupType;
import microsoft.dynamics.crm.enums.TargetFieldType;
import microsoft.dynamics.crm.enums.TimeCode;

public final class System implements HasContext {

    private final ContextPath contextPath;

    public System(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<System> {

        @Override
        public System _create(Context context) {
            return new System(context);
        }
    }

    public static BuilderBase<ContainerBuilder<System>, System> test() {
        return new ContainerBuilderImpl();
    }

    public Accounts accounts() {
        return new Accounts(
                        contextPath.addSegment("accounts"));
    }

    public AccountRequest accounts(String accountid) {
        return new AccountRequest(contextPath.addSegment("accounts").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public Aciviewmappers aciviewmappers() {
        return new Aciviewmappers(
                        contextPath.addSegment("aciviewmappers"));
    }

    public AciviewmapperRequest aciviewmappers(String aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("aciviewmappers").addKeys(new NameValue(aciviewmapperid.toString())), Optional.empty());
    }

    public Actioncards actioncards() {
        return new Actioncards(
                        contextPath.addSegment("actioncards"));
    }

    public ActioncardRequest actioncards(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("actioncards").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public Actioncarduserstates actioncarduserstates() {
        return new Actioncarduserstates(
                        contextPath.addSegment("actioncarduserstates"));
    }

    public ActioncarduserstateRequest actioncarduserstates(String actioncarduserstateid) {
        return new ActioncarduserstateRequest(contextPath.addSegment("actioncarduserstates").addKeys(new NameValue(actioncarduserstateid.toString())), Optional.empty());
    }

    public Activitymimeattachments activitymimeattachments() {
        return new Activitymimeattachments(
                        contextPath.addSegment("activitymimeattachments"));
    }

    public ActivitymimeattachmentRequest activitymimeattachments(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("activitymimeattachments").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

    public Activityparties activityparties() {
        return new Activityparties(
                        contextPath.addSegment("activityparties"));
    }

    public ActivitypartyRequest activityparties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("activityparties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public Activitypointers activitypointers() {
        return new Activitypointers(
                        contextPath.addSegment("activitypointers"));
    }

    public ActivitypointerRequest activitypointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("activitypointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Annotations annotations() {
        return new Annotations(
                        contextPath.addSegment("annotations"));
    }

    public AnnotationRequest annotations(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("annotations").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public Annualfiscalcalendars annualfiscalcalendars() {
        return new Annualfiscalcalendars(
                        contextPath.addSegment("annualfiscalcalendars"));
    }

    public AnnualfiscalcalendarRequest annualfiscalcalendars(String userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("annualfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid.toString())), Optional.empty());
    }

    public Appconfiginstances appconfiginstances() {
        return new Appconfiginstances(
                        contextPath.addSegment("appconfiginstances"));
    }

    public AppconfiginstanceRequest appconfiginstances(String appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("appconfiginstances").addKeys(new NameValue(appconfiginstanceid.toString())), Optional.empty());
    }

    public Appconfigmasters appconfigmasters() {
        return new Appconfigmasters(
                        contextPath.addSegment("appconfigmasters"));
    }

    public AppconfigmasterRequest appconfigmasters(String appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("appconfigmasters").addKeys(new NameValue(appconfigmasterid.toString())), Optional.empty());
    }

    public Appconfigs appconfigs() {
        return new Appconfigs(
                        contextPath.addSegment("appconfigs"));
    }

    public AppconfigRequest appconfigs(String appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("appconfigs").addKeys(new NameValue(appconfigid.toString())), Optional.empty());
    }

    public Applicationuserroleset applicationuserroleset() {
        return new Applicationuserroleset(
                        contextPath.addSegment("applicationuserroleset"));
    }

    public ApplicationuserroleRequest applicationuserroleset(String applicationuserroleid) {
        return new ApplicationuserroleRequest(contextPath.addSegment("applicationuserroleset").addKeys(new NameValue(applicationuserroleid.toString())), Optional.empty());
    }

    public Applicationusers applicationusers() {
        return new Applicationusers(
                        contextPath.addSegment("applicationusers"));
    }

    public ApplicationuserRequest applicationusers(String applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("applicationusers").addKeys(new NameValue(applicationuserid.toString())), Optional.empty());
    }

    public Appmodulecomponents appmodulecomponents() {
        return new Appmodulecomponents(
                        contextPath.addSegment("appmodulecomponents"));
    }

    public AppmodulecomponentRequest appmodulecomponents(String appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodulecomponents").addKeys(new NameValue(appmodulecomponentid.toString())), Optional.empty());
    }

    public Appmodulerolescollection appmodulerolescollection() {
        return new Appmodulerolescollection(
                        contextPath.addSegment("appmodulerolescollection"));
    }

    public AppmodulerolesRequest appmodulerolescollection(String appmoduleroleid) {
        return new AppmodulerolesRequest(contextPath.addSegment("appmodulerolescollection").addKeys(new NameValue(appmoduleroleid.toString())), Optional.empty());
    }

    public Appmodules appmodules() {
        return new Appmodules(
                        contextPath.addSegment("appmodules"));
    }

    public AppmoduleRequest appmodules(String appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("appmodules").addKeys(new NameValue(appmoduleid.toString())), Optional.empty());
    }

    public Appointments appointments() {
        return new Appointments(
                        contextPath.addSegment("appointments"));
    }

    public AppointmentRequest appointments(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("appointments").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Asyncoperations asyncoperations() {
        return new Asyncoperations(
                        contextPath.addSegment("asyncoperations"));
    }

    public AsyncoperationRequest asyncoperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public Attachments attachments() {
        return new Attachments(
                        contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String attachmentid) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(attachmentid.toString())), Optional.empty());
    }

    public Attributeimageconfigs attributeimageconfigs() {
        return new Attributeimageconfigs(
                        contextPath.addSegment("attributeimageconfigs"));
    }

    public AttributeimageconfigRequest attributeimageconfigs(String attributeimageconfigid) {
        return new AttributeimageconfigRequest(contextPath.addSegment("attributeimageconfigs").addKeys(new NameValue(attributeimageconfigid.toString())), Optional.empty());
    }

    public Attributes attributes() {
        return new Attributes(
                        contextPath.addSegment("attributes"));
    }

    public AttributeRequest attributes(String attributeid) {
        return new AttributeRequest(contextPath.addSegment("attributes").addKeys(new NameValue(attributeid.toString())), Optional.empty());
    }

    public Audits audits() {
        return new Audits(
                        contextPath.addSegment("audits"));
    }

    public AuditRequest audits(String auditid) {
        return new AuditRequest(contextPath.addSegment("audits").addKeys(new NameValue(auditid.toString())), Optional.empty());
    }

    public Bulkdeletefailures bulkdeletefailures() {
        return new Bulkdeletefailures(
                        contextPath.addSegment("bulkdeletefailures"));
    }

    public BulkdeletefailureRequest bulkdeletefailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("bulkdeletefailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public Bulkdeleteoperations bulkdeleteoperations() {
        return new Bulkdeleteoperations(
                        contextPath.addSegment("bulkdeleteoperations"));
    }

    public BulkdeleteoperationRequest bulkdeleteoperations(String bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("bulkdeleteoperations").addKeys(new NameValue(bulkdeleteoperationid.toString())), Optional.empty());
    }

    public Businessunitnewsarticles businessunitnewsarticles() {
        return new Businessunitnewsarticles(
                        contextPath.addSegment("businessunitnewsarticles"));
    }

    public BusinessunitnewsarticleRequest businessunitnewsarticles(String businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("businessunitnewsarticles").addKeys(new NameValue(businessunitnewsarticleid.toString())), Optional.empty());
    }

    public Businessunits businessunits() {
        return new Businessunits(
                        contextPath.addSegment("businessunits"));
    }

    public BusinessunitRequest businessunits(String businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("businessunits").addKeys(new NameValue(businessunitid.toString())), Optional.empty());
    }

    public Calendarrules calendarrules() {
        return new Calendarrules(
                        contextPath.addSegment("calendarrules"));
    }

    public CalendarruleRequest calendarrules(String calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("calendarrules").addKeys(new NameValue(calendarruleid.toString())), Optional.empty());
    }

    public Calendars calendars() {
        return new Calendars(
                        contextPath.addSegment("calendars"));
    }

    public CalendarRequest calendars(String calendarid) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(calendarid.toString())), Optional.empty());
    }

    public Callbackregistrations callbackregistrations() {
        return new Callbackregistrations(
                        contextPath.addSegment("callbackregistrations"));
    }

    public CallbackregistrationRequest callbackregistrations(String callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("callbackregistrations").addKeys(new NameValue(callbackregistrationid.toString())), Optional.empty());
    }

    public Canvasapps canvasapps() {
        return new Canvasapps(
                        contextPath.addSegment("canvasapps"));
    }

    public CanvasappRequest canvasapps(String canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("canvasapps").addKeys(new NameValue(canvasappid.toString())), Optional.empty());
    }

    public Cascadegrantrevokeaccessrecordstrackers cascadegrantrevokeaccessrecordstrackers() {
        return new Cascadegrantrevokeaccessrecordstrackers(
                        contextPath.addSegment("cascadegrantrevokeaccessrecordstrackers"));
    }

    public CascadegrantrevokeaccessrecordstrackerRequest cascadegrantrevokeaccessrecordstrackers(String cascadegrantrevokeaccessrecordstrackerid) {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("cascadegrantrevokeaccessrecordstrackers").addKeys(new NameValue(cascadegrantrevokeaccessrecordstrackerid.toString())), Optional.empty());
    }

    public Cascadegrantrevokeaccessversiontrackers cascadegrantrevokeaccessversiontrackers() {
        return new Cascadegrantrevokeaccessversiontrackers(
                        contextPath.addSegment("cascadegrantrevokeaccessversiontrackers"));
    }

    public CascadegrantrevokeaccessversiontrackerRequest cascadegrantrevokeaccessversiontrackers(String cascadegrantrevokeaccessversiontrackerid) {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("cascadegrantrevokeaccessversiontrackers").addKeys(new NameValue(cascadegrantrevokeaccessversiontrackerid.toString())), Optional.empty());
    }

    public Categories categories() {
        return new Categories(
                        contextPath.addSegment("categories"));
    }

    public CategoryRequest categories(String categoryid) {
        return new CategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(categoryid.toString())), Optional.empty());
    }

    public Channelaccessprofileentityaccesslevels channelaccessprofileentityaccesslevels() {
        return new Channelaccessprofileentityaccesslevels(
                        contextPath.addSegment("channelaccessprofileentityaccesslevels"));
    }

    public ChannelaccessprofileentityaccesslevelRequest channelaccessprofileentityaccesslevels(String channelaccessprofileentityaccesslevelid) {
        return new ChannelaccessprofileentityaccesslevelRequest(contextPath.addSegment("channelaccessprofileentityaccesslevels").addKeys(new NameValue(channelaccessprofileentityaccesslevelid.toString())), Optional.empty());
    }

    public Columnmappings columnmappings() {
        return new Columnmappings(
                        contextPath.addSegment("columnmappings"));
    }

    public ColumnmappingRequest columnmappings(String columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("columnmappings").addKeys(new NameValue(columnmappingid.toString())), Optional.empty());
    }

    public Complexcontrols complexcontrols() {
        return new Complexcontrols(
                        contextPath.addSegment("complexcontrols"));
    }

    public ComplexcontrolRequest complexcontrols(String complexcontrolid) {
        return new ComplexcontrolRequest(contextPath.addSegment("complexcontrols").addKeys(new NameValue(complexcontrolid.toString())), Optional.empty());
    }

    public Connectionreferences connectionreferences() {
        return new Connectionreferences(
                        contextPath.addSegment("connectionreferences"));
    }

    public ConnectionreferenceRequest connectionreferences(String connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("connectionreferences").addKeys(new NameValue(connectionreferenceid.toString())), Optional.empty());
    }

    public Connectionroleassociations connectionroleassociations() {
        return new Connectionroleassociations(
                        contextPath.addSegment("connectionroleassociations"));
    }

    public ConnectionroleassociationRequest connectionroleassociations(String connectionroleassociationid) {
        return new ConnectionroleassociationRequest(contextPath.addSegment("connectionroleassociations").addKeys(new NameValue(connectionroleassociationid.toString())), Optional.empty());
    }

    public Connectionroles connectionroles() {
        return new Connectionroles(
                        contextPath.addSegment("connectionroles"));
    }

    public ConnectionroleRequest connectionroles(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroles").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

    public Connections connections() {
        return new Connections(
                        contextPath.addSegment("connections"));
    }

    public ConnectionRequest connections(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connections").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public Connectors connectors() {
        return new Connectors(
                        contextPath.addSegment("connectors"));
    }

    public ConnectorRequest connectors(String connectorid) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(connectorid.toString())), Optional.empty());
    }

    public Contacts contacts() {
        return new Contacts(
                        contextPath.addSegment("contacts"));
    }

    public ContactRequest contacts(String contactid) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public Customcontroldefaultconfigs customcontroldefaultconfigs() {
        return new Customcontroldefaultconfigs(
                        contextPath.addSegment("customcontroldefaultconfigs"));
    }

    public CustomcontroldefaultconfigRequest customcontroldefaultconfigs(String customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("customcontroldefaultconfigs").addKeys(new NameValue(customcontroldefaultconfigid.toString())), Optional.empty());
    }

    public Customcontrolresources customcontrolresources() {
        return new Customcontrolresources(
                        contextPath.addSegment("customcontrolresources"));
    }

    public CustomcontrolresourceRequest customcontrolresources(String customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrolresources").addKeys(new NameValue(customcontrolresourceid.toString())), Optional.empty());
    }

    public Customcontrols customcontrols() {
        return new Customcontrols(
                        contextPath.addSegment("customcontrols"));
    }

    public CustomcontrolRequest customcontrols(String customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("customcontrols").addKeys(new NameValue(customcontrolid.toString())), Optional.empty());
    }

    public Customeraddresses customeraddresses() {
        return new Customeraddresses(
                        contextPath.addSegment("customeraddresses"));
    }

    public CustomeraddressRequest customeraddresses(String customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("customeraddresses").addKeys(new NameValue(customeraddressid.toString())), Optional.empty());
    }

    public Datalakeworkspacepermissions datalakeworkspacepermissions() {
        return new Datalakeworkspacepermissions(
                        contextPath.addSegment("datalakeworkspacepermissions"));
    }

    public DatalakeworkspacepermissionRequest datalakeworkspacepermissions(String datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("datalakeworkspacepermissions").addKeys(new NameValue(datalakeworkspacepermissionid.toString())), Optional.empty());
    }

    public Datalakeworkspaces datalakeworkspaces() {
        return new Datalakeworkspaces(
                        contextPath.addSegment("datalakeworkspaces"));
    }

    public DatalakeworkspaceRequest datalakeworkspaces(String datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("datalakeworkspaces").addKeys(new NameValue(datalakeworkspaceid.toString())), Optional.empty());
    }

    public Dataperformances dataperformances() {
        return new Dataperformances(
                        contextPath.addSegment("dataperformances"));
    }

    public DataperformanceRequest dataperformances(String dataperformanceid) {
        return new DataperformanceRequest(contextPath.addSegment("dataperformances").addKeys(new NameValue(dataperformanceid.toString())), Optional.empty());
    }

    public Dependencies dependencies() {
        return new Dependencies(
                        contextPath.addSegment("dependencies"));
    }

    public DependencyRequest dependencies(String dependencyid) {
        return new DependencyRequest(contextPath.addSegment("dependencies").addKeys(new NameValue(dependencyid.toString())), Optional.empty());
    }

    public Displaystrings displaystrings() {
        return new Displaystrings(
                        contextPath.addSegment("displaystrings"));
    }

    public DisplaystringRequest displaystrings(String displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("displaystrings").addKeys(new NameValue(displaystringid.toString())), Optional.empty());
    }

    public Documenttemplates documenttemplates() {
        return new Documenttemplates(
                        contextPath.addSegment("documenttemplates"));
    }

    public DocumenttemplateRequest documenttemplates(String documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("documenttemplates").addKeys(new NameValue(documenttemplateid.toString())), Optional.empty());
    }

    public Duplicaterecords duplicaterecords() {
        return new Duplicaterecords(
                        contextPath.addSegment("duplicaterecords"));
    }

    public DuplicaterecordRequest duplicaterecords(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("duplicaterecords").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public Duplicateruleconditions duplicateruleconditions() {
        return new Duplicateruleconditions(
                        contextPath.addSegment("duplicateruleconditions"));
    }

    public DuplicateruleconditionRequest duplicateruleconditions(String duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("duplicateruleconditions").addKeys(new NameValue(duplicateruleconditionid.toString())), Optional.empty());
    }

    public Duplicaterules duplicaterules() {
        return new Duplicaterules(
                        contextPath.addSegment("duplicaterules"));
    }

    public DuplicateruleRequest duplicaterules(String duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("duplicaterules").addKeys(new NameValue(duplicateruleid.toString())), Optional.empty());
    }

    public Emails emails() {
        return new Emails(
                        contextPath.addSegment("emails"));
    }

    public EmailRequest emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Emailserverprofiles emailserverprofiles() {
        return new Emailserverprofiles(
                        contextPath.addSegment("emailserverprofiles"));
    }

    public EmailserverprofileRequest emailserverprofiles(String emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("emailserverprofiles").addKeys(new NameValue(emailserverprofileid.toString())), Optional.empty());
    }

    public Entities entities() {
        return new Entities(
                        contextPath.addSegment("entities"));
    }

    public EntityRequest entities(String entityid) {
        return new EntityRequest(contextPath.addSegment("entities").addKeys(new NameValue(entityid.toString())), Optional.empty());
    }

    public Entityanalyticsconfigs entityanalyticsconfigs() {
        return new Entityanalyticsconfigs(
                        contextPath.addSegment("entityanalyticsconfigs"));
    }

    public EntityanalyticsconfigRequest entityanalyticsconfigs(String entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("entityanalyticsconfigs").addKeys(new NameValue(entityanalyticsconfigid.toString())), Optional.empty());
    }

    public Entitydataproviders entitydataproviders() {
        return new Entitydataproviders(
                        contextPath.addSegment("entitydataproviders"));
    }

    public EntitydataproviderRequest entitydataproviders(String entitydataproviderid) {
        return new EntitydataproviderRequest(contextPath.addSegment("entitydataproviders").addKeys(new NameValue(entitydataproviderid.toString())), Optional.empty());
    }

    public Entityimageconfigs entityimageconfigs() {
        return new Entityimageconfigs(
                        contextPath.addSegment("entityimageconfigs"));
    }

    public EntityimageconfigRequest entityimageconfigs(String entityimageconfigid) {
        return new EntityimageconfigRequest(contextPath.addSegment("entityimageconfigs").addKeys(new NameValue(entityimageconfigid.toString())), Optional.empty());
    }

    public Entitykeys entitykeys() {
        return new Entitykeys(
                        contextPath.addSegment("entitykeys"));
    }

    public EntitykeyRequest entitykeys(String entitykeyid) {
        return new EntitykeyRequest(contextPath.addSegment("entitykeys").addKeys(new NameValue(entitykeyid.toString())), Optional.empty());
    }

    public Entityrelationships entityrelationships() {
        return new Entityrelationships(
                        contextPath.addSegment("entityrelationships"));
    }

    public EntityrelationshipRequest entityrelationships(String entityrelationshipid) {
        return new EntityrelationshipRequest(contextPath.addSegment("entityrelationships").addKeys(new NameValue(entityrelationshipid.toString())), Optional.empty());
    }

    public Environmentvariabledefinitions environmentvariabledefinitions() {
        return new Environmentvariabledefinitions(
                        contextPath.addSegment("environmentvariabledefinitions"));
    }

    public EnvironmentvariabledefinitionRequest environmentvariabledefinitions(String environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("environmentvariabledefinitions").addKeys(new NameValue(environmentvariabledefinitionid.toString())), Optional.empty());
    }

    public Environmentvariablevalues environmentvariablevalues() {
        return new Environmentvariablevalues(
                        contextPath.addSegment("environmentvariablevalues"));
    }

    public EnvironmentvariablevalueRequest environmentvariablevalues(String environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("environmentvariablevalues").addKeys(new NameValue(environmentvariablevalueid.toString())), Optional.empty());
    }

    public Exchangesyncidmappings exchangesyncidmappings() {
        return new Exchangesyncidmappings(
                        contextPath.addSegment("exchangesyncidmappings"));
    }

    public ExchangesyncidmappingRequest exchangesyncidmappings(String exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("exchangesyncidmappings").addKeys(new NameValue(exchangesyncidmappingid.toString())), Optional.empty());
    }

    public Expiredprocesses expiredprocesses() {
        return new Expiredprocesses(
                        contextPath.addSegment("expiredprocesses"));
    }

    public ExpiredprocessRequest expiredprocesses(String businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("expiredprocesses").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public Exportsolutionuploads exportsolutionuploads() {
        return new Exportsolutionuploads(
                        contextPath.addSegment("exportsolutionuploads"));
    }

    public ExportsolutionuploadRequest exportsolutionuploads(String exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("exportsolutionuploads").addKeys(new NameValue(exportsolutionuploadid.toString())), Optional.empty());
    }

    public Faxes faxes() {
        return new Faxes(
                        contextPath.addSegment("faxes"));
    }

    public FaxRequest faxes(String activityid) {
        return new FaxRequest(contextPath.addSegment("faxes").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Feedback feedback() {
        return new Feedback(
                        contextPath.addSegment("feedback"));
    }

    public FeedbackRequest feedback(String feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("feedback").addKeys(new NameValue(feedbackid.toString())), Optional.empty());
    }

    public Fieldpermissions fieldpermissions() {
        return new Fieldpermissions(
                        contextPath.addSegment("fieldpermissions"));
    }

    public FieldpermissionRequest fieldpermissions(String fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("fieldpermissions").addKeys(new NameValue(fieldpermissionid.toString())), Optional.empty());
    }

    public Fieldsecurityprofiles fieldsecurityprofiles() {
        return new Fieldsecurityprofiles(
                        contextPath.addSegment("fieldsecurityprofiles"));
    }

    public FieldsecurityprofileRequest fieldsecurityprofiles(String fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("fieldsecurityprofiles").addKeys(new NameValue(fieldsecurityprofileid.toString())), Optional.empty());
    }

    public Fileattachments fileattachments() {
        return new Fileattachments(
                        contextPath.addSegment("fileattachments"));
    }

    public FileattachmentRequest fileattachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("fileattachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public Fixedmonthlyfiscalcalendars fixedmonthlyfiscalcalendars() {
        return new Fixedmonthlyfiscalcalendars(
                        contextPath.addSegment("fixedmonthlyfiscalcalendars"));
    }

    public FixedmonthlyfiscalcalendarRequest fixedmonthlyfiscalcalendars(String userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("fixedmonthlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid.toString())), Optional.empty());
    }

    public Flowsessions flowsessions() {
        return new Flowsessions(
                        contextPath.addSegment("flowsessions"));
    }

    public FlowsessionRequest flowsessions(String flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("flowsessions").addKeys(new NameValue(flowsessionid.toString())), Optional.empty());
    }

    public Ggw_crews ggw_crews() {
        return new Ggw_crews(
                        contextPath.addSegment("ggw_crews"));
    }

    public Ggw_crewRequest ggw_crews(String ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("ggw_crews").addKeys(new NameValue(ggw_crewid.toString())), Optional.empty());
    }

    public Ggw_events ggw_events() {
        return new Ggw_events(
                        contextPath.addSegment("ggw_events"));
    }

    public Ggw_eventRequest ggw_events(String ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("ggw_events").addKeys(new NameValue(ggw_eventid.toString())), Optional.empty());
    }

    public Ggw_ggw_crew_ggw_teamset ggw_ggw_crew_ggw_teamset() {
        return new Ggw_ggw_crew_ggw_teamset(
                        contextPath.addSegment("ggw_ggw_crew_ggw_teamset"));
    }

    public Ggw_ggw_crew_ggw_teamRequest ggw_ggw_crew_ggw_teamset(String ggw_ggw_crew_ggw_teamid) {
        return new Ggw_ggw_crew_ggw_teamRequest(contextPath.addSegment("ggw_ggw_crew_ggw_teamset").addKeys(new NameValue(ggw_ggw_crew_ggw_teamid.toString())), Optional.empty());
    }

    public Ggw_team_applications ggw_team_applications() {
        return new Ggw_team_applications(
                        contextPath.addSegment("ggw_team_applications"));
    }

    public Ggw_team_applicationRequest ggw_team_applications(String ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("ggw_team_applications").addKeys(new NameValue(ggw_team_applicationid.toString())), Optional.empty());
    }

    public Ggw_teams ggw_teams() {
        return new Ggw_teams(
                        contextPath.addSegment("ggw_teams"));
    }

    public Ggw_teamRequest ggw_teams(String ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("ggw_teams").addKeys(new NameValue(ggw_teamid.toString())), Optional.empty());
    }

    public Goalrollupqueries goalrollupqueries() {
        return new Goalrollupqueries(
                        contextPath.addSegment("goalrollupqueries"));
    }

    public GoalrollupqueryRequest goalrollupqueries(String goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("goalrollupqueries").addKeys(new NameValue(goalrollupqueryid.toString())), Optional.empty());
    }

    public Goals goals() {
        return new Goals(
                        contextPath.addSegment("goals"));
    }

    public GoalRequest goals(String goalid) {
        return new GoalRequest(contextPath.addSegment("goals").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public Importdataset importdataset() {
        return new Importdataset(
                        contextPath.addSegment("importdataset"));
    }

    public ImportdataRequest importdataset(String importdataid) {
        return new ImportdataRequest(contextPath.addSegment("importdataset").addKeys(new NameValue(importdataid.toString())), Optional.empty());
    }

    public Importentitymappings importentitymappings() {
        return new Importentitymappings(
                        contextPath.addSegment("importentitymappings"));
    }

    public ImportentitymappingRequest importentitymappings(String importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("importentitymappings").addKeys(new NameValue(importentitymappingid.toString())), Optional.empty());
    }

    public Importfiles importfiles() {
        return new Importfiles(
                        contextPath.addSegment("importfiles"));
    }

    public ImportfileRequest importfiles(String importfileid) {
        return new ImportfileRequest(contextPath.addSegment("importfiles").addKeys(new NameValue(importfileid.toString())), Optional.empty());
    }

    public Importjobs importjobs() {
        return new Importjobs(
                        contextPath.addSegment("importjobs"));
    }

    public ImportjobRequest importjobs(String importjobid) {
        return new ImportjobRequest(contextPath.addSegment("importjobs").addKeys(new NameValue(importjobid.toString())), Optional.empty());
    }

    public Importlogs importlogs() {
        return new Importlogs(
                        contextPath.addSegment("importlogs"));
    }

    public ImportlogRequest importlogs(String importlogid) {
        return new ImportlogRequest(contextPath.addSegment("importlogs").addKeys(new NameValue(importlogid.toString())), Optional.empty());
    }

    public Importmaps importmaps() {
        return new Importmaps(
                        contextPath.addSegment("importmaps"));
    }

    public ImportmapRequest importmaps(String importmapid) {
        return new ImportmapRequest(contextPath.addSegment("importmaps").addKeys(new NameValue(importmapid.toString())), Optional.empty());
    }

    public Imports imports() {
        return new Imports(
                        contextPath.addSegment("imports"));
    }

    public ImportRequest imports(String importid) {
        return new ImportRequest(contextPath.addSegment("imports").addKeys(new NameValue(importid.toString())), Optional.empty());
    }

    public Interactionforemails interactionforemails() {
        return new Interactionforemails(
                        contextPath.addSegment("interactionforemails"));
    }

    public InteractionforemailRequest interactionforemails(String interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("interactionforemails").addKeys(new NameValue(interactionforemailid.toString())), Optional.empty());
    }

    public Invaliddependencies invaliddependencies() {
        return new Invaliddependencies(
                        contextPath.addSegment("invaliddependencies"));
    }

    public InvaliddependencyRequest invaliddependencies(String invaliddependencyid) {
        return new InvaliddependencyRequest(contextPath.addSegment("invaliddependencies").addKeys(new NameValue(invaliddependencyid.toString())), Optional.empty());
    }

    public Kbarticlecomments kbarticlecomments() {
        return new Kbarticlecomments(
                        contextPath.addSegment("kbarticlecomments"));
    }

    public KbarticlecommentRequest kbarticlecomments(String kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("kbarticlecomments").addKeys(new NameValue(kbarticlecommentid.toString())), Optional.empty());
    }

    public Kbarticles kbarticles() {
        return new Kbarticles(
                        contextPath.addSegment("kbarticles"));
    }

    public KbarticleRequest kbarticles(String kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("kbarticles").addKeys(new NameValue(kbarticleid.toString())), Optional.empty());
    }

    public Kbarticletemplates kbarticletemplates() {
        return new Kbarticletemplates(
                        contextPath.addSegment("kbarticletemplates"));
    }

    public KbarticletemplateRequest kbarticletemplates(String kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("kbarticletemplates").addKeys(new NameValue(kbarticletemplateid.toString())), Optional.empty());
    }

    public Knowledgearticlecategories knowledgearticlecategories() {
        return new Knowledgearticlecategories(
                        contextPath.addSegment("knowledgearticlecategories"));
    }

    public KnowledgearticlescategoriesRequest knowledgearticlecategories(String knowledgearticlecategoryid) {
        return new KnowledgearticlescategoriesRequest(contextPath.addSegment("knowledgearticlecategories").addKeys(new NameValue(knowledgearticlecategoryid.toString())), Optional.empty());
    }

    public Knowledgearticles knowledgearticles() {
        return new Knowledgearticles(
                        contextPath.addSegment("knowledgearticles"));
    }

    public KnowledgearticleRequest knowledgearticles(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticles").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

    public Knowledgearticleviews knowledgearticleviews() {
        return new Knowledgearticleviews(
                        contextPath.addSegment("knowledgearticleviews"));
    }

    public KnowledgearticleviewsRequest knowledgearticleviews(String knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("knowledgearticleviews").addKeys(new NameValue(knowledgearticleviewsid.toString())), Optional.empty());
    }

    public Knowledgebaserecords knowledgebaserecords() {
        return new Knowledgebaserecords(
                        contextPath.addSegment("knowledgebaserecords"));
    }

    public KnowledgebaserecordRequest knowledgebaserecords(String knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("knowledgebaserecords").addKeys(new NameValue(knowledgebaserecordid.toString())), Optional.empty());
    }

    public Languagelocale languagelocale() {
        return new Languagelocale(
                        contextPath.addSegment("languagelocale"));
    }

    public LanguagelocaleRequest languagelocale(String languagelocaleid) {
        return new LanguagelocaleRequest(contextPath.addSegment("languagelocale").addKeys(new NameValue(languagelocaleid.toString())), Optional.empty());
    }

    public Languageprovisioningstates languageprovisioningstates() {
        return new Languageprovisioningstates(
                        contextPath.addSegment("languageprovisioningstates"));
    }

    public LanguageprovisioningstateRequest languageprovisioningstates(String languageprovisioningstateid) {
        return new LanguageprovisioningstateRequest(contextPath.addSegment("languageprovisioningstates").addKeys(new NameValue(languageprovisioningstateid.toString())), Optional.empty());
    }

    public Letters letters() {
        return new Letters(
                        contextPath.addSegment("letters"));
    }

    public LetterRequest letters(String activityid) {
        return new LetterRequest(contextPath.addSegment("letters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Lookupmappings lookupmappings() {
        return new Lookupmappings(
                        contextPath.addSegment("lookupmappings"));
    }

    public LookupmappingRequest lookupmappings(String lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lookupmappings").addKeys(new NameValue(lookupmappingid.toString())), Optional.empty());
    }

    public Mailboxes mailboxes() {
        return new Mailboxes(
                        contextPath.addSegment("mailboxes"));
    }

    public MailboxRequest mailboxes(String mailboxid) {
        return new MailboxRequest(contextPath.addSegment("mailboxes").addKeys(new NameValue(mailboxid.toString())), Optional.empty());
    }

    public Mailboxtrackingfolders mailboxtrackingfolders() {
        return new Mailboxtrackingfolders(
                        contextPath.addSegment("mailboxtrackingfolders"));
    }

    public MailboxtrackingfolderRequest mailboxtrackingfolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("mailboxtrackingfolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public Mailmergetemplates mailmergetemplates() {
        return new Mailmergetemplates(
                        contextPath.addSegment("mailmergetemplates"));
    }

    public MailmergetemplateRequest mailmergetemplates(String mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("mailmergetemplates").addKeys(new NameValue(mailmergetemplateid.toString())), Optional.empty());
    }

    public Managedproperties managedproperties() {
        return new Managedproperties(
                        contextPath.addSegment("managedproperties"));
    }

    public ManagedpropertyRequest managedproperties(String managedpropertyid) {
        return new ManagedpropertyRequest(contextPath.addSegment("managedproperties").addKeys(new NameValue(managedpropertyid.toString())), Optional.empty());
    }

    public Metrics metrics() {
        return new Metrics(
                        contextPath.addSegment("metrics"));
    }

    public MetricRequest metrics(String metricid) {
        return new MetricRequest(contextPath.addSegment("metrics").addKeys(new NameValue(metricid.toString())), Optional.empty());
    }

    public Mobileofflineprofileitemassociations mobileofflineprofileitemassociations() {
        return new Mobileofflineprofileitemassociations(
                        contextPath.addSegment("mobileofflineprofileitemassociations"));
    }

    public MobileofflineprofileitemassociationRequest mobileofflineprofileitemassociations(String mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("mobileofflineprofileitemassociations").addKeys(new NameValue(mobileofflineprofileitemassociationid.toString())), Optional.empty());
    }

    public Mobileofflineprofileitems mobileofflineprofileitems() {
        return new Mobileofflineprofileitems(
                        contextPath.addSegment("mobileofflineprofileitems"));
    }

    public MobileofflineprofileitemRequest mobileofflineprofileitems(String mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("mobileofflineprofileitems").addKeys(new NameValue(mobileofflineprofileitemid.toString())), Optional.empty());
    }

    public Mobileofflineprofiles mobileofflineprofiles() {
        return new Mobileofflineprofiles(
                        contextPath.addSegment("mobileofflineprofiles"));
    }

    public MobileofflineprofileRequest mobileofflineprofiles(String mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("mobileofflineprofiles").addKeys(new NameValue(mobileofflineprofileid.toString())), Optional.empty());
    }

    public Monthlyfiscalcalendars monthlyfiscalcalendars() {
        return new Monthlyfiscalcalendars(
                        contextPath.addSegment("monthlyfiscalcalendars"));
    }

    public MonthlyfiscalcalendarRequest monthlyfiscalcalendars(String userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("monthlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasetfiles msdyn_aibdatasetfiles() {
        return new Msdyn_aibdatasetfiles(
                        contextPath.addSegment("msdyn_aibdatasetfiles"));
    }

    public Msdyn_aibdatasetfileRequest msdyn_aibdatasetfiles(String msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("msdyn_aibdatasetfiles").addKeys(new NameValue(msdyn_aibdatasetfileid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasetrecords msdyn_aibdatasetrecords() {
        return new Msdyn_aibdatasetrecords(
                        contextPath.addSegment("msdyn_aibdatasetrecords"));
    }

    public Msdyn_aibdatasetrecordRequest msdyn_aibdatasetrecords(String msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("msdyn_aibdatasetrecords").addKeys(new NameValue(msdyn_aibdatasetrecordid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasets msdyn_aibdatasets() {
        return new Msdyn_aibdatasets(
                        contextPath.addSegment("msdyn_aibdatasets"));
    }

    public Msdyn_aibdatasetRequest msdyn_aibdatasets(String msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("msdyn_aibdatasets").addKeys(new NameValue(msdyn_aibdatasetid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasetscontainers msdyn_aibdatasetscontainers() {
        return new Msdyn_aibdatasetscontainers(
                        contextPath.addSegment("msdyn_aibdatasetscontainers"));
    }

    public Msdyn_aibdatasetscontainerRequest msdyn_aibdatasetscontainers(String msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("msdyn_aibdatasetscontainers").addKeys(new NameValue(msdyn_aibdatasetscontainerid.toString())), Optional.empty());
    }

    public Msdyn_aibfileattacheddatas msdyn_aibfileattacheddatas() {
        return new Msdyn_aibfileattacheddatas(
                        contextPath.addSegment("msdyn_aibfileattacheddatas"));
    }

    public Msdyn_aibfileattacheddataRequest msdyn_aibfileattacheddatas(String msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("msdyn_aibfileattacheddatas").addKeys(new NameValue(msdyn_aibfileattacheddataid.toString())), Optional.empty());
    }

    public Msdyn_aibfiles msdyn_aibfiles() {
        return new Msdyn_aibfiles(
                        contextPath.addSegment("msdyn_aibfiles"));
    }

    public Msdyn_aibfileRequest msdyn_aibfiles(String msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("msdyn_aibfiles").addKeys(new NameValue(msdyn_aibfileid.toString())), Optional.empty());
    }

    public Msdyn_aiconfigurations msdyn_aiconfigurations() {
        return new Msdyn_aiconfigurations(
                        contextPath.addSegment("msdyn_aiconfigurations"));
    }

    public Msdyn_aiconfigurationRequest msdyn_aiconfigurations(String msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiconfigurations").addKeys(new NameValue(msdyn_aiconfigurationid.toString())), Optional.empty());
    }

    public Msdyn_aifptrainingdocuments msdyn_aifptrainingdocuments() {
        return new Msdyn_aifptrainingdocuments(
                        contextPath.addSegment("msdyn_aifptrainingdocuments"));
    }

    public Msdyn_aifptrainingdocumentRequest msdyn_aifptrainingdocuments(String msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("msdyn_aifptrainingdocuments").addKeys(new NameValue(msdyn_aifptrainingdocumentid.toString())), Optional.empty());
    }

    public Msdyn_aimodels msdyn_aimodels() {
        return new Msdyn_aimodels(
                        contextPath.addSegment("msdyn_aimodels"));
    }

    public Msdyn_aimodelRequest msdyn_aimodels(String msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_aimodels").addKeys(new NameValue(msdyn_aimodelid.toString())), Optional.empty());
    }

    public Msdyn_aiodimages msdyn_aiodimages() {
        return new Msdyn_aiodimages(
                        contextPath.addSegment("msdyn_aiodimages"));
    }

    public Msdyn_aiodimageRequest msdyn_aiodimages(String msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("msdyn_aiodimages").addKeys(new NameValue(msdyn_aiodimageid.toString())), Optional.empty());
    }

    public Msdyn_aiodlabel_msdyn_aiconfigurationset msdyn_aiodlabel_msdyn_aiconfigurationset() {
        return new Msdyn_aiodlabel_msdyn_aiconfigurationset(
                        contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfigurationset"));
    }

    public Msdyn_aiodlabel_msdyn_aiconfigurationRequest msdyn_aiodlabel_msdyn_aiconfigurationset(String msdyn_aiodlabel_msdyn_aiconfigurationid) {
        return new Msdyn_aiodlabel_msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfigurationset").addKeys(new NameValue(msdyn_aiodlabel_msdyn_aiconfigurationid.toString())), Optional.empty());
    }

    public Msdyn_aiodlabels msdyn_aiodlabels() {
        return new Msdyn_aiodlabels(
                        contextPath.addSegment("msdyn_aiodlabels"));
    }

    public Msdyn_aiodlabelRequest msdyn_aiodlabels(String msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("msdyn_aiodlabels").addKeys(new NameValue(msdyn_aiodlabelid.toString())), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxes msdyn_aiodtrainingboundingboxes() {
        return new Msdyn_aiodtrainingboundingboxes(
                        contextPath.addSegment("msdyn_aiodtrainingboundingboxes"));
    }

    public Msdyn_aiodtrainingboundingboxRequest msdyn_aiodtrainingboundingboxes(String msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("msdyn_aiodtrainingboundingboxes").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid.toString())), Optional.empty());
    }

    public Msdyn_aiodtrainingimages msdyn_aiodtrainingimages() {
        return new Msdyn_aiodtrainingimages(
                        contextPath.addSegment("msdyn_aiodtrainingimages"));
    }

    public Msdyn_aiodtrainingimageRequest msdyn_aiodtrainingimages(String msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("msdyn_aiodtrainingimages").addKeys(new NameValue(msdyn_aiodtrainingimageid.toString())), Optional.empty());
    }

    public Msdyn_aitemplates msdyn_aitemplates() {
        return new Msdyn_aitemplates(
                        contextPath.addSegment("msdyn_aitemplates"));
    }

    public Msdyn_aitemplateRequest msdyn_aitemplates(String msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("msdyn_aitemplates").addKeys(new NameValue(msdyn_aitemplateid.toString())), Optional.empty());
    }

    public Msdyn_analysiscomponents msdyn_analysiscomponents() {
        return new Msdyn_analysiscomponents(
                        contextPath.addSegment("msdyn_analysiscomponents"));
    }

    public Msdyn_analysiscomponentRequest msdyn_analysiscomponents(String msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("msdyn_analysiscomponents").addKeys(new NameValue(msdyn_analysiscomponentid.toString())), Optional.empty());
    }

    public Msdyn_analysisjobs msdyn_analysisjobs() {
        return new Msdyn_analysisjobs(
                        contextPath.addSegment("msdyn_analysisjobs"));
    }

    public Msdyn_analysisjobRequest msdyn_analysisjobs(String msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_analysisjobs").addKeys(new NameValue(msdyn_analysisjobid.toString())), Optional.empty());
    }

    public Msdyn_analysisresultdetails msdyn_analysisresultdetails() {
        return new Msdyn_analysisresultdetails(
                        contextPath.addSegment("msdyn_analysisresultdetails"));
    }

    public Msdyn_analysisresultdetailRequest msdyn_analysisresultdetails(String msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("msdyn_analysisresultdetails").addKeys(new NameValue(msdyn_analysisresultdetailid.toString())), Optional.empty());
    }

    public Msdyn_analysisresults msdyn_analysisresults() {
        return new Msdyn_analysisresults(
                        contextPath.addSegment("msdyn_analysisresults"));
    }

    public Msdyn_analysisresultRequest msdyn_analysisresults(String msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("msdyn_analysisresults").addKeys(new NameValue(msdyn_analysisresultid.toString())), Optional.empty());
    }

    public Msdyn_componentlayerdatasources msdyn_componentlayerdatasources() {
        return new Msdyn_componentlayerdatasources(
                        contextPath.addSegment("msdyn_componentlayerdatasources"));
    }

    public Msdyn_componentlayerdatasourceRequest msdyn_componentlayerdatasources(String msdyn_componentlayerdatasourceid) {
        return new Msdyn_componentlayerdatasourceRequest(contextPath.addSegment("msdyn_componentlayerdatasources").addKeys(new NameValue(msdyn_componentlayerdatasourceid.toString())), Optional.empty());
    }

    public Msdyn_componentlayers msdyn_componentlayers() {
        return new Msdyn_componentlayers(
                        contextPath.addSegment("msdyn_componentlayers"));
    }

    public Msdyn_componentlayerRequest msdyn_componentlayers(String msdyn_componentlayerid) {
        return new Msdyn_componentlayerRequest(contextPath.addSegment("msdyn_componentlayers").addKeys(new NameValue(msdyn_componentlayerid.toString())), Optional.empty());
    }

    public Msdyn_dataflows msdyn_dataflows() {
        return new Msdyn_dataflows(
                        contextPath.addSegment("msdyn_dataflows"));
    }

    public Msdyn_dataflowRequest msdyn_dataflows(String msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("msdyn_dataflows").addKeys(new NameValue(msdyn_dataflowid.toString())), Optional.empty());
    }

    public Msdyn_helppages msdyn_helppages() {
        return new Msdyn_helppages(
                        contextPath.addSegment("msdyn_helppages"));
    }

    public Msdyn_helppageRequest msdyn_helppages(String msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("msdyn_helppages").addKeys(new NameValue(msdyn_helppageid.toString())), Optional.empty());
    }

    public Msdyn_knowledgearticleimages msdyn_knowledgearticleimages() {
        return new Msdyn_knowledgearticleimages(
                        contextPath.addSegment("msdyn_knowledgearticleimages"));
    }

    public Msdyn_knowledgearticleimageRequest msdyn_knowledgearticleimages(String msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("msdyn_knowledgearticleimages").addKeys(new NameValue(msdyn_knowledgearticleimageid.toString())), Optional.empty());
    }

    public Msdyn_knowledgearticletemplates msdyn_knowledgearticletemplates() {
        return new Msdyn_knowledgearticletemplates(
                        contextPath.addSegment("msdyn_knowledgearticletemplates"));
    }

    public Msdyn_knowledgearticletemplateRequest msdyn_knowledgearticletemplates(String msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("msdyn_knowledgearticletemplates").addKeys(new NameValue(msdyn_knowledgearticletemplateid.toString())), Optional.empty());
    }

    public Msdyn_nonrelationaldses msdyn_nonrelationaldses() {
        return new Msdyn_nonrelationaldses(
                        contextPath.addSegment("msdyn_nonrelationaldses"));
    }

    public Msdyn_nonrelationaldsRequest msdyn_nonrelationaldses(String msdyn_nonrelationaldsid) {
        return new Msdyn_nonrelationaldsRequest(contextPath.addSegment("msdyn_nonrelationaldses").addKeys(new NameValue(msdyn_nonrelationaldsid.toString())), Optional.empty());
    }

    public Msdyn_odatav4ds msdyn_odatav4ds() {
        return new Msdyn_odatav4ds(
                        contextPath.addSegment("msdyn_odatav4ds"));
    }

    public Msdyn_odatav4dsRequest msdyn_odatav4ds(String msdyn_odatav4dsid) {
        return new Msdyn_odatav4dsRequest(contextPath.addSegment("msdyn_odatav4ds").addKeys(new NameValue(msdyn_odatav4dsid.toString())), Optional.empty());
    }

    public Msdyn_richtextfiles msdyn_richtextfiles() {
        return new Msdyn_richtextfiles(
                        contextPath.addSegment("msdyn_richtextfiles"));
    }

    public Msdyn_richtextfileRequest msdyn_richtextfiles(String msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("msdyn_richtextfiles").addKeys(new NameValue(msdyn_richtextfileid.toString())), Optional.empty());
    }

    public Msdyn_serviceconfigurations msdyn_serviceconfigurations() {
        return new Msdyn_serviceconfigurations(
                        contextPath.addSegment("msdyn_serviceconfigurations"));
    }

    public Msdyn_serviceconfigurationRequest msdyn_serviceconfigurations(String msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("msdyn_serviceconfigurations").addKeys(new NameValue(msdyn_serviceconfigurationid.toString())), Optional.empty());
    }

    public Msdyn_slakpis msdyn_slakpis() {
        return new Msdyn_slakpis(
                        contextPath.addSegment("msdyn_slakpis"));
    }

    public Msdyn_slakpiRequest msdyn_slakpis(String msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("msdyn_slakpis").addKeys(new NameValue(msdyn_slakpiid.toString())), Optional.empty());
    }

    public Msdyn_solutioncomponentdatasources msdyn_solutioncomponentdatasources() {
        return new Msdyn_solutioncomponentdatasources(
                        contextPath.addSegment("msdyn_solutioncomponentdatasources"));
    }

    public Msdyn_solutioncomponentdatasourceRequest msdyn_solutioncomponentdatasources(String msdyn_solutioncomponentdatasourceid) {
        return new Msdyn_solutioncomponentdatasourceRequest(contextPath.addSegment("msdyn_solutioncomponentdatasources").addKeys(new NameValue(msdyn_solutioncomponentdatasourceid.toString())), Optional.empty());
    }

    public Msdyn_solutioncomponentsummaries msdyn_solutioncomponentsummaries() {
        return new Msdyn_solutioncomponentsummaries(
                        contextPath.addSegment("msdyn_solutioncomponentsummaries"));
    }

    public Msdyn_solutioncomponentsummaryRequest msdyn_solutioncomponentsummaries(String msdyn_solutioncomponentsummaryid) {
        return new Msdyn_solutioncomponentsummaryRequest(contextPath.addSegment("msdyn_solutioncomponentsummaries").addKeys(new NameValue(msdyn_solutioncomponentsummaryid.toString())), Optional.empty());
    }

    public Msdyn_solutionhealthrulearguments msdyn_solutionhealthrulearguments() {
        return new Msdyn_solutionhealthrulearguments(
                        contextPath.addSegment("msdyn_solutionhealthrulearguments"));
    }

    public Msdyn_solutionhealthruleargumentRequest msdyn_solutionhealthrulearguments(String msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("msdyn_solutionhealthrulearguments").addKeys(new NameValue(msdyn_solutionhealthruleargumentid.toString())), Optional.empty());
    }

    public Msdyn_solutionhealthrules msdyn_solutionhealthrules() {
        return new Msdyn_solutionhealthrules(
                        contextPath.addSegment("msdyn_solutionhealthrules"));
    }

    public Msdyn_solutionhealthruleRequest msdyn_solutionhealthrules(String msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("msdyn_solutionhealthrules").addKeys(new NameValue(msdyn_solutionhealthruleid.toString())), Optional.empty());
    }

    public Msdyn_solutionhealthrulesets msdyn_solutionhealthrulesets() {
        return new Msdyn_solutionhealthrulesets(
                        contextPath.addSegment("msdyn_solutionhealthrulesets"));
    }

    public Msdyn_solutionhealthrulesetRequest msdyn_solutionhealthrulesets(String msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("msdyn_solutionhealthrulesets").addKeys(new NameValue(msdyn_solutionhealthrulesetid.toString())), Optional.empty());
    }

    public Msdyn_solutionhistories msdyn_solutionhistories() {
        return new Msdyn_solutionhistories(
                        contextPath.addSegment("msdyn_solutionhistories"));
    }

    public Msdyn_solutionhistoryRequest msdyn_solutionhistories(String msdyn_solutionhistoryid) {
        return new Msdyn_solutionhistoryRequest(contextPath.addSegment("msdyn_solutionhistories").addKeys(new NameValue(msdyn_solutionhistoryid.toString())), Optional.empty());
    }

    public Msdyn_solutionhistorydatasources msdyn_solutionhistorydatasources() {
        return new Msdyn_solutionhistorydatasources(
                        contextPath.addSegment("msdyn_solutionhistorydatasources"));
    }

    public Msdyn_solutionhistorydatasourceRequest msdyn_solutionhistorydatasources(String msdyn_solutionhistorydatasourceid) {
        return new Msdyn_solutionhistorydatasourceRequest(contextPath.addSegment("msdyn_solutionhistorydatasources").addKeys(new NameValue(msdyn_solutionhistorydatasourceid.toString())), Optional.empty());
    }

    public Navigationsettings navigationsettings() {
        return new Navigationsettings(
                        contextPath.addSegment("navigationsettings"));
    }

    public NavigationsettingRequest navigationsettings(String navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("navigationsettings").addKeys(new NameValue(navigationsettingid.toString())), Optional.empty());
    }

    public Newprocesses newprocesses() {
        return new Newprocesses(
                        contextPath.addSegment("newprocesses"));
    }

    public NewprocessRequest newprocesses(String businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("newprocesses").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public Officegraphdocuments officegraphdocuments() {
        return new Officegraphdocuments(
                        contextPath.addSegment("officegraphdocuments"));
    }

    public OfficegraphdocumentRequest officegraphdocuments(String officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("officegraphdocuments").addKeys(new NameValue(officegraphdocumentid.toString())), Optional.empty());
    }

    public Optionsets optionsets() {
        return new Optionsets(
                        contextPath.addSegment("optionsets"));
    }

    public OptionsetRequest optionsets(String optionsetid) {
        return new OptionsetRequest(contextPath.addSegment("optionsets").addKeys(new NameValue(optionsetid.toString())), Optional.empty());
    }

    public Organizations organizations() {
        return new Organizations(
                        contextPath.addSegment("organizations"));
    }

    public OrganizationRequest organizations(String organizationid) {
        return new OrganizationRequest(contextPath.addSegment("organizations").addKeys(new NameValue(organizationid.toString())), Optional.empty());
    }

    public Ownermappings ownermappings() {
        return new Ownermappings(
                        contextPath.addSegment("ownermappings"));
    }

    public OwnermappingRequest ownermappings(String ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("ownermappings").addKeys(new NameValue(ownermappingid.toString())), Optional.empty());
    }

    public Personaldocumenttemplates personaldocumenttemplates() {
        return new Personaldocumenttemplates(
                        contextPath.addSegment("personaldocumenttemplates"));
    }

    public PersonaldocumenttemplateRequest personaldocumenttemplates(String personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("personaldocumenttemplates").addKeys(new NameValue(personaldocumenttemplateid.toString())), Optional.empty());
    }

    public Phonecalls phonecalls() {
        return new Phonecalls(
                        contextPath.addSegment("phonecalls"));
    }

    public PhonecallRequest phonecalls(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("phonecalls").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Picklistmappings picklistmappings() {
        return new Picklistmappings(
                        contextPath.addSegment("picklistmappings"));
    }

    public PicklistmappingRequest picklistmappings(String picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("picklistmappings").addKeys(new NameValue(picklistmappingid.toString())), Optional.empty());
    }

    public Pluginassemblies pluginassemblies() {
        return new Pluginassemblies(
                        contextPath.addSegment("pluginassemblies"));
    }

    public PluginassemblyRequest pluginassemblies(String pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("pluginassemblies").addKeys(new NameValue(pluginassemblyid.toString())), Optional.empty());
    }

    public Plugintracelogs plugintracelogs() {
        return new Plugintracelogs(
                        contextPath.addSegment("plugintracelogs"));
    }

    public PlugintracelogRequest plugintracelogs(String plugintracelogid) {
        return new PlugintracelogRequest(contextPath.addSegment("plugintracelogs").addKeys(new NameValue(plugintracelogid.toString())), Optional.empty());
    }

    public Plugintypes plugintypes() {
        return new Plugintypes(
                        contextPath.addSegment("plugintypes"));
    }

    public PlugintypeRequest plugintypes(String plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("plugintypes").addKeys(new NameValue(plugintypeid.toString())), Optional.empty());
    }

    public Plugintypestatistics plugintypestatistics() {
        return new Plugintypestatistics(
                        contextPath.addSegment("plugintypestatistics"));
    }

    public PlugintypestatisticRequest plugintypestatistics(String plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("plugintypestatistics").addKeys(new NameValue(plugintypestatisticid.toString())), Optional.empty());
    }

    public Positions positions() {
        return new Positions(
                        contextPath.addSegment("positions"));
    }

    public PositionRequest positions(String positionid) {
        return new PositionRequest(contextPath.addSegment("positions").addKeys(new NameValue(positionid.toString())), Optional.empty());
    }

    public Postcomments postcomments() {
        return new Postcomments(
                        contextPath.addSegment("postcomments"));
    }

    public PostcommentRequest postcomments(String postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("postcomments").addKeys(new NameValue(postcommentid.toString())), Optional.empty());
    }

    public Postfollows postfollows() {
        return new Postfollows(
                        contextPath.addSegment("postfollows"));
    }

    public PostfollowRequest postfollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("postfollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public Postlikes postlikes() {
        return new Postlikes(
                        contextPath.addSegment("postlikes"));
    }

    public PostlikeRequest postlikes(String postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("postlikes").addKeys(new NameValue(postlikeid.toString())), Optional.empty());
    }

    public Postregardings postregardings() {
        return new Postregardings(
                        contextPath.addSegment("postregardings"));
    }

    public PostregardingRequest postregardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("postregardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public Posts posts() {
        return new Posts(
                        contextPath.addSegment("posts"));
    }

    public PostRequest posts(String postid) {
        return new PostRequest(contextPath.addSegment("posts").addKeys(new NameValue(postid.toString())), Optional.empty());
    }

    public Principalentitymaps principalentitymaps() {
        return new Principalentitymaps(
                        contextPath.addSegment("principalentitymaps"));
    }

    public PrincipalentitymapRequest principalentitymaps(String principalentitymapid) {
        return new PrincipalentitymapRequest(contextPath.addSegment("principalentitymaps").addKeys(new NameValue(principalentitymapid.toString())), Optional.empty());
    }

    public Principalobjectaccessset principalobjectaccessset() {
        return new Principalobjectaccessset(
                        contextPath.addSegment("principalobjectaccessset"));
    }

    public PrincipalobjectaccessRequest principalobjectaccessset(String principalobjectaccessid) {
        return new PrincipalobjectaccessRequest(contextPath.addSegment("principalobjectaccessset").addKeys(new NameValue(principalobjectaccessid.toString())), Optional.empty());
    }

    public Principalobjectattributeaccessset principalobjectattributeaccessset() {
        return new Principalobjectattributeaccessset(
                        contextPath.addSegment("principalobjectattributeaccessset"));
    }

    public PrincipalobjectattributeaccessRequest principalobjectattributeaccessset(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("principalobjectattributeaccessset").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public Privileges privileges() {
        return new Privileges(
                        contextPath.addSegment("privileges"));
    }

    public PrivilegeRequest privileges(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("privileges").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public Processsessions processsessions() {
        return new Processsessions(
                        contextPath.addSegment("processsessions"));
    }

    public ProcesssessionRequest processsessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("processsessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public Processstageparameters processstageparameters() {
        return new Processstageparameters(
                        contextPath.addSegment("processstageparameters"));
    }

    public ProcessstageparameterRequest processstageparameters(String processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("processstageparameters").addKeys(new NameValue(processstageparameterid.toString())), Optional.empty());
    }

    public Processstages processstages() {
        return new Processstages(
                        contextPath.addSegment("processstages"));
    }

    public ProcessstageRequest processstages(String processstageid) {
        return new ProcessstageRequest(contextPath.addSegment("processstages").addKeys(new NameValue(processstageid.toString())), Optional.empty());
    }

    public Processtriggers processtriggers() {
        return new Processtriggers(
                        contextPath.addSegment("processtriggers"));
    }

    public ProcesstriggerRequest processtriggers(String processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("processtriggers").addKeys(new NameValue(processtriggerid.toString())), Optional.empty());
    }

    public Publisheraddresses publisheraddresses() {
        return new Publisheraddresses(
                        contextPath.addSegment("publisheraddresses"));
    }

    public PublisheraddressRequest publisheraddresses(String publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("publisheraddresses").addKeys(new NameValue(publisheraddressid.toString())), Optional.empty());
    }

    public Publishers publishers() {
        return new Publishers(
                        contextPath.addSegment("publishers"));
    }

    public PublisherRequest publishers(String publisherid) {
        return new PublisherRequest(contextPath.addSegment("publishers").addKeys(new NameValue(publisherid.toString())), Optional.empty());
    }

    public Quarterlyfiscalcalendars quarterlyfiscalcalendars() {
        return new Quarterlyfiscalcalendars(
                        contextPath.addSegment("quarterlyfiscalcalendars"));
    }

    public QuarterlyfiscalcalendarRequest quarterlyfiscalcalendars(String userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("quarterlyfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid.toString())), Optional.empty());
    }

    public Queueitems queueitems() {
        return new Queueitems(
                        contextPath.addSegment("queueitems"));
    }

    public QueueitemRequest queueitems(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("queueitems").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public Queuememberships queuememberships() {
        return new Queuememberships(
                        contextPath.addSegment("queuememberships"));
    }

    public QueuemembershipRequest queuememberships(String queuemembershipid) {
        return new QueuemembershipRequest(contextPath.addSegment("queuememberships").addKeys(new NameValue(queuemembershipid.toString())), Optional.empty());
    }

    public Queues queues() {
        return new Queues(
                        contextPath.addSegment("queues"));
    }

    public QueueRequest queues(String queueid) {
        return new QueueRequest(contextPath.addSegment("queues").addKeys(new NameValue(queueid.toString())), Optional.empty());
    }

    public Recommendeddocuments recommendeddocuments() {
        return new Recommendeddocuments(
                        contextPath.addSegment("recommendeddocuments"));
    }

    public RecommendeddocumentRequest recommendeddocuments(String recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("recommendeddocuments").addKeys(new NameValue(recommendeddocumentid.toString())), Optional.empty());
    }

    public Recurrencerules recurrencerules() {
        return new Recurrencerules(
                        contextPath.addSegment("recurrencerules"));
    }

    public RecurrenceruleRequest recurrencerules(String ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("recurrencerules").addKeys(new NameValue(ruleid.toString())), Optional.empty());
    }

    public Recurringappointmentmasters recurringappointmentmasters() {
        return new Recurringappointmentmasters(
                        contextPath.addSegment("recurringappointmentmasters"));
    }

    public RecurringappointmentmasterRequest recurringappointmentmasters(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("recurringappointmentmasters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Relationshipattributes relationshipattributes() {
        return new Relationshipattributes(
                        contextPath.addSegment("relationshipattributes"));
    }

    public RelationshipattributeRequest relationshipattributes(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("relationshipattributes").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

    public Relationships relationships() {
        return new Relationships(
                        contextPath.addSegment("relationships"));
    }

    public RelationshipRequest relationships(String relationshipid) {
        return new RelationshipRequest(contextPath.addSegment("relationships").addKeys(new NameValue(relationshipid.toString())), Optional.empty());
    }

    public Reportcategories reportcategories() {
        return new Reportcategories(
                        contextPath.addSegment("reportcategories"));
    }

    public ReportcategoryRequest reportcategories(String reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("reportcategories").addKeys(new NameValue(reportcategoryid.toString())), Optional.empty());
    }

    public Reports reports() {
        return new Reports(
                        contextPath.addSegment("reports"));
    }

    public ReportRequest reports(String reportid) {
        return new ReportRequest(contextPath.addSegment("reports").addKeys(new NameValue(reportid.toString())), Optional.empty());
    }

    public Ribbonmetadatasettoprocess ribbonmetadatasettoprocess() {
        return new Ribbonmetadatasettoprocess(
                        contextPath.addSegment("ribbonmetadatasettoprocess"));
    }

    public RibbonmetadatatoprocessRequest ribbonmetadatasettoprocess(String ribbonmetadatarowid) {
        return new RibbonmetadatatoprocessRequest(contextPath.addSegment("ribbonmetadatasettoprocess").addKeys(new NameValue(ribbonmetadatarowid.toString())), Optional.empty());
    }

    public Roleprivilegescollection roleprivilegescollection() {
        return new Roleprivilegescollection(
                        contextPath.addSegment("roleprivilegescollection"));
    }

    public RoleprivilegesRequest roleprivilegescollection(String roleprivilegeid) {
        return new RoleprivilegesRequest(contextPath.addSegment("roleprivilegescollection").addKeys(new NameValue(roleprivilegeid.toString())), Optional.empty());
    }

    public Roles roles() {
        return new Roles(
                        contextPath.addSegment("roles"));
    }

    public RoleRequest roles(String roleid) {
        return new RoleRequest(contextPath.addSegment("roles").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public Roletemplateprivilegescollection roletemplateprivilegescollection() {
        return new Roletemplateprivilegescollection(
                        contextPath.addSegment("roletemplateprivilegescollection"));
    }

    public RoletemplateprivilegesRequest roletemplateprivilegescollection(String roletemplateprivilegeid) {
        return new RoletemplateprivilegesRequest(contextPath.addSegment("roletemplateprivilegescollection").addKeys(new NameValue(roletemplateprivilegeid.toString())), Optional.empty());
    }

    public Roletemplates roletemplates() {
        return new Roletemplates(
                        contextPath.addSegment("roletemplates"));
    }

    public RoletemplateRequest roletemplates(String roletemplateid) {
        return new RoletemplateRequest(contextPath.addSegment("roletemplates").addKeys(new NameValue(roletemplateid.toString())), Optional.empty());
    }

    public Rollupfields rollupfields() {
        return new Rollupfields(
                        contextPath.addSegment("rollupfields"));
    }

    public RollupfieldRequest rollupfields(String rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("rollupfields").addKeys(new NameValue(rollupfieldid.toString())), Optional.empty());
    }

    public Runtimedependencies runtimedependencies() {
        return new Runtimedependencies(
                        contextPath.addSegment("runtimedependencies"));
    }

    public RuntimedependencyRequest runtimedependencies(String dependencyid) {
        return new RuntimedependencyRequest(contextPath.addSegment("runtimedependencies").addKeys(new NameValue(dependencyid.toString())), Optional.empty());
    }

    public Savedqueries savedqueries() {
        return new Savedqueries(
                        contextPath.addSegment("savedqueries"));
    }

    public SavedqueryRequest savedqueries(String savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("savedqueries").addKeys(new NameValue(savedqueryid.toString())), Optional.empty());
    }

    public Savedqueryvisualizations savedqueryvisualizations() {
        return new Savedqueryvisualizations(
                        contextPath.addSegment("savedqueryvisualizations"));
    }

    public SavedqueryvisualizationRequest savedqueryvisualizations(String savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("savedqueryvisualizations").addKeys(new NameValue(savedqueryvisualizationid.toString())), Optional.empty());
    }

    public Sdkmessagefilters sdkmessagefilters() {
        return new Sdkmessagefilters(
                        contextPath.addSegment("sdkmessagefilters"));
    }

    public SdkmessagefilterRequest sdkmessagefilters(String sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessagefilters").addKeys(new NameValue(sdkmessagefilterid.toString())), Optional.empty());
    }

    public Sdkmessageprocessingstepimages sdkmessageprocessingstepimages() {
        return new Sdkmessageprocessingstepimages(
                        contextPath.addSegment("sdkmessageprocessingstepimages"));
    }

    public SdkmessageprocessingstepimageRequest sdkmessageprocessingstepimages(String sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("sdkmessageprocessingstepimages").addKeys(new NameValue(sdkmessageprocessingstepimageid.toString())), Optional.empty());
    }

    public Sdkmessageprocessingsteps sdkmessageprocessingsteps() {
        return new Sdkmessageprocessingsteps(
                        contextPath.addSegment("sdkmessageprocessingsteps"));
    }

    public SdkmessageprocessingstepRequest sdkmessageprocessingsteps(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessageprocessingsteps").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public Sdkmessageprocessingstepsecureconfigs sdkmessageprocessingstepsecureconfigs() {
        return new Sdkmessageprocessingstepsecureconfigs(
                        contextPath.addSegment("sdkmessageprocessingstepsecureconfigs"));
    }

    public SdkmessageprocessingstepsecureconfigRequest sdkmessageprocessingstepsecureconfigs(String sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("sdkmessageprocessingstepsecureconfigs").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid.toString())), Optional.empty());
    }

    public Sdkmessages sdkmessages() {
        return new Sdkmessages(
                        contextPath.addSegment("sdkmessages"));
    }

    public SdkmessageRequest sdkmessages(String sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessages").addKeys(new NameValue(sdkmessageid.toString())), Optional.empty());
    }

    public Semiannualfiscalcalendars semiannualfiscalcalendars() {
        return new Semiannualfiscalcalendars(
                        contextPath.addSegment("semiannualfiscalcalendars"));
    }

    public SemiannualfiscalcalendarRequest semiannualfiscalcalendars(String userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("semiannualfiscalcalendars").addKeys(new NameValue(userfiscalcalendarid.toString())), Optional.empty());
    }

    public Serviceendpoints serviceendpoints() {
        return new Serviceendpoints(
                        contextPath.addSegment("serviceendpoints"));
    }

    public ServiceendpointRequest serviceendpoints(String serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("serviceendpoints").addKeys(new NameValue(serviceendpointid.toString())), Optional.empty());
    }

    public Serviceplanappmodulesset serviceplanappmodulesset() {
        return new Serviceplanappmodulesset(
                        contextPath.addSegment("serviceplanappmodulesset"));
    }

    public ServiceplanappmodulesRequest serviceplanappmodulesset(String serviceplanappmodulesid) {
        return new ServiceplanappmodulesRequest(contextPath.addSegment("serviceplanappmodulesset").addKeys(new NameValue(serviceplanappmodulesid.toString())), Optional.empty());
    }

    public Serviceplans serviceplans() {
        return new Serviceplans(
                        contextPath.addSegment("serviceplans"));
    }

    public ServiceplanRequest serviceplans(String serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("serviceplans").addKeys(new NameValue(serviceplanid.toString())), Optional.empty());
    }

    public Sharepointdocumentlocations sharepointdocumentlocations() {
        return new Sharepointdocumentlocations(
                        contextPath.addSegment("sharepointdocumentlocations"));
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocations(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocations").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public Sharepointsites sharepointsites() {
        return new Sharepointsites(
                        contextPath.addSegment("sharepointsites"));
    }

    public SharepointsiteRequest sharepointsites(String sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("sharepointsites").addKeys(new NameValue(sharepointsiteid.toString())), Optional.empty());
    }

    public Similarityrules similarityrules() {
        return new Similarityrules(
                        contextPath.addSegment("similarityrules"));
    }

    public SimilarityruleRequest similarityrules(String similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("similarityrules").addKeys(new NameValue(similarityruleid.toString())), Optional.empty());
    }

    public Sitemaps sitemaps() {
        return new Sitemaps(
                        contextPath.addSegment("sitemaps"));
    }

    public SitemapRequest sitemaps(String sitemapid) {
        return new SitemapRequest(contextPath.addSegment("sitemaps").addKeys(new NameValue(sitemapid.toString())), Optional.empty());
    }

    public Slaitems slaitems() {
        return new Slaitems(
                        contextPath.addSegment("slaitems"));
    }

    public SlaitemRequest slaitems(String slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("slaitems").addKeys(new NameValue(slaitemid.toString())), Optional.empty());
    }

    public Slakpiinstances slakpiinstances() {
        return new Slakpiinstances(
                        contextPath.addSegment("slakpiinstances"));
    }

    public SlakpiinstanceRequest slakpiinstances(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstances").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public Slas slas() {
        return new Slas(
                        contextPath.addSegment("slas"));
    }

    public SlaRequest slas(String slaid) {
        return new SlaRequest(contextPath.addSegment("slas").addKeys(new NameValue(slaid.toString())), Optional.empty());
    }

    public Socialactivities socialactivities() {
        return new Socialactivities(
                        contextPath.addSegment("socialactivities"));
    }

    public SocialactivityRequest socialactivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("socialactivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Socialprofiles socialprofiles() {
        return new Socialprofiles(
                        contextPath.addSegment("socialprofiles"));
    }

    public SocialprofileRequest socialprofiles(String socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("socialprofiles").addKeys(new NameValue(socialprofileid.toString())), Optional.empty());
    }

    public Solutioncomponentattributeconfigurations solutioncomponentattributeconfigurations() {
        return new Solutioncomponentattributeconfigurations(
                        contextPath.addSegment("solutioncomponentattributeconfigurations"));
    }

    public SolutioncomponentattributeconfigurationRequest solutioncomponentattributeconfigurations(String solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("solutioncomponentattributeconfigurations").addKeys(new NameValue(solutioncomponentattributeconfigurationid.toString())), Optional.empty());
    }

    public Solutioncomponentconfigurations solutioncomponentconfigurations() {
        return new Solutioncomponentconfigurations(
                        contextPath.addSegment("solutioncomponentconfigurations"));
    }

    public SolutioncomponentconfigurationRequest solutioncomponentconfigurations(String solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("solutioncomponentconfigurations").addKeys(new NameValue(solutioncomponentconfigurationid.toString())), Optional.empty());
    }

    public Solutioncomponentrelationshipconfigurations solutioncomponentrelationshipconfigurations() {
        return new Solutioncomponentrelationshipconfigurations(
                        contextPath.addSegment("solutioncomponentrelationshipconfigurations"));
    }

    public SolutioncomponentrelationshipconfigurationRequest solutioncomponentrelationshipconfigurations(String solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("solutioncomponentrelationshipconfigurations").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid.toString())), Optional.empty());
    }

    public Solutioncomponents solutioncomponents() {
        return new Solutioncomponents(
                        contextPath.addSegment("solutioncomponents"));
    }

    public SolutioncomponentRequest solutioncomponents(String solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solutioncomponents").addKeys(new NameValue(solutioncomponentid.toString())), Optional.empty());
    }

    public Solutionhistories solutionhistories() {
        return new Solutionhistories(
                        contextPath.addSegment("solutionhistories"));
    }

    public SolutionhistorydataRequest solutionhistories(String solutionhistorydataid) {
        return new SolutionhistorydataRequest(contextPath.addSegment("solutionhistories").addKeys(new NameValue(solutionhistorydataid.toString())), Optional.empty());
    }

    public Solutions solutions() {
        return new Solutions(
                        contextPath.addSegment("solutions"));
    }

    public SolutionRequest solutions(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("solutions").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public Stagesolutionuploads stagesolutionuploads() {
        return new Stagesolutionuploads(
                        contextPath.addSegment("stagesolutionuploads"));
    }

    public StagesolutionuploadRequest stagesolutionuploads(String stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("stagesolutionuploads").addKeys(new NameValue(stagesolutionuploadid.toString())), Optional.empty());
    }

    public Subjects subjects() {
        return new Subjects(
                        contextPath.addSegment("subjects"));
    }

    public SubjectRequest subjects(String subjectid) {
        return new SubjectRequest(contextPath.addSegment("subjects").addKeys(new NameValue(subjectid.toString())), Optional.empty());
    }

    public Subscriptionmanuallytrackedobjects subscriptionmanuallytrackedobjects() {
        return new Subscriptionmanuallytrackedobjects(
                        contextPath.addSegment("subscriptionmanuallytrackedobjects"));
    }

    public SubscriptionmanuallytrackedobjectRequest subscriptionmanuallytrackedobjects(String subscriptionmanuallytrackedobjectid) {
        return new SubscriptionmanuallytrackedobjectRequest(contextPath.addSegment("subscriptionmanuallytrackedobjects").addKeys(new NameValue(subscriptionmanuallytrackedobjectid.toString())), Optional.empty());
    }

    public Subscriptionstatisticsofflineset subscriptionstatisticsofflineset() {
        return new Subscriptionstatisticsofflineset(
                        contextPath.addSegment("subscriptionstatisticsofflineset"));
    }

    public SubscriptionstatisticsofflineRequest subscriptionstatisticsofflineset(String subscriptionid) {
        return new SubscriptionstatisticsofflineRequest(contextPath.addSegment("subscriptionstatisticsofflineset").addKeys(new NameValue(subscriptionid.toString())), Optional.empty());
    }

    public Subscriptionstatisticsoutlookset subscriptionstatisticsoutlookset() {
        return new Subscriptionstatisticsoutlookset(
                        contextPath.addSegment("subscriptionstatisticsoutlookset"));
    }

    public SubscriptionstatisticsoutlookRequest subscriptionstatisticsoutlookset(String subscriptionid) {
        return new SubscriptionstatisticsoutlookRequest(contextPath.addSegment("subscriptionstatisticsoutlookset").addKeys(new NameValue(subscriptionid.toString())), Optional.empty());
    }

    public Subscriptionsyncentriesoffline subscriptionsyncentriesoffline() {
        return new Subscriptionsyncentriesoffline(
                        contextPath.addSegment("subscriptionsyncentriesoffline"));
    }

    public SubscriptionsyncentryofflineRequest subscriptionsyncentriesoffline(String subscriptionid) {
        return new SubscriptionsyncentryofflineRequest(contextPath.addSegment("subscriptionsyncentriesoffline").addKeys(new NameValue(subscriptionid.toString())), Optional.empty());
    }

    public Subscriptionsyncentriesoutlook subscriptionsyncentriesoutlook() {
        return new Subscriptionsyncentriesoutlook(
                        contextPath.addSegment("subscriptionsyncentriesoutlook"));
    }

    public SubscriptionsyncentryoutlookRequest subscriptionsyncentriesoutlook(String subscriptionid) {
        return new SubscriptionsyncentryoutlookRequest(contextPath.addSegment("subscriptionsyncentriesoutlook").addKeys(new NameValue(subscriptionid.toString())), Optional.empty());
    }

    public Syncerrors syncerrors() {
        return new Syncerrors(
                        contextPath.addSegment("syncerrors"));
    }

    public SyncerrorRequest syncerrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("syncerrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public Systemforms systemforms() {
        return new Systemforms(
                        contextPath.addSegment("systemforms"));
    }

    public SystemformRequest systemforms(String formid) {
        return new SystemformRequest(contextPath.addSegment("systemforms").addKeys(new NameValue(formid.toString())), Optional.empty());
    }

    public Systemuserlicensescollection systemuserlicensescollection() {
        return new Systemuserlicensescollection(
                        contextPath.addSegment("systemuserlicensescollection"));
    }

    public SystemuserlicensesRequest systemuserlicensescollection(String systemuserlicenseid) {
        return new SystemuserlicensesRequest(contextPath.addSegment("systemuserlicensescollection").addKeys(new NameValue(systemuserlicenseid.toString())), Optional.empty());
    }

    public Systemuserprofilescollection systemuserprofilescollection() {
        return new Systemuserprofilescollection(
                        contextPath.addSegment("systemuserprofilescollection"));
    }

    public SystemuserprofilesRequest systemuserprofilescollection(String systemuserprofileid) {
        return new SystemuserprofilesRequest(contextPath.addSegment("systemuserprofilescollection").addKeys(new NameValue(systemuserprofileid.toString())), Optional.empty());
    }

    public Systemuserrolescollection systemuserrolescollection() {
        return new Systemuserrolescollection(
                        contextPath.addSegment("systemuserrolescollection"));
    }

    public SystemuserrolesRequest systemuserrolescollection(String systemuserroleid) {
        return new SystemuserrolesRequest(contextPath.addSegment("systemuserrolescollection").addKeys(new NameValue(systemuserroleid.toString())), Optional.empty());
    }

    public Systemusers systemusers() {
        return new Systemusers(
                        contextPath.addSegment("systemusers"));
    }

    public SystemuserRequest systemusers(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemusers").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public Systemusersyncmappingprofilescollection systemusersyncmappingprofilescollection() {
        return new Systemusersyncmappingprofilescollection(
                        contextPath.addSegment("systemusersyncmappingprofilescollection"));
    }

    public SystemusersyncmappingprofilesRequest systemusersyncmappingprofilescollection(String systemusersyncmappingprofileid) {
        return new SystemusersyncmappingprofilesRequest(contextPath.addSegment("systemusersyncmappingprofilescollection").addKeys(new NameValue(systemusersyncmappingprofileid.toString())), Optional.empty());
    }

    public Tasks tasks() {
        return new Tasks(
                        contextPath.addSegment("tasks"));
    }

    public TaskRequest tasks(String activityid) {
        return new TaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public Teammemberships teammemberships() {
        return new Teammemberships(
                        contextPath.addSegment("teammemberships"));
    }

    public TeammembershipRequest teammemberships(String teammembershipid) {
        return new TeammembershipRequest(contextPath.addSegment("teammemberships").addKeys(new NameValue(teammembershipid.toString())), Optional.empty());
    }

    public Teamprofilescollection teamprofilescollection() {
        return new Teamprofilescollection(
                        contextPath.addSegment("teamprofilescollection"));
    }

    public TeamprofilesRequest teamprofilescollection(String teamprofileid) {
        return new TeamprofilesRequest(contextPath.addSegment("teamprofilescollection").addKeys(new NameValue(teamprofileid.toString())), Optional.empty());
    }

    public Teamrolescollection teamrolescollection() {
        return new Teamrolescollection(
                        contextPath.addSegment("teamrolescollection"));
    }

    public TeamrolesRequest teamrolescollection(String teamroleid) {
        return new TeamrolesRequest(contextPath.addSegment("teamrolescollection").addKeys(new NameValue(teamroleid.toString())), Optional.empty());
    }

    public Teams teams() {
        return new Teams(
                        contextPath.addSegment("teams"));
    }

    public TeamRequest teams(String ownerid) {
        return new TeamRequest(contextPath.addSegment("teams").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public Teamsyncattributemappingprofilescollection teamsyncattributemappingprofilescollection() {
        return new Teamsyncattributemappingprofilescollection(
                        contextPath.addSegment("teamsyncattributemappingprofilescollection"));
    }

    public TeamsyncattributemappingprofilesRequest teamsyncattributemappingprofilescollection(String teamsyncattributemappingprofileid) {
        return new TeamsyncattributemappingprofilesRequest(contextPath.addSegment("teamsyncattributemappingprofilescollection").addKeys(new NameValue(teamsyncattributemappingprofileid.toString())), Optional.empty());
    }

    public Teamtemplates teamtemplates() {
        return new Teamtemplates(
                        contextPath.addSegment("teamtemplates"));
    }

    public TeamtemplateRequest teamtemplates(String teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("teamtemplates").addKeys(new NameValue(teamtemplateid.toString())), Optional.empty());
    }

    public Templates templates() {
        return new Templates(
                        contextPath.addSegment("templates"));
    }

    public TemplateRequest templates(String templateid) {
        return new TemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(templateid.toString())), Optional.empty());
    }

    public Territories territories() {
        return new Territories(
                        contextPath.addSegment("territories"));
    }

    public TerritoryRequest territories(String territoryid) {
        return new TerritoryRequest(contextPath.addSegment("territories").addKeys(new NameValue(territoryid.toString())), Optional.empty());
    }

    public Themes themes() {
        return new Themes(
                        contextPath.addSegment("themes"));
    }

    public ThemeRequest themes(String themeid) {
        return new ThemeRequest(contextPath.addSegment("themes").addKeys(new NameValue(themeid.toString())), Optional.empty());
    }

    public Timestampdatemappings timestampdatemappings() {
        return new Timestampdatemappings(
                        contextPath.addSegment("timestampdatemappings"));
    }

    public TimestampdatemappingRequest timestampdatemappings(String timestampdatemappingid) {
        return new TimestampdatemappingRequest(contextPath.addSegment("timestampdatemappings").addKeys(new NameValue(timestampdatemappingid.toString())), Optional.empty());
    }

    public Timezonedefinitions timezonedefinitions() {
        return new Timezonedefinitions(
                        contextPath.addSegment("timezonedefinitions"));
    }

    public TimezonedefinitionRequest timezonedefinitions(String timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("timezonedefinitions").addKeys(new NameValue(timezonedefinitionid.toString())), Optional.empty());
    }

    public Timezonelocalizednames timezonelocalizednames() {
        return new Timezonelocalizednames(
                        contextPath.addSegment("timezonelocalizednames"));
    }

    public TimezonelocalizednameRequest timezonelocalizednames(String timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("timezonelocalizednames").addKeys(new NameValue(timezonelocalizednameid.toString())), Optional.empty());
    }

    public Timezonerules timezonerules() {
        return new Timezonerules(
                        contextPath.addSegment("timezonerules"));
    }

    public TimezoneruleRequest timezonerules(String timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("timezonerules").addKeys(new NameValue(timezoneruleid.toString())), Optional.empty());
    }

    public Tracelogs tracelogs() {
        return new Tracelogs(
                        contextPath.addSegment("tracelogs"));
    }

    public TracelogRequest tracelogs(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelogs").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

    public Transactioncurrencies transactioncurrencies() {
        return new Transactioncurrencies(
                        contextPath.addSegment("transactioncurrencies"));
    }

    public TransactioncurrencyRequest transactioncurrencies(String transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencies").addKeys(new NameValue(transactioncurrencyid.toString())), Optional.empty());
    }

    public Transformationmappings transformationmappings() {
        return new Transformationmappings(
                        contextPath.addSegment("transformationmappings"));
    }

    public TransformationmappingRequest transformationmappings(String transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("transformationmappings").addKeys(new NameValue(transformationmappingid.toString())), Optional.empty());
    }

    public Transformationparametermappings transformationparametermappings() {
        return new Transformationparametermappings(
                        contextPath.addSegment("transformationparametermappings"));
    }

    public TransformationparametermappingRequest transformationparametermappings(String transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("transformationparametermappings").addKeys(new NameValue(transformationparametermappingid.toString())), Optional.empty());
    }

    public Translationprocesses translationprocesses() {
        return new Translationprocesses(
                        contextPath.addSegment("translationprocesses"));
    }

    public TranslationprocessRequest translationprocesses(String businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("translationprocesses").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public Userforms userforms() {
        return new Userforms(
                        contextPath.addSegment("userforms"));
    }

    public UserformRequest userforms(String userformid) {
        return new UserformRequest(contextPath.addSegment("userforms").addKeys(new NameValue(userformid.toString())), Optional.empty());
    }

    public Usermappings usermappings() {
        return new Usermappings(
                        contextPath.addSegment("usermappings"));
    }

    public UsermappingRequest usermappings(String usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("usermappings").addKeys(new NameValue(usermappingid.toString())), Optional.empty());
    }

    public Userqueries userqueries() {
        return new Userqueries(
                        contextPath.addSegment("userqueries"));
    }

    public UserqueryRequest userqueries(String userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("userqueries").addKeys(new NameValue(userqueryid.toString())), Optional.empty());
    }

    public Userqueryvisualizations userqueryvisualizations() {
        return new Userqueryvisualizations(
                        contextPath.addSegment("userqueryvisualizations"));
    }

    public UserqueryvisualizationRequest userqueryvisualizations(String userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid.toString())), Optional.empty());
    }

    public Usersettingscollection usersettingscollection() {
        return new Usersettingscollection(
                        contextPath.addSegment("usersettingscollection"));
    }

    public UsersettingsRequest usersettingscollection(String systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("usersettingscollection").addKeys(new NameValue(systemuserid.toString())), Optional.empty());
    }

    public Webresourceset webresourceset() {
        return new Webresourceset(
                        contextPath.addSegment("webresourceset"));
    }

    public WebresourceRequest webresourceset(String webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresourceset").addKeys(new NameValue(webresourceid.toString())), Optional.empty());
    }

    public Webwizards webwizards() {
        return new Webwizards(
                        contextPath.addSegment("webwizards"));
    }

    public WebwizardRequest webwizards(String webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("webwizards").addKeys(new NameValue(webwizardid.toString())), Optional.empty());
    }

    public Workflowbinaries workflowbinaries() {
        return new Workflowbinaries(
                        contextPath.addSegment("workflowbinaries"));
    }

    public WorkflowbinaryRequest workflowbinaries(String workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("workflowbinaries").addKeys(new NameValue(workflowbinaryid.toString())), Optional.empty());
    }

    public Workflowlogs workflowlogs() {
        return new Workflowlogs(
                        contextPath.addSegment("workflowlogs"));
    }

    public WorkflowlogRequest workflowlogs(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public Workflows workflows() {
        return new Workflows(
                        contextPath.addSegment("workflows"));
    }

    public WorkflowRequest workflows(String workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflows").addKeys(new NameValue(workflowid.toString())), Optional.empty());
    }

    public EntityDefinitions entityDefinitions() {
        return new EntityDefinitions(
                        contextPath.addSegment("EntityDefinitions"));
    }

    public EntityMetadataRequest entityDefinitions(String metadataId) {
        return new EntityMetadataRequest(contextPath.addSegment("EntityDefinitions").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public GlobalOptionSetDefinitions globalOptionSetDefinitions() {
        return new GlobalOptionSetDefinitions(
                        contextPath.addSegment("GlobalOptionSetDefinitions"));
    }

    public OptionSetMetadataBaseRequest globalOptionSetDefinitions(String metadataId) {
        return new OptionSetMetadataBaseRequest(contextPath.addSegment("GlobalOptionSetDefinitions").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public ManagedPropertyDefinitions managedPropertyDefinitions() {
        return new ManagedPropertyDefinitions(
                        contextPath.addSegment("ManagedPropertyDefinitions"));
    }

    public ManagedPropertyMetadataRequest managedPropertyDefinitions(String metadataId) {
        return new ManagedPropertyMetadataRequest(contextPath.addSegment("ManagedPropertyDefinitions").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public RelationshipDefinitions relationshipDefinitions() {
        return new RelationshipDefinitions(
                        contextPath.addSegment("RelationshipDefinitions"));
    }

    public RelationshipMetadataBaseRequest relationshipDefinitions(String metadataId) {
        return new RelationshipMetadataBaseRequest(contextPath.addSegment("RelationshipDefinitions").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    @Action(name = "AddAppComponents")
    @JsonIgnore
    public ActionRequestNoReturn addAppComponents(String appId, List<Crmbaseentity> components) {
        Preconditions.checkNotNull(appId, "appId cannot be null");
        Preconditions.checkNotNull(components, "components cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppId", "Edm.Guid", appId)
            .put("Components", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", components)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddAppComponents"), _parameters);
    }

    @Action(name = "AddChannelAccessProfilePrivileges")
    @JsonIgnore
    public ActionRequestNoReturn addChannelAccessProfilePrivileges(String channelAccessProfileId, List<ChannelAccessProfilePrivilege> privileges) {
        Preconditions.checkNotNull(channelAccessProfileId, "channelAccessProfileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ChannelAccessProfileId", "Edm.Guid", channelAccessProfileId)
            .put("Privileges", "Collection(Microsoft.Dynamics.CRM.ChannelAccessProfilePrivilege)", privileges)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddChannelAccessProfilePrivileges"), _parameters);
    }

    @Action(name = "AddSolutionComponent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AddSolutionComponentResponse> addSolutionComponent(String componentId, Integer componentType, String solutionUniqueName, Boolean addRequiredComponents, Boolean doNotIncludeSubcomponents, List<String> includedComponentSettingsValues) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Preconditions.checkNotNull(addRequiredComponents, "addRequiredComponents cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .put("AddRequiredComponents", "Edm.Boolean", addRequiredComponents)
            .put("DoNotIncludeSubcomponents", "Edm.Boolean", doNotIncludeSubcomponents)
            .put("IncludedComponentSettingsValues", "Collection(Edm.String)", Checks.checkIsAscii(includedComponentSettingsValues))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AddSolutionComponentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddSolutionComponent"), AddSolutionComponentResponse.class, _parameters);
    }

    @Action(name = "AlmHandler")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AlmHandlerResponse> almHandler(String action, String input) {
        Preconditions.checkNotNull(action, "action cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("action", "Edm.String", Checks.checkIsAscii(action))
            .put("input", "Edm.String", Checks.checkIsAscii(input))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AlmHandlerResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AlmHandler"), AlmHandlerResponse.class, _parameters);
    }

    @Action(name = "AnalyzeSentiment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AnalyzeSentimentResponse> analyzeSentiment(String text, String modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AnalyzeSentimentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AnalyzeSentiment"), AnalyzeSentimentResponse.class, _parameters);
    }

    @Action(name = "ApplyRecordCreationAndUpdateRule")
    @JsonIgnore
    public ActionRequestNoReturn applyRecordCreationAndUpdateRule(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ApplyRecordCreationAndUpdateRule"), _parameters);
    }

    @Action(name = "AutoMapEntity")
    @JsonIgnore
    public ActionRequestNoReturn autoMapEntity(String entityMapId) {
        Preconditions.checkNotNull(entityMapId, "entityMapId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMapId", "Edm.Guid", entityMapId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AutoMapEntity"), _parameters);
    }

    @Action(name = "BackgroundSendEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BackgroundSendEmailResponse> backgroundSendEmail(QueryBase query) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BackgroundSendEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BackgroundSendEmail"), BackgroundSendEmailResponse.class, _parameters);
    }

    @Action(name = "Book")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BookResponse> book(Crmbaseentity target, Boolean returnNotifications) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ReturnNotifications", "Edm.Boolean", returnNotifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BookResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Book"), BookResponse.class, _parameters);
    }

    @Action(name = "BulkDelete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDeleteResponse> bulkDelete(List<QueryExpression> querySet, String jobName, Boolean sendEmailNotification, List<Activityparty> toRecipients, List<Activityparty> cCRecipients, String recurrencePattern, OffsetDateTime startDateTime, String sourceImportId, Boolean runNow) {
        Preconditions.checkNotNull(jobName, "jobName cannot be null");
        Preconditions.checkNotNull(sendEmailNotification, "sendEmailNotification cannot be null");
        Preconditions.checkNotNull(toRecipients, "toRecipients cannot be null");
        Preconditions.checkNotNull(cCRecipients, "cCRecipients cannot be null");
        Preconditions.checkNotNull(recurrencePattern, "recurrencePattern cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QuerySet", "Collection(Microsoft.Dynamics.CRM.QueryExpression)", querySet)
            .put("JobName", "Edm.String", Checks.checkIsAscii(jobName))
            .put("SendEmailNotification", "Edm.Boolean", sendEmailNotification)
            .put("ToRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", toRecipients)
            .put("CCRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", cCRecipients)
            .put("RecurrencePattern", "Edm.String", Checks.checkIsAscii(recurrencePattern))
            .put("StartDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("SourceImportId", "Edm.Guid", sourceImportId)
            .put("RunNow", "Edm.Boolean", runNow)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDeleteResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BulkDelete"), BulkDeleteResponse.class, _parameters);
    }

    @Action(name = "BulkDetectDuplicates")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDetectDuplicatesResponse> bulkDetectDuplicates(QueryBase query, String jobName, Boolean sendEmailNotification, String templateId, List<Activityparty> toRecipients, List<Activityparty> cCRecipients, String recurrencePattern, OffsetDateTime recurrenceStartTime) {
        Preconditions.checkNotNull(jobName, "jobName cannot be null");
        Preconditions.checkNotNull(sendEmailNotification, "sendEmailNotification cannot be null");
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(toRecipients, "toRecipients cannot be null");
        Preconditions.checkNotNull(cCRecipients, "cCRecipients cannot be null");
        Preconditions.checkNotNull(recurrencePattern, "recurrencePattern cannot be null");
        Preconditions.checkNotNull(recurrenceStartTime, "recurrenceStartTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .put("JobName", "Edm.String", Checks.checkIsAscii(jobName))
            .put("SendEmailNotification", "Edm.Boolean", sendEmailNotification)
            .put("TemplateId", "Edm.Guid", templateId)
            .put("ToRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", toRecipients)
            .put("CCRecipients", "Collection(Microsoft.Dynamics.CRM.activityparty)", cCRecipients)
            .put("RecurrencePattern", "Edm.String", Checks.checkIsAscii(recurrencePattern))
            .put("RecurrenceStartTime", "Edm.DateTimeOffset", recurrenceStartTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDetectDuplicatesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BulkDetectDuplicates"), BulkDetectDuplicatesResponse.class, _parameters);
    }

    @Action(name = "CalculatePrice")
    @JsonIgnore
    public ActionRequestNoReturn calculatePrice(Crmbaseentity target, String parentId) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ParentId", "Edm.Guid", parentId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CalculatePrice"), _parameters);
    }

    @Action(name = "CanBeReferenced")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanBeReferencedResponse> canBeReferenced(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanBeReferencedResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanBeReferenced"), CanBeReferencedResponse.class, _parameters);
    }

    @Action(name = "CanBeReferencing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanBeReferencingResponse> canBeReferencing(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanBeReferencingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanBeReferencing"), CanBeReferencingResponse.class, _parameters);
    }

    @Action(name = "CanManyToMany")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CanManyToManyResponse> canManyToMany(String entityName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CanManyToManyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CanManyToMany"), CanManyToManyResponse.class, _parameters);
    }

    @Action(name = "CategorizeText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CategorizeTextResponse> categorizeText(String text, String modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CategorizeTextResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CategorizeText"), CategorizeTextResponse.class, _parameters);
    }

    @Action(name = "CloneAsPatch")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CloneAsPatchResponse> cloneAsPatch(String parentSolutionUniqueName, String displayName, String versionNumber) {
        Preconditions.checkNotNull(parentSolutionUniqueName, "parentSolutionUniqueName cannot be null");
        Preconditions.checkNotNull(displayName, "displayName cannot be null");
        Preconditions.checkNotNull(versionNumber, "versionNumber cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParentSolutionUniqueName", "Edm.String", Checks.checkIsAscii(parentSolutionUniqueName))
            .put("DisplayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("VersionNumber", "Edm.String", Checks.checkIsAscii(versionNumber))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CloneAsPatchResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneAsPatch"), CloneAsPatchResponse.class, _parameters);
    }

    @Action(name = "CloneAsSolution")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CloneAsSolutionResponse> cloneAsSolution(String parentSolutionUniqueName, String displayName, String versionNumber) {
        Preconditions.checkNotNull(parentSolutionUniqueName, "parentSolutionUniqueName cannot be null");
        Preconditions.checkNotNull(displayName, "displayName cannot be null");
        Preconditions.checkNotNull(versionNumber, "versionNumber cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParentSolutionUniqueName", "Edm.String", Checks.checkIsAscii(parentSolutionUniqueName))
            .put("DisplayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("VersionNumber", "Edm.String", Checks.checkIsAscii(versionNumber))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CloneAsSolutionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneAsSolution"), CloneAsSolutionResponse.class, _parameters);
    }

    @Action(name = "CommitAnnotationBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitAnnotationBlocksUploadResponse> commitAnnotationBlocksUpload(Crmbaseentity target, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitAnnotationBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitAnnotationBlocksUpload"), CommitAnnotationBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CommitAttachmentBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitAttachmentBlocksUploadResponse> commitAttachmentBlocksUpload(Crmbaseentity target, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitAttachmentBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitAttachmentBlocksUpload"), CommitAttachmentBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CommitFileBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CommitFileBlocksUploadResponse> commitFileBlocksUpload(String fileName, String mimeType, List<String> blockList, String fileContinuationToken) {
        Preconditions.checkNotNull(fileName, "fileName cannot be null");
        Preconditions.checkNotNull(mimeType, "mimeType cannot be null");
        Preconditions.checkNotNull(blockList, "blockList cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileName", "Edm.String", Checks.checkIsAscii(fileName))
            .put("MimeType", "Edm.String", Checks.checkIsAscii(mimeType))
            .put("BlockList", "Collection(Edm.String)", Checks.checkIsAscii(blockList))
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CommitFileBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CommitFileBlocksUpload"), CommitFileBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "CompoundUpdateDuplicateDetectionRule")
    @JsonIgnore
    public ActionRequestNoReturn compoundUpdateDuplicateDetectionRule(Crmbaseentity entity, List<Crmbaseentity> childEntities) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Preconditions.checkNotNull(childEntities, "childEntities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.crmbaseentity", entity)
            .put("ChildEntities", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", childEntities)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CompoundUpdateDuplicateDetectionRule"), _parameters);
    }

    @Action(name = "CreateAsyncJobToRevokeInheritedAccess")
    @JsonIgnore
    public ActionRequestNoReturn createAsyncJobToRevokeInheritedAccess(String relationshipSchema) {
        Preconditions.checkNotNull(relationshipSchema, "relationshipSchema cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RelationshipSchema", "Edm.String", Checks.checkIsAscii(relationshipSchema))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateAsyncJobToRevokeInheritedAccess"), _parameters);
    }

    @Action(name = "CreateCustomerRelationships")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CreateCustomerRelationshipsResponse> createCustomerRelationships(ComplexLookupAttributeMetadata lookup, List<ComplexOneToManyRelationshipMetadata> oneToManyRelationships, String solutionUniqueName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Lookup", "Microsoft.Dynamics.CRM.ComplexLookupAttributeMetadata", lookup)
            .put("OneToManyRelationships", "Collection(Microsoft.Dynamics.CRM.ComplexOneToManyRelationshipMetadata)", oneToManyRelationships)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CreateCustomerRelationshipsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateCustomerRelationships"), CreateCustomerRelationshipsResponse.class, _parameters);
    }

    @Action(name = "CreateInstance")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CreateInstanceResponse> createInstance(Crmbaseentity target, Integer count) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Count", "Edm.Int32", count)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CreateInstanceResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateInstance"), CreateInstanceResponse.class, _parameters);
    }

    @Action(name = "CreateKnowledgeArticleTranslation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> createKnowledgeArticleTranslation(Crmbaseentity source, Crmbaseentity language, Boolean isMajor) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("Language", "Microsoft.Dynamics.CRM.crmbaseentity", language)
            .put("IsMajor", "Edm.Boolean", isMajor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateKnowledgeArticleTranslation"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "CreateKnowledgeArticleVersion")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> createKnowledgeArticleVersion(Crmbaseentity source, Boolean isMajor) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(isMajor, "isMajor cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("IsMajor", "Edm.Boolean", isMajor)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateKnowledgeArticleVersion"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "DeleteAndPromote")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteAndPromoteResponse> deleteAndPromote(String uniqueName) {
        Preconditions.checkNotNull(uniqueName, "uniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("UniqueName", "Edm.String", Checks.checkIsAscii(uniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteAndPromoteResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteAndPromote"), DeleteAndPromoteResponse.class, _parameters);
    }

    @Action(name = "DeleteAuditData")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteAuditDataResponse> deleteAuditData(OffsetDateTime endDate) {
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteAuditDataResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteAuditData"), DeleteAuditDataResponse.class, _parameters);
    }

    @Action(name = "DeleteFile")
    @JsonIgnore
    public ActionRequestNoReturn deleteFile(String fileId) {
        Preconditions.checkNotNull(fileId, "fileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FileId", "Edm.Guid", fileId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteFile"), _parameters);
    }

    @Action(name = "DeleteOpenInstances")
    @JsonIgnore
    public ActionRequestNoReturn deleteOpenInstances(Recurringappointmentmaster target, OffsetDateTime seriesEndDate, Integer stateOfPastInstances) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(seriesEndDate, "seriesEndDate cannot be null");
        Preconditions.checkNotNull(stateOfPastInstances, "stateOfPastInstances cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurringappointmentmaster", target)
            .put("SeriesEndDate", "Edm.DateTimeOffset", seriesEndDate)
            .put("StateOfPastInstances", "Edm.Int32", stateOfPastInstances)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteOpenInstances"), _parameters);
    }

    @Action(name = "DeleteOptionValue")
    @JsonIgnore
    public ActionRequestNoReturn deleteOptionValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, String solutionUniqueName) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteOptionValue"), _parameters);
    }

    @Action(name = "DeleteRecordChangeHistory")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeleteRecordChangeHistoryResponse> deleteRecordChangeHistory(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeleteRecordChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeleteRecordChangeHistory"), DeleteRecordChangeHistoryResponse.class, _parameters);
    }

    @Action(name = "DeprovisionLanguage")
    @JsonIgnore
    public ActionRequestNoReturn deprovisionLanguage(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DeprovisionLanguage"), _parameters);
    }

    @Action(name = "DetectLanguage")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DetectLanguageResponse> detectLanguage(String text, String modelId, String countryHint) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("countryHint", "Edm.String", Checks.checkIsAscii(countryHint))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DetectLanguageResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DetectLanguage"), DetectLanguageResponse.class, _parameters);
    }

    @Action(name = "DownloadBlock")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DownloadBlockResponse> downloadBlock(Long offset, Long blockLength, String fileContinuationToken) {
        Preconditions.checkNotNull(offset, "offset cannot be null");
        Preconditions.checkNotNull(blockLength, "blockLength cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Offset", "Edm.Int64", offset)
            .put("BlockLength", "Edm.Int64", blockLength)
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DownloadBlockResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DownloadBlock"), DownloadBlockResponse.class, _parameters);
    }

    @Action(name = "DownloadSolutionExportData")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DownloadSolutionExportDataResponse> downloadSolutionExportData(String exportJobId) {
        Preconditions.checkNotNull(exportJobId, "exportJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExportJobId", "Edm.Guid", exportJobId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DownloadSolutionExportDataResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DownloadSolutionExportData"), DownloadSolutionExportDataResponse.class, _parameters);
    }

    @Action(name = "ExportSolution")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportSolutionResponse> exportSolution(String solutionName, Boolean managed, String targetVersion, Boolean exportAutoNumberingSettings, Boolean exportCalendarSettings, Boolean exportCustomizationSettings, Boolean exportEmailTrackingSettings, Boolean exportGeneralSettings, Boolean exportMarketingSettings, Boolean exportOutlookSynchronizationSettings, Boolean exportRelationshipRoles, Boolean exportIsvConfig, Boolean exportSales, Boolean exportExternalApplications) {
        Preconditions.checkNotNull(solutionName, "solutionName cannot be null");
        Preconditions.checkNotNull(managed, "managed cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionName", "Edm.String", Checks.checkIsAscii(solutionName))
            .put("Managed", "Edm.Boolean", managed)
            .put("TargetVersion", "Edm.String", Checks.checkIsAscii(targetVersion))
            .put("ExportAutoNumberingSettings", "Edm.Boolean", exportAutoNumberingSettings)
            .put("ExportCalendarSettings", "Edm.Boolean", exportCalendarSettings)
            .put("ExportCustomizationSettings", "Edm.Boolean", exportCustomizationSettings)
            .put("ExportEmailTrackingSettings", "Edm.Boolean", exportEmailTrackingSettings)
            .put("ExportGeneralSettings", "Edm.Boolean", exportGeneralSettings)
            .put("ExportMarketingSettings", "Edm.Boolean", exportMarketingSettings)
            .put("ExportOutlookSynchronizationSettings", "Edm.Boolean", exportOutlookSynchronizationSettings)
            .put("ExportRelationshipRoles", "Edm.Boolean", exportRelationshipRoles)
            .put("ExportIsvConfig", "Edm.Boolean", exportIsvConfig)
            .put("ExportSales", "Edm.Boolean", exportSales)
            .put("ExportExternalApplications", "Edm.Boolean", exportExternalApplications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportSolutionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportSolution"), ExportSolutionResponse.class, _parameters);
    }

    @Action(name = "ExportSolutionAsync")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportSolutionAsyncResponse> exportSolutionAsync(String solutionName, Boolean managed, String targetVersion, Boolean exportAutoNumberingSettings, Boolean exportCalendarSettings, Boolean exportCustomizationSettings, Boolean exportEmailTrackingSettings, Boolean exportGeneralSettings, Boolean exportMarketingSettings, Boolean exportOutlookSynchronizationSettings, Boolean exportRelationshipRoles, Boolean exportIsvConfig, Boolean exportSales, Boolean exportExternalApplications) {
        Preconditions.checkNotNull(solutionName, "solutionName cannot be null");
        Preconditions.checkNotNull(managed, "managed cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionName", "Edm.String", Checks.checkIsAscii(solutionName))
            .put("Managed", "Edm.Boolean", managed)
            .put("TargetVersion", "Edm.String", Checks.checkIsAscii(targetVersion))
            .put("ExportAutoNumberingSettings", "Edm.Boolean", exportAutoNumberingSettings)
            .put("ExportCalendarSettings", "Edm.Boolean", exportCalendarSettings)
            .put("ExportCustomizationSettings", "Edm.Boolean", exportCustomizationSettings)
            .put("ExportEmailTrackingSettings", "Edm.Boolean", exportEmailTrackingSettings)
            .put("ExportGeneralSettings", "Edm.Boolean", exportGeneralSettings)
            .put("ExportMarketingSettings", "Edm.Boolean", exportMarketingSettings)
            .put("ExportOutlookSynchronizationSettings", "Edm.Boolean", exportOutlookSynchronizationSettings)
            .put("ExportRelationshipRoles", "Edm.Boolean", exportRelationshipRoles)
            .put("ExportIsvConfig", "Edm.Boolean", exportIsvConfig)
            .put("ExportSales", "Edm.Boolean", exportSales)
            .put("ExportExternalApplications", "Edm.Boolean", exportExternalApplications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportSolutionAsyncResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportSolutionAsync"), ExportSolutionAsyncResponse.class, _parameters);
    }

    @Action(name = "ExtractKeyPhrases")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExtractKeyPhrasesResponse> extractKeyPhrases(String text, String modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExtractKeyPhrasesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExtractKeyPhrases"), ExtractKeyPhrasesResponse.class, _parameters);
    }

    @Action(name = "ExtractTextEntities")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExtractTextEntitiesResponse> extractTextEntities(String text, String modelId, String language) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("modelId", "Edm.Guid", modelId)
            .put("language", "Edm.String", Checks.checkIsAscii(language))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExtractTextEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExtractTextEntities"), ExtractTextEntitiesResponse.class, _parameters);
    }

    @Action(name = "FullTextSearchKnowledgeArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> fullTextSearchKnowledgeArticle(String searchText, Boolean useInflection, Boolean removeDuplicates, Integer stateCode, QueryBase queryExpression) {
        Preconditions.checkNotNull(searchText, "searchText cannot be null");
        Preconditions.checkNotNull(useInflection, "useInflection cannot be null");
        Preconditions.checkNotNull(removeDuplicates, "removeDuplicates cannot be null");
        Preconditions.checkNotNull(stateCode, "stateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchText", "Edm.String", Checks.checkIsAscii(searchText))
            .put("UseInflection", "Edm.Boolean", useInflection)
            .put("RemoveDuplicates", "Edm.Boolean", removeDuplicates)
            .put("StateCode", "Edm.Int32", stateCode)
            .put("QueryExpression", "Microsoft.Dynamics.CRM.QueryBase", queryExpression)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FullTextSearchKnowledgeArticle"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "GetAutoNumberSeed")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetAutoNumberSeedResponse> getAutoNumberSeed(String entityName, String attributeName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetAutoNumberSeedResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetAutoNumberSeed"), GetAutoNumberSeedResponse.class, _parameters);
    }

    @Action(name = "GetJobStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetJobStatusResponse> getJobStatus(Boolean istrain, String correlationid, String aimodelid) {
        Preconditions.checkNotNull(istrain, "istrain cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("istrain", "Edm.Boolean", istrain)
            .put("correlationid", "Edm.Guid", correlationid)
            .put("aimodelid", "Edm.Guid", aimodelid)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetJobStatusResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetJobStatus"), GetJobStatusResponse.class, _parameters);
    }

    @Action(name = "GetNextAutoNumberValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetNextAutoNumberValueResponse> getNextAutoNumberValue(String entityName, String attributeName) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetNextAutoNumberValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetNextAutoNumberValue"), GetNextAutoNumberValueResponse.class, _parameters);
    }

    @Action(name = "GetTrackingTokenEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GetTrackingTokenEmailResponse> getTrackingTokenEmail(String subject) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GetTrackingTokenEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetTrackingTokenEmail"), GetTrackingTokenEmailResponse.class, _parameters);
    }

    @Action(name = "GrantAccess")
    @JsonIgnore
    public ActionRequestNoReturn grantAccess(Crmbaseentity target, PrincipalAccess principalAccess) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PrincipalAccess", "Microsoft.Dynamics.CRM.PrincipalAccess", principalAccess)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GrantAccess"), _parameters);
    }

    @Action(name = "ImmediateBook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ImmediateBookResponse> immediateBook(Crmbaseentity target, List<String> attachmentIds, String eWSUrl, String attachmentToken) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("AttachmentIds", "Collection(Edm.String)", Checks.checkIsAscii(attachmentIds))
            .put("EWSUrl", "Edm.String", Checks.checkIsAscii(eWSUrl))
            .put("AttachmentToken", "Edm.String", Checks.checkIsAscii(attachmentToken))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ImmediateBookResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImmediateBook"), ImmediateBookResponse.class, _parameters);
    }

    @Action(name = "ImportCardTypeSchema")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ImportCardTypeSchemaResponse> importCardTypeSchema(String importCardTypeSchema) {
        Preconditions.checkNotNull(importCardTypeSchema, "importCardTypeSchema cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportCardTypeSchema", "Edm.String", Checks.checkIsAscii(importCardTypeSchema))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ImportCardTypeSchemaResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportCardTypeSchema"), ImportCardTypeSchemaResponse.class, _parameters);
    }

    @Action(name = "ImportFieldTranslation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Importjob> importFieldTranslation(byte[] translationFile) {
        Preconditions.checkNotNull(translationFile, "translationFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TranslationFile", "Edm.Binary", translationFile)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Importjob>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportFieldTranslation"), Importjob.class, _parameters);
    }

    @Action(name = "ImportMappingsImportMap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Importmap> importMappingsImportMap(String mappingsXml, Boolean replaceIds) {
        Preconditions.checkNotNull(mappingsXml, "mappingsXml cannot be null");
        Preconditions.checkNotNull(replaceIds, "replaceIds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MappingsXml", "Edm.String", Checks.checkIsAscii(mappingsXml))
            .put("ReplaceIds", "Edm.Boolean", replaceIds)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Importmap>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportMappingsImportMap"), Importmap.class, _parameters);
    }

    @Action(name = "ImportSolution")
    @JsonIgnore
    public ActionRequestNoReturn importSolution(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFile, String importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean holdingSolution, Boolean skipQueueRibbonJob, LayerDesiredOrder layerDesiredOrder, Boolean asyncRibbonProcessing, List<Crmbaseentity> componentParameters) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("HoldingSolution", "Edm.Boolean", holdingSolution)
            .put("SkipQueueRibbonJob", "Edm.Boolean", skipQueueRibbonJob)
            .put("LayerDesiredOrder", "Microsoft.Dynamics.CRM.LayerDesiredOrder", layerDesiredOrder)
            .put("AsyncRibbonProcessing", "Edm.Boolean", asyncRibbonProcessing)
            .put("ComponentParameters", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", componentParameters)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportSolution"), _parameters);
    }

    @Action(name = "ImportSolutions")
    @JsonIgnore
    public ActionRequestNoReturn importSolutions(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFiles, String importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean holdingSolution) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFiles, "customizationFiles cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFiles", "Edm.Binary", customizationFiles)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("HoldingSolution", "Edm.Boolean", holdingSolution)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportSolutions"), _parameters);
    }

    @Action(name = "ImportTranslation")
    @JsonIgnore
    public ActionRequestNoReturn importTranslation(byte[] translationFile, String importJobId) {
        Preconditions.checkNotNull(translationFile, "translationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TranslationFile", "Edm.Binary", translationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportTranslation"), _parameters);
    }

    @Action(name = "InitializeAnnotationBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksDownloadResponse> initializeAnnotationBlocksDownload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAnnotationBlocksDownload"), InitializeAnnotationBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeAnnotationBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksUploadResponse> initializeAnnotationBlocksUpload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAnnotationBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAnnotationBlocksUpload"), InitializeAnnotationBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InitializeAttachmentBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksDownloadResponse> initializeAttachmentBlocksDownload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownload"), InitializeAttachmentBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeAttachmentBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksUploadResponse> initializeAttachmentBlocksUpload(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeAttachmentBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeAttachmentBlocksUpload"), InitializeAttachmentBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InitializeFileBlocksDownload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksDownloadResponse> initializeFileBlocksDownload(Crmbaseentity target, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksDownloadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFileBlocksDownload"), InitializeFileBlocksDownloadResponse.class, _parameters);
    }

    @Action(name = "InitializeFileBlocksUpload")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksUploadResponse> initializeFileBlocksUpload(Crmbaseentity target, String fileName, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileName, "fileName cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileName", "Edm.String", Checks.checkIsAscii(fileName))
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InitializeFileBlocksUploadResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFileBlocksUpload"), InitializeFileBlocksUploadResponse.class, _parameters);
    }

    @Action(name = "InsertOptionValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InsertOptionValueResponse> insertOptionValue(String color, String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, List<Integer> parentValues, String solutionUniqueName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Color", "Edm.String", Checks.checkIsAscii(color))
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("ParentValues", "Collection(Edm.Int32)", parentValues)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InsertOptionValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InsertOptionValue"), InsertOptionValueResponse.class, _parameters);
    }

    @Action(name = "InsertStatusValue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<InsertStatusValueResponse> insertStatusValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Integer stateCode, String solutionUniqueName) {
        Preconditions.checkNotNull(stateCode, "stateCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("StateCode", "Edm.Int32", stateCode)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<InsertStatusValueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InsertStatusValue"), InsertStatusValueResponse.class, _parameters);
    }

    @Action(name = "InstallSampleData")
    @JsonIgnore
    public ActionRequestNoReturn installSampleData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InstallSampleData"), _parameters);
    }

    @Action(name = "InstantiateTemplate")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> instantiateTemplate(String templateId, String objectType, String objectId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(objectType, "objectType cannot be null");
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("ObjectType", "Edm.String", Checks.checkIsAscii(objectType))
            .put("ObjectId", "Edm.Guid", objectId)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InstantiateTemplate"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "IsPaiEnabled")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<IsPaiEnabledResponse> isPaiEnabled() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<IsPaiEnabledResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsPaiEnabled"), IsPaiEnabledResponse.class, _parameters);
    }

    @Action(name = "Merge")
    @JsonIgnore
    public ActionRequestNoReturn merge(Crmbaseentity target, Crmbaseentity subordinate, Crmbaseentity updateContent, Boolean performParentingChecks) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(subordinate, "subordinate cannot be null");
        Preconditions.checkNotNull(updateContent, "updateContent cannot be null");
        Preconditions.checkNotNull(performParentingChecks, "performParentingChecks cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Subordinate", "Microsoft.Dynamics.CRM.crmbaseentity", subordinate)
            .put("UpdateContent", "Microsoft.Dynamics.CRM.crmbaseentity", updateContent)
            .put("PerformParentingChecks", "Edm.Boolean", performParentingChecks)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Merge"), _parameters);
    }

    @Action(name = "ModifyAccess")
    @JsonIgnore
    public ActionRequestNoReturn modifyAccess(Crmbaseentity target, PrincipalAccess principalAccess) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PrincipalAccess", "Microsoft.Dynamics.CRM.PrincipalAccess", principalAccess)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ModifyAccess"), _parameters);
    }

    @Action(name = "msdyn_ActivateProcesses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateProcessesResponse> msdyn_ActivateProcesses(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateProcessesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ActivateProcesses"), Msdyn_ActivateProcessesResponse.class, _parameters);
    }

    @Action(name = "msdyn_ActivateSdkMessageProcessingSteps")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateSdkMessageProcessingStepsResponse> msdyn_ActivateSdkMessageProcessingSteps(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ActivateSdkMessageProcessingStepsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ActivateSdkMessageProcessingSteps"), Msdyn_ActivateSdkMessageProcessingStepsResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedOptionSet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedOptionSetResponse> msdyn_CheckForCustomizedOptionSet(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedOptionSetResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedOptionSet"), Msdyn_CheckForCustomizedOptionSetResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedSitemap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedSitemapResponse> msdyn_CheckForCustomizedSitemap(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedSitemapResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemap"), Msdyn_CheckForCustomizedSitemapResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForCustomizedWebResources")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedWebResourcesResponse> msdyn_CheckForCustomizedWebResources(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForCustomizedWebResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedWebResources"), Msdyn_CheckForCustomizedWebResourcesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedProcess")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedProcessResponse> msdyn_CheckForDeletedProcess(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedProcessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedProcess"), Msdyn_CheckForDeletedProcessResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedSDKMessageProcessingSteps")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse> msdyn_CheckForDeletedSDKMessageProcessingSteps(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedSDKMessageProcessingSteps"), Msdyn_CheckForDeletedSDKMessageProcessingStepsResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForDeletedWebResources")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedWebResourcesResponse> msdyn_CheckForDeletedWebResources(String entityIds, String solutionId, String excludeSolutionIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .put("ExcludeSolutionIds", "Edm.String", Checks.checkIsAscii(excludeSolutionIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForDeletedWebResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForDeletedWebResources"), Msdyn_CheckForDeletedWebResourcesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckForPendingProcesses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForPendingProcessesResponse> msdyn_CheckForPendingProcesses(String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckForPendingProcessesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckForPendingProcesses"), Msdyn_CheckForPendingProcessesResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfProcessesAreActive")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesAreActiveResponse> msdyn_CheckIfProcessesAreActive(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesAreActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfProcessesAreActive"), Msdyn_CheckIfProcessesAreActiveResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfProcessesOwnedByDisabledUsers")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse> msdyn_CheckIfProcessesOwnedByDisabledUsers(String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfProcessesOwnedByDisabledUsers"), Msdyn_CheckIfProcessesOwnedByDisabledUsersResponse.class, _parameters);
    }

    @Action(name = "msdyn_CheckIfSDKMessageProcessingStepsAreActive")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse> msdyn_CheckIfSDKMessageProcessingStepsAreActive(String entityIds, String solutionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityIds", "Edm.String", Checks.checkIsAscii(entityIds))
            .put("SolutionId", "Edm.String", Checks.checkIsAscii(solutionId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CheckIfSDKMessageProcessingStepsAreActive"), Msdyn_CheckIfSDKMessageProcessingStepsAreActiveResponse.class, _parameters);
    }

    @Action(name = "msdyn_ConditionXmlConversion")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_ConditionXmlConversionResponse> msdyn_ConditionXmlConversion(String inputType, String outputType, String inputString, String entityName) {
        Preconditions.checkNotNull(inputType, "inputType cannot be null");
        Preconditions.checkNotNull(outputType, "outputType cannot be null");
        Preconditions.checkNotNull(inputString, "inputString cannot be null");
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputType", "Edm.String", Checks.checkIsAscii(inputType))
            .put("OutputType", "Edm.String", Checks.checkIsAscii(outputType))
            .put("InputString", "Edm.String", Checks.checkIsAscii(inputString))
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_ConditionXmlConversionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ConditionXmlConversion"), Msdyn_ConditionXmlConversionResponse.class, _parameters);
    }

    @Action(name = "msdyn_CreateActionFlow")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_CreateActionFlow(String sLAId) {
        Preconditions.checkNotNull(sLAId, "sLAId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SLAId", "Edm.String", Checks.checkIsAscii(sLAId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CreateActionFlow"), _parameters);
    }

    @Action(name = "msdyn_CreateNewAnalysisJobForRuleSet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_analysisjob> msdyn_CreateNewAnalysisJobForRuleSet(Msdyn_solutionhealthruleset solutionHealthRuleSet) {
        Preconditions.checkNotNull(solutionHealthRuleSet, "solutionHealthRuleSet cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionHealthRuleSet", "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset", solutionHealthRuleSet)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_analysisjob>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_CreateNewAnalysisJobForRuleSet"), Msdyn_analysisjob.class, _parameters);
    }

    @Action(name = "msdyn_DeleteCalendar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_DeleteCalendarResponse> msdyn_DeleteCalendar(String calendarEventInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CalendarEventInfo", "Edm.String", Checks.checkIsAscii(calendarEventInfo))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_DeleteCalendarResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_DeleteCalendar"), Msdyn_DeleteCalendarResponse.class, _parameters);
    }

    @Action(name = "msdyn_GetKAObjectFromTemplate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> msdyn_GetKAObjectFromTemplate(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_GetKAObjectFromTemplate"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "msdyn_ManageSLAInstances")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_ManageSLAInstances(String sLAId, String regardingId, String entityLogicalName) {
        Preconditions.checkNotNull(sLAId, "sLAId cannot be null");
        Preconditions.checkNotNull(regardingId, "regardingId cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SLAId", "Edm.String", Checks.checkIsAscii(sLAId))
            .put("RegardingId", "Edm.String", Checks.checkIsAscii(regardingId))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ManageSLAInstances"), _parameters);
    }

    @Action(name = "msdyn_RegisterSolutionHealthRule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_RegisterSolutionHealthRuleResponse> msdyn_RegisterSolutionHealthRule(String ruleDescription, String owningSolutionId, String uniqueName, Crmbaseentity resolutionAction, Msdyn_solutionhealthruleset ruleSetId, String ruleArguments, String ruleName, Workflow workflowReference, String resolutionMessage) {
        Preconditions.checkNotNull(ruleSetId, "ruleSetId cannot be null");
        Preconditions.checkNotNull(ruleName, "ruleName cannot be null");
        Preconditions.checkNotNull(workflowReference, "workflowReference cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RuleDescription", "Edm.String", Checks.checkIsAscii(ruleDescription))
            .put("OwningSolutionId", "Edm.String", Checks.checkIsAscii(owningSolutionId))
            .put("UniqueName", "Edm.String", Checks.checkIsAscii(uniqueName))
            .put("ResolutionAction", "Microsoft.Dynamics.CRM.crmbaseentity", resolutionAction)
            .put("RuleSetId", "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset", ruleSetId)
            .put("RuleArguments", "Edm.String", Checks.checkIsAscii(ruleArguments))
            .put("RuleName", "Edm.String", Checks.checkIsAscii(ruleName))
            .put("WorkflowReference", "Microsoft.Dynamics.CRM.workflow", workflowReference)
            .put("ResolutionMessage", "Edm.String", Checks.checkIsAscii(resolutionMessage))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_RegisterSolutionHealthRuleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_RegisterSolutionHealthRule"), Msdyn_RegisterSolutionHealthRuleResponse.class, _parameters);
    }

    @Action(name = "msdyn_ResolveSolutionHealthRuleFailure")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_ResolveSolutionHealthRuleFailure(Crmbaseentity analysisResult) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisResult", "Microsoft.Dynamics.CRM.crmbaseentity", analysisResult)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_ResolveSolutionHealthRuleFailure"), _parameters);
    }

    @Action(name = "msdyn_RunSolutionCheckerRules")
    @JsonIgnore
    public ActionRequestNoReturn msdyn_RunSolutionCheckerRules(String analysisComponentId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AnalysisComponentId", "Edm.String", Checks.checkIsAscii(analysisComponentId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_RunSolutionCheckerRules"), _parameters);
    }

    @Action(name = "msdyn_SaveCalendar")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Msdyn_SaveCalendarResponse> msdyn_SaveCalendar(String calendarEventInfo) {
        Preconditions.checkNotNull(calendarEventInfo, "calendarEventInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CalendarEventInfo", "Edm.String", Checks.checkIsAscii(calendarEventInfo))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Msdyn_SaveCalendarResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.msdyn_SaveCalendar"), Msdyn_SaveCalendarResponse.class, _parameters);
    }

    @Action(name = "OrderOption")
    @JsonIgnore
    public ActionRequestNoReturn orderOption(String optionSetName, String attributeLogicalName, String entityLogicalName, List<Integer> values, String solutionUniqueName) {
        Preconditions.checkNotNull(values, "values cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Values", "Collection(Edm.Int32)", values)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OrderOption"), _parameters);
    }

    @Action(name = "ProvisionLanguage")
    @JsonIgnore
    public ActionRequestNoReturn provisionLanguage(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ProvisionLanguage"), _parameters);
    }

    @Action(name = "ProvisionLanguageAsync")
    @JsonIgnore
    public ActionRequestNoReturn provisionLanguageAsync(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ProvisionLanguageAsync"), _parameters);
    }

    @Action(name = "PublishAllXml")
    @JsonIgnore
    public ActionRequestNoReturn publishAllXml() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishAllXml"), _parameters);
    }

    @Action(name = "PublishXml")
    @JsonIgnore
    public ActionRequestNoReturn publishXml(String parameterXml) {
        Preconditions.checkNotNull(parameterXml, "parameterXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ParameterXml", "Edm.String", Checks.checkIsAscii(parameterXml))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishXml"), _parameters);
    }

    @Action(name = "QueryExpressionToFetchXml")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<QueryExpressionToFetchXmlResponse> queryExpressionToFetchXml(QueryBase query) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<QueryExpressionToFetchXmlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QueryExpressionToFetchXml"), QueryExpressionToFetchXmlResponse.class, _parameters);
    }

    @Action(name = "QueueUpdateRibbonClientMetadata")
    @JsonIgnore
    public ActionRequestNoReturn queueUpdateRibbonClientMetadata() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QueueUpdateRibbonClientMetadata"), _parameters);
    }

    @Action(name = "ReactivateEntityKey")
    @JsonIgnore
    public ActionRequestNoReturn reactivateEntityKey(String entityKeyLogicalName, String entityLogicalName) {
        Preconditions.checkNotNull(entityKeyLogicalName, "entityKeyLogicalName cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityKeyLogicalName", "Edm.String", Checks.checkIsAscii(entityKeyLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReactivateEntityKey"), _parameters);
    }

    @Action(name = "ReassignObjectsOwner")
    @JsonIgnore
    public ActionRequestNoReturn reassignObjectsOwner(Crmbaseentity fromPrincipal, Crmbaseentity toPrincipal) {
        Preconditions.checkNotNull(fromPrincipal, "fromPrincipal cannot be null");
        Preconditions.checkNotNull(toPrincipal, "toPrincipal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FromPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", fromPrincipal)
            .put("ToPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", toPrincipal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReassignObjectsOwner"), _parameters);
    }

    @Action(name = "RecognizeText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecognizeTextResponse> recognizeText(String modelId, String base64encoded) {
        Preconditions.checkNotNull(base64encoded, "base64encoded cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("modelId", "Edm.Guid", modelId)
            .put("base64encoded", "Edm.String", Checks.checkIsAscii(base64encoded))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecognizeTextResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RecognizeText"), RecognizeTextResponse.class, _parameters);
    }

    @Action(name = "RemoveAppComponents")
    @JsonIgnore
    public ActionRequestNoReturn removeAppComponents(String appId, List<Crmbaseentity> components) {
        Preconditions.checkNotNull(appId, "appId cannot be null");
        Preconditions.checkNotNull(components, "components cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppId", "Edm.Guid", appId)
            .put("Components", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", components)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveAppComponents"), _parameters);
    }

    @Action(name = "RemoveParent")
    @JsonIgnore
    public ActionRequestNoReturn removeParent(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveParent"), _parameters);
    }

    @Action(name = "RemoveSolutionComponent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RemoveSolutionComponentResponse> removeSolutionComponent(Solutioncomponent solutionComponent, Integer componentType, String solutionUniqueName) {
        Preconditions.checkNotNull(solutionComponent, "solutionComponent cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionComponent", "Microsoft.Dynamics.CRM.solutioncomponent", solutionComponent)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RemoveSolutionComponentResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveSolutionComponent"), RemoveSolutionComponentResponse.class, _parameters);
    }

    @Action(name = "Reschedule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RescheduleResponse> reschedule(Crmbaseentity target, Boolean returnNotifications) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("ReturnNotifications", "Edm.Boolean", returnNotifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RescheduleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Reschedule"), RescheduleResponse.class, _parameters);
    }

    @Action(name = "ResetUserFilters")
    @JsonIgnore
    public ActionRequestNoReturn resetUserFilters(Integer queryType) {
        Preconditions.checkNotNull(queryType, "queryType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QueryType", "Edm.Int32", queryType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ResetUserFilters"), _parameters);
    }

    @Action(name = "RetrieveAccessOrigin")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RetrieveAccessOriginResponse> retrieveAccessOrigin(String objectId, String logicalName, String principalId) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(logicalName, "logicalName cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("LogicalName", "Edm.String", Checks.checkIsAscii(logicalName))
            .put("PrincipalId", "Edm.Guid", principalId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RetrieveAccessOriginResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAccessOrigin"), RetrieveAccessOriginResponse.class, _parameters);
    }

    @Action(name = "RevokeAccess")
    @JsonIgnore
    public ActionRequestNoReturn revokeAccess(Crmbaseentity target, Crmbaseentity revokee) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(revokee, "revokee cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Revokee", "Microsoft.Dynamics.CRM.crmbaseentity", revokee)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RevokeAccess"), _parameters);
    }

    @Action(name = "RouteTo")
    @JsonIgnore
    public ActionRequestNoReturn routeTo(Crmbaseentity target, Queueitem queueItem) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("QueueItem", "Microsoft.Dynamics.CRM.queueitem", queueItem)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RouteTo"), _parameters);
    }

    @Action(name = "SaveAppSetting")
    @JsonIgnore
    public ActionRequestNoReturn saveAppSetting(String appUniqueName, String settingName, String value) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(settingName, "settingName cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("SettingName", "Edm.String", Checks.checkIsAscii(settingName))
            .put("Value", "Edm.String", Checks.checkIsAscii(value))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SaveAppSetting"), _parameters);
    }

    @Action(name = "SendBulkMail")
    @JsonIgnore
    public ActionRequestNoReturn sendBulkMail(Crmbaseentity sender, String templateId, String regardingType, String regardingId, QueryBase query) {
        Preconditions.checkNotNull(sender, "sender cannot be null");
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(regardingType, "regardingType cannot be null");
        Preconditions.checkNotNull(regardingId, "regardingId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Sender", "Microsoft.Dynamics.CRM.crmbaseentity", sender)
            .put("TemplateId", "Edm.Guid", templateId)
            .put("RegardingType", "Edm.String", Checks.checkIsAscii(regardingType))
            .put("RegardingId", "Edm.Guid", regardingId)
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendBulkMail"), _parameters);
    }

    @Action(name = "SendEmailFromTemplate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Email> sendEmailFromTemplate(String templateId, Crmbaseentity regarding, Crmbaseentity target) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(regarding, "regarding cannot be null");
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("Regarding", "Microsoft.Dynamics.CRM.crmbaseentity", regarding)
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Email>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendEmailFromTemplate"), Email.class, _parameters);
    }

    @Action(name = "SendFax")
    @JsonIgnore
    public ActionRequestNoReturn sendFax(String faxId, Boolean issueSend) {
        Preconditions.checkNotNull(faxId, "faxId cannot be null");
        Preconditions.checkNotNull(issueSend, "issueSend cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FaxId", "Edm.Guid", faxId)
            .put("IssueSend", "Edm.Boolean", issueSend)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendFax"), _parameters);
    }

    @Action(name = "SendTemplate")
    @JsonIgnore
    public ActionRequestNoReturn sendTemplate(String templateId, Crmbaseentity sender, List<Crmbaseentity> recipients, Crmbaseentity regarding, Integer deliveryPriorityCode) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Preconditions.checkNotNull(sender, "sender cannot be null");
        Preconditions.checkNotNull(recipients, "recipients cannot be null");
        Preconditions.checkNotNull(regarding, "regarding cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateId", "Edm.Guid", templateId)
            .put("Sender", "Microsoft.Dynamics.CRM.crmbaseentity", sender)
            .put("Recipients", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", recipients)
            .put("Regarding", "Microsoft.Dynamics.CRM.crmbaseentity", regarding)
            .put("DeliveryPriorityCode", "Edm.Int32", deliveryPriorityCode)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SendTemplate"), _parameters);
    }

    @Action(name = "SetAutoNumberSeed")
    @JsonIgnore
    public ActionRequestNoReturn setAutoNumberSeed(String entityName, String attributeName, Long value) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("Value", "Edm.Int64", value)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetAutoNumberSeed"), _parameters);
    }

    @Action(name = "SetDataEncryptionKey")
    @JsonIgnore
    public ActionRequestNoReturn setDataEncryptionKey(String encryptionKey, Boolean changeEncryptionKey) {
        Preconditions.checkNotNull(encryptionKey, "encryptionKey cannot be null");
        Preconditions.checkNotNull(changeEncryptionKey, "changeEncryptionKey cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EncryptionKey", "Edm.String", Checks.checkIsAscii(encryptionKey))
            .put("ChangeEncryptionKey", "Edm.Boolean", changeEncryptionKey)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetDataEncryptionKey"), _parameters);
    }

    @Action(name = "SetFeatureStatus")
    @JsonIgnore
    public ActionRequestNoReturn setFeatureStatus(Integer featureType, Boolean status, String configData, Boolean isSolutionUninstall) {
        Preconditions.checkNotNull(featureType, "featureType cannot be null");
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FeatureType", "Edm.Int32", featureType)
            .put("Status", "Edm.Boolean", status)
            .put("ConfigData", "Edm.String", Checks.checkIsAscii(configData))
            .put("IsSolutionUninstall", "Edm.Boolean", isSolutionUninstall)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetFeatureStatus"), _parameters);
    }

    @Action(name = "SetLocLabels")
    @JsonIgnore
    public ActionRequestNoReturn setLocLabels(Crmbaseentity entityMoniker, String attributeName, List<LocalizedLabel> labels) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("Labels", "Collection(Microsoft.Dynamics.CRM.LocalizedLabel)", labels)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetLocLabels"), _parameters);
    }

    @Action(name = "SetProcess")
    @JsonIgnore
    public ActionRequestNoReturn setProcess(Crmbaseentity target, Crmbaseentity newProcess, Crmbaseentity newProcessInstance) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("NewProcess", "Microsoft.Dynamics.CRM.crmbaseentity", newProcess)
            .put("NewProcessInstance", "Microsoft.Dynamics.CRM.crmbaseentity", newProcessInstance)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetProcess"), _parameters);
    }

    @Action(name = "SetReportRelated")
    @JsonIgnore
    public ActionRequestNoReturn setReportRelated(String reportId, List<Integer> entities, List<Integer> categories, List<Integer> visibility) {
        Preconditions.checkNotNull(reportId, "reportId cannot be null");
        Preconditions.checkNotNull(entities, "entities cannot be null");
        Preconditions.checkNotNull(categories, "categories cannot be null");
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReportId", "Edm.Guid", reportId)
            .put("Entities", "Collection(Edm.Int32)", entities)
            .put("Categories", "Collection(Edm.Int32)", categories)
            .put("Visibility", "Collection(Edm.Int32)", visibility)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetReportRelated"), _parameters);
    }

    @Action(name = "StageAndUpgrade")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StageAndUpgradeResponse> stageAndUpgrade(Boolean overwriteUnmanagedCustomizations, Boolean publishWorkflows, byte[] customizationFile, String importJobId, Boolean convertToManaged, Boolean skipProductUpdateDependencies, Boolean skipQueueRibbonJob, Boolean asyncRibbonProcessing, List<Crmbaseentity> componentParameters) {
        Preconditions.checkNotNull(overwriteUnmanagedCustomizations, "overwriteUnmanagedCustomizations cannot be null");
        Preconditions.checkNotNull(publishWorkflows, "publishWorkflows cannot be null");
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OverwriteUnmanagedCustomizations", "Edm.Boolean", overwriteUnmanagedCustomizations)
            .put("PublishWorkflows", "Edm.Boolean", publishWorkflows)
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .put("ImportJobId", "Edm.Guid", importJobId)
            .put("ConvertToManaged", "Edm.Boolean", convertToManaged)
            .put("SkipProductUpdateDependencies", "Edm.Boolean", skipProductUpdateDependencies)
            .put("SkipQueueRibbonJob", "Edm.Boolean", skipQueueRibbonJob)
            .put("AsyncRibbonProcessing", "Edm.Boolean", asyncRibbonProcessing)
            .put("ComponentParameters", "Collection(Microsoft.Dynamics.CRM.crmbaseentity)", componentParameters)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StageAndUpgradeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.StageAndUpgrade"), StageAndUpgradeResponse.class, _parameters);
    }

    @Action(name = "SyncBulkOperation")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SyncBulkOperationResponse> syncBulkOperation(List<QueryExpression> querySet, Integer operationType) {
        Preconditions.checkNotNull(operationType, "operationType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("QuerySet", "Collection(Microsoft.Dynamics.CRM.QueryExpression)", querySet)
            .put("OperationType", "Edm.Int32", operationType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SyncBulkOperationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SyncBulkOperation"), SyncBulkOperationResponse.class, _parameters);
    }

    @Action(name = "TransformImport")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> transformImport(String importId) {
        Preconditions.checkNotNull(importId, "importId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportId", "Edm.Guid", importId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.TransformImport"), Asyncoperation.class, _parameters);
    }

    @Action(name = "UninstallSampleData")
    @JsonIgnore
    public ActionRequestNoReturn uninstallSampleData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UninstallSampleData"), _parameters);
    }

    @Action(name = "UnpublishDuplicateRule")
    @JsonIgnore
    public ActionRequestNoReturn unpublishDuplicateRule(String duplicateRuleId) {
        Preconditions.checkNotNull(duplicateRuleId, "duplicateRuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DuplicateRuleId", "Edm.Guid", duplicateRuleId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnpublishDuplicateRule"), _parameters);
    }

    @Action(name = "UpdateFeatureConfig")
    @JsonIgnore
    public ActionRequestNoReturn updateFeatureConfig(Integer featureType, String configData) {
        Preconditions.checkNotNull(featureType, "featureType cannot be null");
        Preconditions.checkNotNull(configData, "configData cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FeatureType", "Edm.Int32", featureType)
            .put("ConfigData", "Edm.String", Checks.checkIsAscii(configData))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateFeatureConfig"), _parameters);
    }

    @Action(name = "UpdateOptionValue")
    @JsonIgnore
    public ActionRequestNoReturn updateOptionValue(String color, String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Boolean mergeLabels, List<Integer> parentValues, String solutionUniqueName) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(mergeLabels, "mergeLabels cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Color", "Edm.String", Checks.checkIsAscii(color))
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("MergeLabels", "Edm.Boolean", mergeLabels)
            .put("ParentValues", "Collection(Edm.Int32)", parentValues)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateOptionValue"), _parameters);
    }

    @Action(name = "UpdateRibbonClientMetadata")
    @JsonIgnore
    public ActionRequestNoReturn updateRibbonClientMetadata() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateRibbonClientMetadata"), _parameters);
    }

    @Action(name = "UpdateSolutionComponent")
    @JsonIgnore
    public ActionRequestNoReturn updateSolutionComponent(String componentId, Integer componentType, String solutionUniqueName, List<String> includedComponentSettingsValues) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .put("IncludedComponentSettingsValues", "Collection(Edm.String)", Checks.checkIsAscii(includedComponentSettingsValues))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateSolutionComponent"), _parameters);
    }

    @Action(name = "UpdateStateValue")
    @JsonIgnore
    public ActionRequestNoReturn updateStateValue(String optionSetName, String attributeLogicalName, String entityLogicalName, Integer value, Label label, Label description, Boolean mergeLabels, Integer defaultStatusCode) {
        Preconditions.checkNotNull(value, "value cannot be null");
        Preconditions.checkNotNull(mergeLabels, "mergeLabels cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("OptionSetName", "Edm.String", Checks.checkIsAscii(optionSetName))
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("Value", "Edm.Int32", value)
            .put("Label", "Microsoft.Dynamics.CRM.Label", label)
            .put("Description", "Microsoft.Dynamics.CRM.Label", description)
            .put("MergeLabels", "Edm.Boolean", mergeLabels)
            .put("DefaultStatusCode", "Edm.Int32", defaultStatusCode)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UpdateStateValue"), _parameters);
    }

    @Action(name = "UploadBlock")
    @JsonIgnore
    public ActionRequestNoReturn uploadBlock(String blockId, byte[] blockData, String fileContinuationToken) {
        Preconditions.checkNotNull(blockId, "blockId cannot be null");
        Preconditions.checkNotNull(blockData, "blockData cannot be null");
        Preconditions.checkNotNull(fileContinuationToken, "fileContinuationToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("BlockId", "Edm.String", Checks.checkIsAscii(blockId))
            .put("BlockData", "Edm.Binary", blockData)
            .put("FileContinuationToken", "Edm.String", Checks.checkIsAscii(fileContinuationToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UploadBlock"), _parameters);
    }

    @Action(name = "Validate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ValidateResponse> validate(List<Activitypointer> activities) {
        Preconditions.checkNotNull(activities, "activities cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Activities", "Collection(Microsoft.Dynamics.CRM.activitypointer)", activities)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ValidateResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Validate"), ValidateResponse.class, _parameters);
    }

    @Action(name = "ValidateAIConfiguration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ValidateAIConfigurationResponse> validateAIConfiguration(String version, String aiconfigurationId) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Preconditions.checkNotNull(aiconfigurationId, "aiconfigurationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("aiconfigurationId", "Edm.String", Checks.checkIsAscii(aiconfigurationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ValidateAIConfigurationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateAIConfiguration"), ValidateAIConfigurationResponse.class, _parameters);
    }

    @Action(name = "ValidateUnpublished")
    @JsonIgnore
    public ActionRequestNoReturn validateUnpublished(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateUnpublished"), _parameters);
    }

    @Function(name = "CalculateRollupField")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> calculateRollupField(Crmbaseentity target, String fieldName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fieldName, "fieldName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FieldName", "Edm.String", Checks.checkIsAscii(fieldName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CalculateRollupField"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "CheckIncomingEmail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<CheckIncomingEmailResponse> checkIncomingEmail(String messageId, String subject, String from, String to, String cc, String bcc, Email extraProperties) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(from, "from cannot be null");
        Preconditions.checkNotNull(to, "to cannot be null");
        Preconditions.checkNotNull(cc, "cc cannot be null");
        Preconditions.checkNotNull(bcc, "bcc cannot be null");
        Preconditions.checkNotNull(extraProperties, "extraProperties cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("From", "Edm.String", Checks.checkIsAscii(from))
            .put("To", "Edm.String", Checks.checkIsAscii(to))
            .put("Cc", "Edm.String", Checks.checkIsAscii(cc))
            .put("Bcc", "Edm.String", Checks.checkIsAscii(bcc))
            .put("ExtraProperties", "Microsoft.Dynamics.CRM.email", extraProperties)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<CheckIncomingEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CheckIncomingEmail"), CheckIncomingEmailResponse.class, _parameters);
    }

    @Function(name = "CheckPromoteEmail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<CheckPromoteEmailResponse> checkPromoteEmail(String messageId, String subject, Integer directionCode) {
        Preconditions.checkNotNull(messageId, "messageId cannot be null");
        Preconditions.checkNotNull(subject, "subject cannot be null");
        Preconditions.checkNotNull(directionCode, "directionCode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MessageId", "Edm.String", Checks.checkIsAscii(messageId))
            .put("Subject", "Edm.String", Checks.checkIsAscii(subject))
            .put("DirectionCode", "Edm.Int32", directionCode)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<CheckPromoteEmailResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CheckPromoteEmail"), CheckPromoteEmailResponse.class, _parameters);
    }

    @Function(name = "ExportFieldTranslation")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ExportFieldTranslationResponse> exportFieldTranslation() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ExportFieldTranslationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportFieldTranslation"), ExportFieldTranslationResponse.class, _parameters);
    }

    @Function(name = "FetchXmlToQueryExpression")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<FetchXmlToQueryExpressionResponse> fetchXmlToQueryExpression(String fetchXml) {
        Preconditions.checkNotNull(fetchXml, "fetchXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FetchXml", "Edm.String", Checks.checkIsAscii(fetchXml))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<FetchXmlToQueryExpressionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FetchXmlToQueryExpression"), FetchXmlToQueryExpressionResponse.class, _parameters);
    }

    @Function(name = "FormatAddress")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<FormatAddressResponse> formatAddress(String line1, String city, String stateOrProvince, String postalCode, String country) {
        Preconditions.checkNotNull(line1, "line1 cannot be null");
        Preconditions.checkNotNull(city, "city cannot be null");
        Preconditions.checkNotNull(stateOrProvince, "stateOrProvince cannot be null");
        Preconditions.checkNotNull(postalCode, "postalCode cannot be null");
        Preconditions.checkNotNull(country, "country cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Line1", "Edm.String", Checks.checkIsAscii(line1))
            .put("City", "Edm.String", Checks.checkIsAscii(city))
            .put("StateOrProvince", "Edm.String", Checks.checkIsAscii(stateOrProvince))
            .put("PostalCode", "Edm.String", Checks.checkIsAscii(postalCode))
            .put("Country", "Edm.String", Checks.checkIsAscii(country))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<FormatAddressResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.FormatAddress"), FormatAddressResponse.class, _parameters);
    }

    @Function(name = "GetFileSasUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetFileSasUrlResponse> getFileSasUrl(Crmbaseentity target, String fileAttributeName) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(fileAttributeName, "fileAttributeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("FileAttributeName", "Edm.String", Checks.checkIsAscii(fileAttributeName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetFileSasUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetFileSasUrl"), GetFileSasUrlResponse.class, _parameters);
    }

    @Function(name = "GetTimeZoneCodeByLocalizedName")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetTimeZoneCodeByLocalizedNameResponse> getTimeZoneCodeByLocalizedName(String localizedStandardName, Integer localeId) {
        Preconditions.checkNotNull(localizedStandardName, "localizedStandardName cannot be null");
        Preconditions.checkNotNull(localeId, "localeId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("LocalizedStandardName", "Edm.String", Checks.checkIsAscii(localizedStandardName))
            .put("LocaleId", "Edm.Int32", localeId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetTimeZoneCodeByLocalizedNameResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetTimeZoneCodeByLocalizedName"), GetTimeZoneCodeByLocalizedNameResponse.class, _parameters);
    }

    @Function(name = "GetValidManyToMany")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidManyToManyResponse> getValidManyToMany() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidManyToManyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidManyToMany"), GetValidManyToManyResponse.class, _parameters);
    }

    @Function(name = "GetValidReferencedEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencedEntitiesResponse> getValidReferencedEntities(String referencingEntityName) {
        Preconditions.checkNotNull(referencingEntityName, "referencingEntityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReferencingEntityName", "Edm.String", Checks.checkIsAscii(referencingEntityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencedEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidReferencedEntities"), GetValidReferencedEntitiesResponse.class, _parameters);
    }

    @Function(name = "GetValidReferencingEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencingEntitiesResponse> getValidReferencingEntities(String referencedEntityName) {
        Preconditions.checkNotNull(referencedEntityName, "referencedEntityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReferencedEntityName", "Edm.String", Checks.checkIsAscii(referencedEntityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetValidReferencingEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetValidReferencingEntities"), GetValidReferencingEntitiesResponse.class, _parameters);
    }

    @Function(name = "IncrementKnowledgeArticleViewCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> incrementKnowledgeArticleViewCount(Crmbaseentity source, OffsetDateTime viewDate, Integer location, Integer count) {
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(viewDate, "viewDate cannot be null");
        Preconditions.checkNotNull(location, "location cannot be null");
        Preconditions.checkNotNull(count, "count cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Source", "Microsoft.Dynamics.CRM.crmbaseentity", source)
            .put("ViewDate", "Edm.DateTimeOffset", viewDate)
            .put("Location", "Edm.Int32", location)
            .put("Count", "Edm.Int32", count)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IncrementKnowledgeArticleViewCount"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "InitializeFrom")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity> initializeFrom(Crmbaseentity entityMoniker, String targetEntityName, TargetFieldType targetFieldType, Boolean retrieveConsumableRecord) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(targetEntityName, "targetEntityName cannot be null");
        Preconditions.checkNotNull(targetFieldType, "targetFieldType cannot be null");
        Preconditions.checkNotNull(retrieveConsumableRecord, "retrieveConsumableRecord cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("TargetEntityName", "Edm.String", Checks.checkIsAscii(targetEntityName))
            .put("TargetFieldType", "Microsoft.Dynamics.CRM.TargetFieldType", targetFieldType)
            .put("RetrieveConsumableRecord", "Edm.Boolean", retrieveConsumableRecord)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InitializeFrom"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "IsComponentCustomizable")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsComponentCustomizableResponse> isComponentCustomizable(String componentId, Integer componentType) {
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ComponentId", "Edm.Guid", componentId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsComponentCustomizableResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsComponentCustomizable"), IsComponentCustomizableResponse.class, _parameters);
    }

    @Function(name = "IsDataEncryptionActive")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsDataEncryptionActiveResponse> isDataEncryptionActive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsDataEncryptionActiveResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsDataEncryptionActive"), IsDataEncryptionActiveResponse.class, _parameters);
    }

    @Function(name = "IsValidStateTransition")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<IsValidStateTransitionResponse> isValidStateTransition(Crmbaseentity entity, String newState, Integer newStatus) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Preconditions.checkNotNull(newState, "newState cannot be null");
        Preconditions.checkNotNull(newStatus, "newStatus cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.crmbaseentity", entity)
            .put("NewState", "Edm.String", Checks.checkIsAscii(newState))
            .put("NewStatus", "Edm.Int32", newStatus)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<IsValidStateTransitionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.IsValidStateTransition"), IsValidStateTransitionResponse.class, _parameters);
    }

    @Function(name = "LocalTimeFromUtcTime")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<LocalTimeFromUtcTimeResponse> localTimeFromUtcTime(Integer timeZoneCode, OffsetDateTime utcTime) {
        Preconditions.checkNotNull(timeZoneCode, "timeZoneCode cannot be null");
        Preconditions.checkNotNull(utcTime, "utcTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TimeZoneCode", "Edm.Int32", timeZoneCode)
            .put("UtcTime", "Edm.DateTimeOffset", utcTime)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<LocalTimeFromUtcTimeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LocalTimeFromUtcTime"), LocalTimeFromUtcTimeResponse.class, _parameters);
    }

    @Function(name = "QuerySchedule")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<QueryScheduleResponse> querySchedule(String resourceId, OffsetDateTime start, OffsetDateTime end, List<TimeCode> timeCodes) {
        Preconditions.checkNotNull(resourceId, "resourceId cannot be null");
        Preconditions.checkNotNull(start, "start cannot be null");
        Preconditions.checkNotNull(end, "end cannot be null");
        Preconditions.checkNotNull(timeCodes, "timeCodes cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ResourceId", "Edm.Guid", resourceId)
            .put("Start", "Edm.DateTimeOffset", start)
            .put("End", "Edm.DateTimeOffset", end)
            .put("TimeCodes", "Collection(Microsoft.Dynamics.CRM.TimeCode)", timeCodes)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<QueryScheduleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QuerySchedule"), QueryScheduleResponse.class, _parameters);
    }

    @Function(name = "RemoveActiveCustomizations")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RemoveActiveCustomizationsResponse> removeActiveCustomizations(String solutionComponentName, String componentId) {
        Preconditions.checkNotNull(solutionComponentName, "solutionComponentName cannot be null");
        Preconditions.checkNotNull(componentId, "componentId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionComponentName", "Edm.String", Checks.checkIsAscii(solutionComponentName))
            .put("ComponentId", "Edm.Guid", componentId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RemoveActiveCustomizationsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveActiveCustomizations"), RemoveActiveCustomizationsResponse.class, _parameters);
    }

    @Function(name = "RetrieveActivePath")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Processstage> retrieveActivePath(String processInstanceId) {
        Preconditions.checkNotNull(processInstanceId, "processInstanceId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProcessInstanceId", "Edm.Guid", processInstanceId)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveActivePath"), Processstage.class, _parameters);
    }

    @Function(name = "RetrieveAllEntities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAllEntitiesResponse> retrieveAllEntities(EntityFilters entityFilters, Boolean retrieveAsIfPublished) {
        Preconditions.checkNotNull(entityFilters, "entityFilters cannot be null");
        Preconditions.checkNotNull(retrieveAsIfPublished, "retrieveAsIfPublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityFilters", "Microsoft.Dynamics.CRM.EntityFilters", entityFilters)
            .put("RetrieveAsIfPublished", "Edm.Boolean", retrieveAsIfPublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAllEntitiesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAllEntities"), RetrieveAllEntitiesResponse.class, _parameters);
    }

    @Function(name = "RetrieveAnalyticsStoreDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAnalyticsStoreDetailsResponse> retrieveAnalyticsStoreDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAnalyticsStoreDetailsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAnalyticsStoreDetails"), RetrieveAnalyticsStoreDetailsResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveAppComponents(String appModuleId) {
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppComponents"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveApplicationRibbon")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveApplicationRibbonResponse> retrieveApplicationRibbon() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveApplicationRibbonResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveApplicationRibbon"), RetrieveApplicationRibbonResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppSetting")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingResponse> retrieveAppSetting(String appUniqueName, String settingName) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(settingName, "settingName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("SettingName", "Edm.String", Checks.checkIsAscii(settingName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppSetting"), RetrieveAppSettingResponse.class, _parameters);
    }

    @Function(name = "RetrieveAppSettingList")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingListResponse> retrieveAppSettingList(String appUniqueName, Boolean includeInactiveSettings) {
        Preconditions.checkNotNull(appUniqueName, "appUniqueName cannot be null");
        Preconditions.checkNotNull(includeInactiveSettings, "includeInactiveSettings cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppUniqueName", "Edm.String", Checks.checkIsAscii(appUniqueName))
            .put("IncludeInactiveSettings", "Edm.Boolean", includeInactiveSettings)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAppSettingListResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAppSettingList"), RetrieveAppSettingListResponse.class, _parameters);
    }

    @Function(name = "RetrieveAttributeChangeHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAttributeChangeHistoryResponse> retrieveAttributeChangeHistory(Crmbaseentity target, String attributeLogicalName, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(attributeLogicalName, "attributeLogicalName cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("AttributeLogicalName", "Edm.String", Checks.checkIsAscii(attributeLogicalName))
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAttributeChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAttributeChangeHistory"), RetrieveAttributeChangeHistoryResponse.class, _parameters);
    }

    @Function(name = "RetrieveAuditPartitionList")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditPartitionListResponse> retrieveAuditPartitionList() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditPartitionListResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAuditPartitionList"), RetrieveAuditPartitionListResponse.class, _parameters);
    }

    @Function(name = "RetrieveAvailableLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAvailableLanguagesResponse> retrieveAvailableLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAvailableLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAvailableLanguages"), RetrieveAvailableLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveChannelAccessProfilePrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveChannelAccessProfilePrivilegesResponse> retrieveChannelAccessProfilePrivileges(String channelAccessProfileId) {
        Preconditions.checkNotNull(channelAccessProfileId, "channelAccessProfileId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ChannelAccessProfileId", "Edm.Guid", channelAccessProfileId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveChannelAccessProfilePrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveChannelAccessProfilePrivileges"), RetrieveChannelAccessProfilePrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrieveCurrentOrganization")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveCurrentOrganizationResponse> retrieveCurrentOrganization(EndpointAccessType accessType) {
        Preconditions.checkNotNull(accessType, "accessType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AccessType", "Microsoft.Dynamics.CRM.EndpointAccessType", accessType)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveCurrentOrganizationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveCurrentOrganization"), RetrieveCurrentOrganizationResponse.class, _parameters);
    }

    @Function(name = "RetrieveDataEncryptionKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDataEncryptionKeyResponse> retrieveDataEncryptionKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDataEncryptionKeyResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDataEncryptionKey"), RetrieveDataEncryptionKeyResponse.class, _parameters);
    }

    @Function(name = "RetrieveDependenciesForDelete")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependenciesForDelete(String objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependenciesForDelete"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDependenciesForUninstall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependenciesForUninstall(String solutionUniqueName) {
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependenciesForUninstall"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDependentComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Dependency> retrieveDependentComponents(String objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDependentComponents"), Dependency.class, _parameters);
    }

    @Function(name = "RetrieveDeploymentLicenseType")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeploymentLicenseTypeResponse> retrieveDeploymentLicenseType() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeploymentLicenseTypeResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDeploymentLicenseType"), RetrieveDeploymentLicenseTypeResponse.class, _parameters);
    }

    @Function(name = "RetrieveDeprovisionedLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeprovisionedLanguagesResponse> retrieveDeprovisionedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveDeprovisionedLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDeprovisionedLanguages"), RetrieveDeprovisionedLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveDuplicates")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveDuplicates(Crmbaseentity businessEntity, String matchingEntityName, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(businessEntity, "businessEntity cannot be null");
        Preconditions.checkNotNull(matchingEntityName, "matchingEntityName cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("BusinessEntity", "Microsoft.Dynamics.CRM.crmbaseentity", businessEntity)
            .put("MatchingEntityName", "Edm.String", Checks.checkIsAscii(matchingEntityName))
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveDuplicates"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveEntity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityResponse> retrieveEntity(EntityFilters entityFilters, String logicalName, String metadataId, Boolean retrieveAsIfPublished) {
        Preconditions.checkNotNull(entityFilters, "entityFilters cannot be null");
        Preconditions.checkNotNull(logicalName, "logicalName cannot be null");
        Preconditions.checkNotNull(metadataId, "metadataId cannot be null");
        Preconditions.checkNotNull(retrieveAsIfPublished, "retrieveAsIfPublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityFilters", "Microsoft.Dynamics.CRM.EntityFilters", entityFilters)
            .put("LogicalName", "Edm.String", Checks.checkIsAscii(logicalName))
            .put("MetadataId", "Edm.Guid", metadataId)
            .put("RetrieveAsIfPublished", "Edm.Boolean", retrieveAsIfPublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveEntity"), RetrieveEntityResponse.class, _parameters);
    }

    @Function(name = "RetrieveEntityRibbon")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityRibbonResponse> retrieveEntityRibbon(String entityName, RibbonLocationFilters ribbonLocationFilter) {
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Preconditions.checkNotNull(ribbonLocationFilter, "ribbonLocationFilter cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .put("RibbonLocationFilter", "Microsoft.Dynamics.CRM.RibbonLocationFilters", ribbonLocationFilter)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveEntityRibbonResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveEntityRibbon"), RetrieveEntityRibbonResponse.class, _parameters);
    }

    @Function(name = "RetrieveExchangeAppointments")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveExchangeAppointments(OffsetDateTime startDate, OffsetDateTime endDate) {
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveExchangeAppointments"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveExchangeRate")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveExchangeRateResponse> retrieveExchangeRate(String transactionCurrencyId) {
        Preconditions.checkNotNull(transactionCurrencyId, "transactionCurrencyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TransactionCurrencyId", "Edm.Guid", transactionCurrencyId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveExchangeRateResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveExchangeRate"), RetrieveExchangeRateResponse.class, _parameters);
    }

    @Function(name = "RetrieveFormattedImportJobResults")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveFormattedImportJobResultsResponse> retrieveFormattedImportJobResults(String importJobId) {
        Preconditions.checkNotNull(importJobId, "importJobId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportJobId", "Edm.Guid", importJobId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveFormattedImportJobResultsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveFormattedImportJobResults"), RetrieveFormattedImportJobResultsResponse.class, _parameters);
    }

    @Function(name = "RetrieveInstalledLanguagePacks")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePacksResponse> retrieveInstalledLanguagePacks() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePacksResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePacks"), RetrieveInstalledLanguagePacksResponse.class, _parameters);
    }

    @Function(name = "RetrieveInstalledLanguagePackVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePackVersionResponse> retrieveInstalledLanguagePackVersion(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveInstalledLanguagePackVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePackVersion"), RetrieveInstalledLanguagePackVersionResponse.class, _parameters);
    }

    @Function(name = "RetrieveLicenseInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveLicenseInfoResponse> retrieveLicenseInfo(Integer accessMode) {
        Preconditions.checkNotNull(accessMode, "accessMode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AccessMode", "Edm.Int32", accessMode)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveLicenseInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveLicenseInfo"), RetrieveLicenseInfoResponse.class, _parameters);
    }

    @Function(name = "RetrieveLocLabels")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveLocLabelsResponse> retrieveLocLabels(Crmbaseentity entityMoniker, String attributeName, Boolean includeUnpublished) {
        Preconditions.checkNotNull(entityMoniker, "entityMoniker cannot be null");
        Preconditions.checkNotNull(attributeName, "attributeName cannot be null");
        Preconditions.checkNotNull(includeUnpublished, "includeUnpublished cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityMoniker", "Microsoft.Dynamics.CRM.crmbaseentity", entityMoniker)
            .put("AttributeName", "Edm.String", Checks.checkIsAscii(attributeName))
            .put("IncludeUnpublished", "Edm.Boolean", includeUnpublished)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveLocLabelsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveLocLabels"), RetrieveLocLabelsResponse.class, _parameters);
    }

    @Function(name = "RetrieveMailboxTrackingFolders")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMailboxTrackingFoldersResponse> retrieveMailboxTrackingFolders(String mailboxId) {
        Preconditions.checkNotNull(mailboxId, "mailboxId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("MailboxId", "Edm.String", Checks.checkIsAscii(mailboxId))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMailboxTrackingFoldersResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMailboxTrackingFolders"), RetrieveMailboxTrackingFoldersResponse.class, _parameters);
    }

    @Function(name = "RetrieveMetadataChanges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMetadataChangesResponse> retrieveMetadataChanges(EntityQueryExpression query, DeletedMetadataFilters deletedMetadataFilters, String clientVersionStamp, String appModuleId, Boolean retrieveAllSettings) {
        Preconditions.checkNotNull(query, "query cannot be null");
        Preconditions.checkNotNull(deletedMetadataFilters, "deletedMetadataFilters cannot be null");
        Preconditions.checkNotNull(clientVersionStamp, "clientVersionStamp cannot be null");
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Preconditions.checkNotNull(retrieveAllSettings, "retrieveAllSettings cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Query", "Microsoft.Dynamics.CRM.EntityQueryExpression", query)
            .put("DeletedMetadataFilters", "Microsoft.Dynamics.CRM.DeletedMetadataFilters", deletedMetadataFilters)
            .put("ClientVersionStamp", "Edm.String", Checks.checkIsAscii(clientVersionStamp))
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .put("RetrieveAllSettings", "Edm.Boolean", retrieveAllSettings)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMetadataChangesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMetadataChanges"), RetrieveMetadataChangesResponse.class, _parameters);
    }

    @Function(name = "RetrieveMissingComponents")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveMissingComponentsResponse> retrieveMissingComponents(byte[] customizationFile) {
        Preconditions.checkNotNull(customizationFile, "customizationFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("CustomizationFile", "Edm.Binary", customizationFile)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveMissingComponentsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMissingComponents"), RetrieveMissingComponentsResponse.class, _parameters);
    }

    @Function(name = "RetrieveMissingDependencies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveMissingDependencies(String solutionUniqueName) {
        Preconditions.checkNotNull(solutionUniqueName, "solutionUniqueName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SolutionUniqueName", "Edm.String", Checks.checkIsAscii(solutionUniqueName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveMissingDependencies"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveOrganizationInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationInfoResponse> retrieveOrganizationInfo() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveOrganizationInfo"), RetrieveOrganizationInfoResponse.class, _parameters);
    }

    @Function(name = "RetrieveOrganizationResources")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationResourcesResponse> retrieveOrganizationResources() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveOrganizationResourcesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveOrganizationResources"), RetrieveOrganizationResourcesResponse.class, _parameters);
    }

    @Function(name = "RetrieveParsedDataImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveParsedDataImportFileResponse> retrieveParsedDataImportFile(String importFileId, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(importFileId, "importFileId cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ImportFileId", "Edm.Guid", importFileId)
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveParsedDataImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveParsedDataImportFile"), RetrieveParsedDataImportFileResponse.class, _parameters);
    }

    @Function(name = "RetrieveProcessInstances")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveProcessInstances(String entityId, String entityLogicalName) {
        Preconditions.checkNotNull(entityId, "entityId cannot be null");
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityId", "Edm.Guid", entityId)
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProcessInstances"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveProvisionedLanguagePackVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagePackVersionResponse> retrieveProvisionedLanguagePackVersion(Integer language) {
        Preconditions.checkNotNull(language, "language cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Language", "Edm.Int32", language)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagePackVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProvisionedLanguagePackVersion"), RetrieveProvisionedLanguagePackVersionResponse.class, _parameters);
    }

    @Function(name = "RetrieveProvisionedLanguages")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagesResponse> retrieveProvisionedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveProvisionedLanguagesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveProvisionedLanguages"), RetrieveProvisionedLanguagesResponse.class, _parameters);
    }

    @Function(name = "RetrieveRecordChangeHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveRecordChangeHistoryResponse> retrieveRecordChangeHistory(Crmbaseentity target, PagingInfo pagingInfo) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(pagingInfo, "pagingInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("PagingInfo", "Microsoft.Dynamics.CRM.PagingInfo", pagingInfo)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveRecordChangeHistoryResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRecordChangeHistory"), RetrieveRecordChangeHistoryResponse.class, _parameters);
    }

    @Function(name = "RetrieveRequiredComponents")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> retrieveRequiredComponents(String objectId, Integer componentType) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(componentType, "componentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("ComponentType", "Edm.Int32", componentType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRequiredComponents"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "RetrieveRolePrivilegesRole")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveRolePrivilegesRoleResponse> retrieveRolePrivilegesRole(String roleId) {
        Preconditions.checkNotNull(roleId, "roleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoleId", "Edm.Guid", roleId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveRolePrivilegesRoleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRolePrivilegesRole"), RetrieveRolePrivilegesRoleResponse.class, _parameters);
    }

    @Function(name = "RetrieveSharedPrincipalsAndAccess")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveSharedPrincipalsAndAccessResponse> retrieveSharedPrincipalsAndAccess(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveSharedPrincipalsAndAccessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveSharedPrincipalsAndAccess"), RetrieveSharedPrincipalsAndAccessResponse.class, _parameters);
    }

    @Function(name = "RetrieveTimestamp")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTimestampResponse> retrieveTimestamp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTimestampResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTimestamp"), RetrieveTimestampResponse.class, _parameters);
    }

    @Function(name = "RetrieveTotalRecordCount")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTotalRecordCountResponse> retrieveTotalRecordCount(List<String> entityNames) {
        Preconditions.checkNotNull(entityNames, "entityNames cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityNames", "Collection(Edm.String)", Checks.checkIsAscii(entityNames))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTotalRecordCountResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTotalRecordCount"), RetrieveTotalRecordCountResponse.class, _parameters);
    }

    @Function(name = "RetrieveVersion")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveVersionResponse> retrieveVersion() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveVersionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveVersion"), RetrieveVersionResponse.class, _parameters);
    }

    @Function(name = "Rollup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> rollup(Crmbaseentity target, QueryBase query, RollupType rollupType) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(query, "query cannot be null");
        Preconditions.checkNotNull(rollupType, "rollupType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("Query", "Microsoft.Dynamics.CRM.QueryBase", query)
            .put("RollupType", "Microsoft.Dynamics.CRM.RollupType", rollupType)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Rollup"), Crmbaseentity.class, _parameters);
    }

    @Function(name = "Search")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<SearchResponse> search(microsoft.dynamics.crm.complex.AppointmentRequest appointmentRequest) {
        Preconditions.checkNotNull(appointmentRequest, "appointmentRequest cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppointmentRequest", "Microsoft.Dynamics.CRM.AppointmentRequest", appointmentRequest)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<SearchResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Search"), SearchResponse.class, _parameters);
    }

    @Function(name = "ValidateApp")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateAppResponse> validateApp(String appModuleId) {
        Preconditions.checkNotNull(appModuleId, "appModuleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("AppModuleId", "Edm.Guid", appModuleId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateAppResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateApp"), ValidateAppResponse.class, _parameters);
    }

    @Function(name = "ValidateFetchXmlExpression")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateFetchXmlExpressionResponse> validateFetchXmlExpression(String fetchXml) {
        Preconditions.checkNotNull(fetchXml, "fetchXml cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("FetchXml", "Edm.String", Checks.checkIsAscii(fetchXml))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateFetchXmlExpressionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateFetchXmlExpression"), ValidateFetchXmlExpressionResponse.class, _parameters);
    }

    @Function(name = "ValidateRecurrenceRule")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ValidateRecurrenceRuleResponse> validateRecurrenceRule(Recurrencerule target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurrencerule", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ValidateRecurrenceRuleResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ValidateRecurrenceRule"), ValidateRecurrenceRuleResponse.class, _parameters);
    }

    @Function(name = "WhoAmI")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WhoAmIResponse> whoAmI() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WhoAmIResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.WhoAmI"), WhoAmIResponse.class, _parameters);
    }

    @Function(name = "In")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> in(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.In"), Boolean.class, _parameters);
    }

    @Function(name = "NotIn")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notIn(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotIn"), Boolean.class, _parameters);
    }

    @Function(name = "Between")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> between(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Between"), Boolean.class, _parameters);
    }

    @Function(name = "NotBetween")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notBetween(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotBetween"), Boolean.class, _parameters);
    }

    @Function(name = "Yesterday")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> yesterday(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Yesterday"), Boolean.class, _parameters);
    }

    @Function(name = "Today")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> today(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Today"), Boolean.class, _parameters);
    }

    @Function(name = "Tomorrow")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> tomorrow(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Tomorrow"), Boolean.class, _parameters);
    }

    @Function(name = "Last7Days")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> last7Days(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Last7Days"), Boolean.class, _parameters);
    }

    @Function(name = "Next7Days")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> next7Days(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Next7Days"), Boolean.class, _parameters);
    }

    @Function(name = "LastWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastWeek"), Boolean.class, _parameters);
    }

    @Function(name = "ThisWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisWeek"), Boolean.class, _parameters);
    }

    @Function(name = "NextWeek")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextWeek(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextWeek"), Boolean.class, _parameters);
    }

    @Function(name = "LastMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastMonth"), Boolean.class, _parameters);
    }

    @Function(name = "ThisMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisMonth"), Boolean.class, _parameters);
    }

    @Function(name = "NextMonth")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextMonth(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextMonth"), Boolean.class, _parameters);
    }

    @Function(name = "On")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> on(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.On"), Boolean.class, _parameters);
    }

    @Function(name = "OnOrBefore")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> onOrBefore(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OnOrBefore"), Boolean.class, _parameters);
    }

    @Function(name = "OnOrAfter")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> onOrAfter(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OnOrAfter"), Boolean.class, _parameters);
    }

    @Function(name = "LastYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastYear"), Boolean.class, _parameters);
    }

    @Function(name = "ThisYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisYear"), Boolean.class, _parameters);
    }

    @Function(name = "NextYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextYear"), Boolean.class, _parameters);
    }

    @Function(name = "LastXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXHours"), Boolean.class, _parameters);
    }

    @Function(name = "NextXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXHours"), Boolean.class, _parameters);
    }

    @Function(name = "LastXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXDays"), Boolean.class, _parameters);
    }

    @Function(name = "NextXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXDays"), Boolean.class, _parameters);
    }

    @Function(name = "LastXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "NextXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "LastXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "NextXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "LastXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXYears"), Boolean.class, _parameters);
    }

    @Function(name = "NextXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXYears"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserId"), Boolean.class, _parameters);
    }

    @Function(name = "NotEqualUserId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notEqualUserId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotEqualUserId"), Boolean.class, _parameters);
    }

    @Function(name = "EqualBusinessId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalBusinessId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualBusinessId"), Boolean.class, _parameters);
    }

    @Function(name = "NotEqualBusinessId")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notEqualBusinessId(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotEqualBusinessId"), Boolean.class, _parameters);
    }

    @Function(name = "Contains")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> contains(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Contains"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserLanguage")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserLanguage(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserLanguage"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXMonths")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXMonths(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXMonths"), Boolean.class, _parameters);
    }

    @Function(name = "ThisFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "ThisFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> thisFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ThisFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "NextFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "NextFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "LastFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastFiscalYear(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "LastFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastFiscalPeriod(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "LastXFiscalYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXFiscalYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXFiscalYears"), Boolean.class, _parameters);
    }

    @Function(name = "LastXFiscalPeriods")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> lastXFiscalPeriods(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.LastXFiscalPeriods"), Boolean.class, _parameters);
    }

    @Function(name = "NextXFiscalYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXFiscalYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXFiscalYears"), Boolean.class, _parameters);
    }

    @Function(name = "NextXFiscalPeriods")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> nextXFiscalPeriods(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NextXFiscalPeriods"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalYear(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalYear"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalPeriod")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalPeriod(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalPeriod"), Boolean.class, _parameters);
    }

    @Function(name = "InFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "InOrBeforeFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inOrBeforeFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InOrBeforeFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "InOrAfterFiscalPeriodAndYear")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> inOrAfterFiscalPeriodAndYear(String propertyName, Long propertyValue1, Long propertyValue2) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue1, "propertyValue1 cannot be null");
        Preconditions.checkNotNull(propertyValue2, "propertyValue2 cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue1", "Edm.Int64", propertyValue1)
            .put("PropertyValue2", "Edm.Int64", propertyValue2)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InOrAfterFiscalPeriodAndYear"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserTeams"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserTeams"), Boolean.class, _parameters);
    }

    @Function(name = "Under")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> under(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Under"), Boolean.class, _parameters);
    }

    @Function(name = "NotUnder")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> notUnder(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.NotUnder"), Boolean.class, _parameters);
    }

    @Function(name = "UnderOrEqual")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> underOrEqual(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnderOrEqual"), Boolean.class, _parameters);
    }

    @Function(name = "Above")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> above(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Above"), Boolean.class, _parameters);
    }

    @Function(name = "AboveOrEqual")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> aboveOrEqual(String propertyName, String propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.String", Checks.checkIsAscii(propertyValue))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AboveOrEqual"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserHierarchy")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserHierarchy(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserHierarchy"), Boolean.class, _parameters);
    }

    @Function(name = "EqualUserOrUserHierarchyAndTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> equalUserOrUserHierarchyAndTeams(String propertyName) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.EqualUserOrUserHierarchyAndTeams"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXYears")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXYears(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXYears"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXWeeks")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXWeeks(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXWeeks"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXDays")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXDays(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXDays"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXHours")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXHours(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXHours"), Boolean.class, _parameters);
    }

    @Function(name = "OlderThanXMinutes")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> olderThanXMinutes(String propertyName, Long propertyValue) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValue, "propertyValue cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValue", "Edm.Int64", propertyValue)
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.OlderThanXMinutes"), Boolean.class, _parameters);
    }

    @Function(name = "ContainValues")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> containValues(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ContainValues"), Boolean.class, _parameters);
    }

    @Function(name = "DoesNotContainValues")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> doesNotContainValues(String propertyName, List<String> propertyValues) {
        Preconditions.checkNotNull(propertyName, "propertyName cannot be null");
        Preconditions.checkNotNull(propertyValues, "propertyValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PropertyName", "Edm.String", Checks.checkIsAscii(propertyName))
            .put("PropertyValues", "Collection(Edm.String)", Checks.checkIsAscii(propertyValues))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.DoesNotContainValues"), Boolean.class, _parameters);
    }

}
