package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Metadata", 
    "SyncToken", 
    "IsFinalPage", 
    "MetadataVersion", 
    "ProfileVersion"})
@JsonInclude(Include.NON_NULL)
public class SyncSubscriptionMetadataResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Metadata")
    protected List<SubscriptionEntityMetadata> metadata;

    @JsonProperty("Metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("SyncToken")
    protected String syncToken;

    @JsonProperty("IsFinalPage")
    protected Boolean isFinalPage;

    @JsonProperty("MetadataVersion")
    protected String metadataVersion;

    @JsonProperty("ProfileVersion")
    protected String profileVersion;

    protected SyncSubscriptionMetadataResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse";
    }

    @Property(name="Metadata")
    @JsonIgnore
    public CollectionPage<SubscriptionEntityMetadata> getMetadata() {
        return new CollectionPage<SubscriptionEntityMetadata>(contextPath, SubscriptionEntityMetadata.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Metadata")
    @JsonIgnore
    public CollectionPage<SubscriptionEntityMetadata> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<SubscriptionEntityMetadata>(contextPath, SubscriptionEntityMetadata.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), options);
    }

    @Property(name="SyncToken")
    @JsonIgnore
    public Optional<String> getSyncToken() {
        return Optional.ofNullable(syncToken);
    }

    public SyncSubscriptionMetadataResponse withSyncToken(String syncToken) {
        Checks.checkIsAscii(syncToken);
        SyncSubscriptionMetadataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.syncToken = syncToken;
        return _x;
    }

    @Property(name="IsFinalPage")
    @JsonIgnore
    public Optional<Boolean> getIsFinalPage() {
        return Optional.ofNullable(isFinalPage);
    }

    public SyncSubscriptionMetadataResponse withIsFinalPage(Boolean isFinalPage) {
        SyncSubscriptionMetadataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.isFinalPage = isFinalPage;
        return _x;
    }

    @Property(name="MetadataVersion")
    @JsonIgnore
    public Optional<String> getMetadataVersion() {
        return Optional.ofNullable(metadataVersion);
    }

    public SyncSubscriptionMetadataResponse withMetadataVersion(String metadataVersion) {
        Checks.checkIsAscii(metadataVersion);
        SyncSubscriptionMetadataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.metadataVersion = metadataVersion;
        return _x;
    }

    @Property(name="ProfileVersion")
    @JsonIgnore
    public Optional<String> getProfileVersion() {
        return Optional.ofNullable(profileVersion);
    }

    public SyncSubscriptionMetadataResponse withProfileVersion(String profileVersion) {
        Checks.checkIsAscii(profileVersion);
        SyncSubscriptionMetadataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.profileVersion = profileVersion;
        return _x;
    }

    public SyncSubscriptionMetadataResponse withUnmappedField(String name, String value) {
        SyncSubscriptionMetadataResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SubscriptionEntityMetadata> metadata;
        private String metadataNextLink;
        private String syncToken;
        private Boolean isFinalPage;
        private String metadataVersion;
        private String profileVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadata(List<SubscriptionEntityMetadata> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("Metadata");
            return this;
        }

        public Builder metadata(SubscriptionEntityMetadata... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("Metadata");
            return this;
        }

        public Builder syncToken(String syncToken) {
            this.syncToken = syncToken;
            this.changedFields = changedFields.add("SyncToken");
            return this;
        }

        public Builder isFinalPage(Boolean isFinalPage) {
            this.isFinalPage = isFinalPage;
            this.changedFields = changedFields.add("IsFinalPage");
            return this;
        }

        public Builder metadataVersion(String metadataVersion) {
            this.metadataVersion = metadataVersion;
            this.changedFields = changedFields.add("MetadataVersion");
            return this;
        }

        public Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            this.changedFields = changedFields.add("ProfileVersion");
            return this;
        }

        public SyncSubscriptionMetadataResponse build() {
            SyncSubscriptionMetadataResponse _x = new SyncSubscriptionMetadataResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse";
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.syncToken = syncToken;
            _x.isFinalPage = isFinalPage;
            _x.metadataVersion = metadataVersion;
            _x.profileVersion = profileVersion;
            return _x;
        }
    }

    private SyncSubscriptionMetadataResponse _copy() {
        SyncSubscriptionMetadataResponse _x = new SyncSubscriptionMetadataResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadata = metadata;
        _x.syncToken = syncToken;
        _x.isFinalPage = isFinalPage;
        _x.metadataVersion = metadataVersion;
        _x.profileVersion = profileVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SyncSubscriptionMetadataResponse[");
        b.append("Metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("SyncToken=");
        b.append(this.syncToken);
        b.append(", ");
        b.append("IsFinalPage=");
        b.append(this.isFinalPage);
        b.append(", ");
        b.append("MetadataVersion=");
        b.append(this.metadataVersion);
        b.append(", ");
        b.append("ProfileVersion=");
        b.append(this.profileVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
