package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "PrincipalAccesses"})
@JsonInclude(Include.NON_NULL)
public class RetrieveSharedPrincipalsAndAccessResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PrincipalAccesses")
    protected List<PrincipalAccess> principalAccesses;

    @JsonProperty("PrincipalAccesses@nextLink")
    protected String principalAccessesNextLink;

    protected RetrieveSharedPrincipalsAndAccessResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveSharedPrincipalsAndAccessResponse";
    }

    @Property(name="PrincipalAccesses")
    @JsonIgnore
    public CollectionPage<PrincipalAccess> getPrincipalAccesses() {
        return new CollectionPage<PrincipalAccess>(contextPath, PrincipalAccess.class, this.principalAccesses, Optional.ofNullable(principalAccessesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="PrincipalAccesses")
    @JsonIgnore
    public CollectionPage<PrincipalAccess> getPrincipalAccesses(HttpRequestOptions options) {
        return new CollectionPage<PrincipalAccess>(contextPath, PrincipalAccess.class, this.principalAccesses, Optional.ofNullable(principalAccessesNextLink), Collections.emptyList(), options);
    }

    public RetrieveSharedPrincipalsAndAccessResponse withUnmappedField(String name, String value) {
        RetrieveSharedPrincipalsAndAccessResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<PrincipalAccess> principalAccesses;
        private String principalAccessesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder principalAccesses(List<PrincipalAccess> principalAccesses) {
            this.principalAccesses = principalAccesses;
            this.changedFields = changedFields.add("PrincipalAccesses");
            return this;
        }

        public Builder principalAccesses(PrincipalAccess... principalAccesses) {
            return principalAccesses(Arrays.asList(principalAccesses));
        }

        public Builder principalAccessesNextLink(String principalAccessesNextLink) {
            this.principalAccessesNextLink = principalAccessesNextLink;
            this.changedFields = changedFields.add("PrincipalAccesses");
            return this;
        }

        public RetrieveSharedPrincipalsAndAccessResponse build() {
            RetrieveSharedPrincipalsAndAccessResponse _x = new RetrieveSharedPrincipalsAndAccessResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveSharedPrincipalsAndAccessResponse";
            _x.principalAccesses = principalAccesses;
            _x.principalAccessesNextLink = principalAccessesNextLink;
            return _x;
        }
    }

    private RetrieveSharedPrincipalsAndAccessResponse _copy() {
        RetrieveSharedPrincipalsAndAccessResponse _x = new RetrieveSharedPrincipalsAndAccessResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.principalAccesses = principalAccesses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveSharedPrincipalsAndAccessResponse[");
        b.append("PrincipalAccesses=");
        b.append(this.principalAccesses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
