package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ObjectTypeCode", 
    "EntityIds"})
@JsonInclude(Include.NON_NULL)
public class ResetSyncStateInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ObjectTypeCode")
    protected Integer objectTypeCode;

    @JsonProperty("EntityIds")
    protected List<String> entityIds;

    @JsonProperty("EntityIds@nextLink")
    protected String entityIdsNextLink;

    protected ResetSyncStateInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ResetSyncStateInfo";
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(objectTypeCode);
    }

    public ResetSyncStateInfo withObjectTypeCode(Integer objectTypeCode) {
        ResetSyncStateInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ResetSyncStateInfo");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="EntityIds")
    @JsonIgnore
    public CollectionPage<String> getEntityIds() {
        return new CollectionPage<String>(contextPath, String.class, this.entityIds, Optional.ofNullable(entityIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityIds")
    @JsonIgnore
    public CollectionPage<String> getEntityIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.entityIds, Optional.ofNullable(entityIdsNextLink), Collections.emptyList(), options);
    }

    public ResetSyncStateInfo withUnmappedField(String name, String value) {
        ResetSyncStateInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer objectTypeCode;
        private List<String> entityIds;
        private String entityIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder entityIds(List<String> entityIds) {
            this.entityIds = entityIds;
            this.changedFields = changedFields.add("EntityIds");
            return this;
        }

        public Builder entityIds(String... entityIds) {
            return entityIds(Arrays.asList(entityIds));
        }

        public Builder entityIdsNextLink(String entityIdsNextLink) {
            this.entityIdsNextLink = entityIdsNextLink;
            this.changedFields = changedFields.add("EntityIds");
            return this;
        }

        public ResetSyncStateInfo build() {
            ResetSyncStateInfo _x = new ResetSyncStateInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ResetSyncStateInfo";
            _x.objectTypeCode = objectTypeCode;
            _x.entityIds = entityIds;
            _x.entityIdsNextLink = entityIdsNextLink;
            return _x;
        }
    }

    private ResetSyncStateInfo _copy() {
        ResetSyncStateInfo _x = new ResetSyncStateInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objectTypeCode = objectTypeCode;
        _x.entityIds = entityIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResetSyncStateInfo[");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("EntityIds=");
        b.append(this.entityIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
