package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityName", 
    "Attributes", 
    "Values", 
    "PageInfo", 
    "ColumnSet", 
    "Orders", 
    "TopCount"})
@JsonInclude(Include.NON_NULL)
public class QueryByAttribute extends QueryBase implements ODataType {

    @JsonProperty("EntityName")
    protected String entityName;

    @JsonProperty("Attributes")
    protected List<String> attributes;

    @JsonProperty("Attributes@nextLink")
    protected String attributesNextLink;

    @JsonProperty("Values")
    protected List<Object> values;

    @JsonProperty("Values@nextLink")
    protected String valuesNextLink;

    @JsonProperty("PageInfo")
    protected PagingInfo pageInfo;

    @JsonProperty("ColumnSet")
    protected ColumnSet columnSet;

    @JsonProperty("Orders")
    protected List<OrderExpression> orders;

    @JsonProperty("Orders@nextLink")
    protected String ordersNextLink;

    @JsonProperty("TopCount")
    protected Integer topCount;

    protected QueryByAttribute() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryByAttribute";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(entityName);
    }

    public QueryByAttribute withEntityName(String entityName) {
        Checks.checkIsAscii(entityName);
        QueryByAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes() {
        return new CollectionPage<String>(contextPath, String.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues() {
        return new CollectionPage<Object>(contextPath, Object.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues(HttpRequestOptions options) {
        return new CollectionPage<Object>(contextPath, Object.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    @Property(name="PageInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPageInfo() {
        return Optional.ofNullable(pageInfo);
    }

    public QueryByAttribute withPageInfo(PagingInfo pageInfo) {
        QueryByAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.pageInfo = pageInfo;
        return _x;
    }

    @Property(name="ColumnSet")
    @JsonIgnore
    public Optional<ColumnSet> getColumnSet() {
        return Optional.ofNullable(columnSet);
    }

    public QueryByAttribute withColumnSet(ColumnSet columnSet) {
        QueryByAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.columnSet = columnSet;
        return _x;
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders() {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders(HttpRequestOptions options) {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), Collections.emptyList(), options);
    }

    @Property(name="TopCount")
    @JsonIgnore
    public Optional<Integer> getTopCount() {
        return Optional.ofNullable(topCount);
    }

    public QueryByAttribute withTopCount(Integer topCount) {
        QueryByAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.topCount = topCount;
        return _x;
    }

    public QueryByAttribute withUnmappedField(String name, String value) {
        QueryByAttribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, java.lang.Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQueryByAttribute() {
        return new Builder();
    }

    public static final class Builder {
        private String entityName;
        private List<String> attributes;
        private String attributesNextLink;
        private List<Object> values;
        private String valuesNextLink;
        private PagingInfo pageInfo;
        private ColumnSet columnSet;
        private List<OrderExpression> orders;
        private String ordersNextLink;
        private Integer topCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = changedFields.add("EntityName");
            return this;
        }

        public Builder attributes(List<String> attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder attributes(String... attributes) {
            return attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder values(List<Object> values) {
            this.values = values;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder values(Object... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder pageInfo(PagingInfo pageInfo) {
            this.pageInfo = pageInfo;
            this.changedFields = changedFields.add("PageInfo");
            return this;
        }

        public Builder columnSet(ColumnSet columnSet) {
            this.columnSet = columnSet;
            this.changedFields = changedFields.add("ColumnSet");
            return this;
        }

        public Builder orders(List<OrderExpression> orders) {
            this.orders = orders;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public Builder orders(OrderExpression... orders) {
            return orders(Arrays.asList(orders));
        }

        public Builder ordersNextLink(String ordersNextLink) {
            this.ordersNextLink = ordersNextLink;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public Builder topCount(Integer topCount) {
            this.topCount = topCount;
            this.changedFields = changedFields.add("TopCount");
            return this;
        }

        public QueryByAttribute build() {
            QueryByAttribute _x = new QueryByAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryByAttribute";
            _x.entityName = entityName;
            _x.attributes = attributes;
            _x.attributesNextLink = attributesNextLink;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            _x.pageInfo = pageInfo;
            _x.columnSet = columnSet;
            _x.orders = orders;
            _x.ordersNextLink = ordersNextLink;
            _x.topCount = topCount;
            return _x;
        }
    }

    private QueryByAttribute _copy() {
        QueryByAttribute _x = new QueryByAttribute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityName = entityName;
        _x.attributes = attributes;
        _x.values = values;
        _x.pageInfo = pageInfo;
        _x.columnSet = columnSet;
        _x.orders = orders;
        _x.topCount = topCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryByAttribute[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append(", ");
        b.append("PageInfo=");
        b.append(this.pageInfo);
        b.append(", ");
        b.append("ColumnSet=");
        b.append(this.columnSet);
        b.append(", ");
        b.append("Orders=");
        b.append(this.orders);
        b.append(", ");
        b.append("TopCount=");
        b.append(this.topCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
