package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "LocalizedLabels", 
    "DefaultLabel"})
@JsonInclude(Include.NON_NULL)
public class LocalizedLabelDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LocalizedLabels")
    protected List<LocalizedLabelInfo> localizedLabels;

    @JsonProperty("LocalizedLabels@nextLink")
    protected String localizedLabelsNextLink;

    @JsonProperty("DefaultLabel")
    protected String defaultLabel;

    protected LocalizedLabelDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LocalizedLabelDetails";
    }

    @Property(name="LocalizedLabels")
    @JsonIgnore
    public CollectionPage<LocalizedLabelInfo> getLocalizedLabels() {
        return new CollectionPage<LocalizedLabelInfo>(contextPath, LocalizedLabelInfo.class, this.localizedLabels, Optional.ofNullable(localizedLabelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LocalizedLabels")
    @JsonIgnore
    public CollectionPage<LocalizedLabelInfo> getLocalizedLabels(HttpRequestOptions options) {
        return new CollectionPage<LocalizedLabelInfo>(contextPath, LocalizedLabelInfo.class, this.localizedLabels, Optional.ofNullable(localizedLabelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="DefaultLabel")
    @JsonIgnore
    public Optional<String> getDefaultLabel() {
        return Optional.ofNullable(defaultLabel);
    }

    public LocalizedLabelDetails withDefaultLabel(String defaultLabel) {
        Checks.checkIsAscii(defaultLabel);
        LocalizedLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabelDetails");
        _x.defaultLabel = defaultLabel;
        return _x;
    }

    public LocalizedLabelDetails withUnmappedField(String name, String value) {
        LocalizedLabelDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<LocalizedLabelInfo> localizedLabels;
        private String localizedLabelsNextLink;
        private String defaultLabel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder localizedLabels(List<LocalizedLabelInfo> localizedLabels) {
            this.localizedLabels = localizedLabels;
            this.changedFields = changedFields.add("LocalizedLabels");
            return this;
        }

        public Builder localizedLabels(LocalizedLabelInfo... localizedLabels) {
            return localizedLabels(Arrays.asList(localizedLabels));
        }

        public Builder localizedLabelsNextLink(String localizedLabelsNextLink) {
            this.localizedLabelsNextLink = localizedLabelsNextLink;
            this.changedFields = changedFields.add("LocalizedLabels");
            return this;
        }

        public Builder defaultLabel(String defaultLabel) {
            this.defaultLabel = defaultLabel;
            this.changedFields = changedFields.add("DefaultLabel");
            return this;
        }

        public LocalizedLabelDetails build() {
            LocalizedLabelDetails _x = new LocalizedLabelDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LocalizedLabelDetails";
            _x.localizedLabels = localizedLabels;
            _x.localizedLabelsNextLink = localizedLabelsNextLink;
            _x.defaultLabel = defaultLabel;
            return _x;
        }
    }

    private LocalizedLabelDetails _copy() {
        LocalizedLabelDetails _x = new LocalizedLabelDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.localizedLabels = localizedLabels;
        _x.defaultLabel = defaultLabel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabelDetails[");
        b.append("LocalizedLabels=");
        b.append(this.localizedLabels);
        b.append(", ");
        b.append("DefaultLabel=");
        b.append(this.defaultLabel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
