package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OwnershipTypes implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("UserOwned")
    USER_OWNED("UserOwned", "1"),

    @JsonProperty("TeamOwned")
    TEAM_OWNED("TeamOwned", "2"),

    @JsonProperty("BusinessOwned")
    BUSINESS_OWNED("BusinessOwned", "4"),

    @JsonProperty("OrganizationOwned")
    ORGANIZATION_OWNED("OrganizationOwned", "8"),

    @JsonProperty("BusinessParented")
    BUSINESS_PARENTED("BusinessParented", "16");

    private final String name;
    private final String value;

    private OwnershipTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
