package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EntityKeyIndexStatus implements Enum {

    @JsonProperty("Pending")
    PENDING("Pending", "0"),

    @JsonProperty("InProgress")
    IN_PROGRESS("InProgress", "1"),

    @JsonProperty("Active")
    ACTIVE("Active", "2"),

    @JsonProperty("Failed")
    FAILED("Failed", "3");

    private final String name;
    private final String value;

    private EntityKeyIndexStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
