package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.AddToQueueResponse;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Queue;
import microsoft.dynamics.crm.entity.Queueitem;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;

@JsonIgnoreType
public class QueueRequest extends EntityRequest<Queue> {

    public QueueRequest(ContextPath contextPath, Optional<Object> value) {
        super(Queue.class, contextPath, value, false);
    }

    public MailboxRequest defaultmailbox() {
        return new MailboxRequest(contextPath.addSegment("defaultmailbox"), Optional.empty());
    }

    public ProcesssessionCollectionRequest queue_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Queue_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest queue_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Queue_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest queue_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Queue_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest queue_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Queue_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BusinessunitRequest businessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public PostfollowCollectionRequest queue_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("queue_PostFollows"), Optional.empty());
    }

    public PostfollowRequest queue_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("queue_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public MailboxCollectionRequest mailbox_regarding_queue() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("mailbox_regarding_queue"), Optional.empty());
    }

    public MailboxRequest mailbox_regarding_queue(String mailboxid) {
        return new MailboxRequest(contextPath.addSegment("mailbox_regarding_queue").addKeys(new NameValue(mailboxid.toString())), Optional.empty());
    }

    public TeamCollectionRequest queue_team() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("queue_team"), Optional.empty());
    }

    public TeamRequest queue_team(String ownerid) {
        return new TeamRequest(contextPath.addSegment("queue_team").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest queue_entries() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("queue_entries"), Optional.empty());
    }

    public QueueitemRequest queue_entries(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("queue_entries").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest queue_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("queue_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest queue_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("queue_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest queue_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Queue_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest queue_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Queue_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest primaryuserid() {
        return new SystemuserRequest(contextPath.addSegment("primaryuserid"), Optional.empty());
    }

    public EmailCollectionRequest queue_Email_EmailSender() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Queue_Email_EmailSender"), Optional.empty());
    }

    public EmailRequest queue_Email_EmailSender(String activityid) {
        return new EmailRequest(contextPath.addSegment("Queue_Email_EmailSender").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserCollectionRequest queuemembership_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("queuemembership_association"), Optional.empty());
    }

    public SystemuserRequest queuemembership_association(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("queuemembership_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SyncerrorCollectionRequest queue_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Queue_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest queue_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Queue_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest queue_system_user() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("queue_system_user"), Optional.empty());
    }

    public SystemuserRequest queue_system_user(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("queue_system_user").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest queue_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("queue_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest queue_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("queue_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest queue_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("queue_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest queue_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("queue_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest queue_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Queue_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest queue_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Queue_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest queue_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Queue_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest queue_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Queue_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    @Action(name = "AddPrincipalToQueue")
    @JsonIgnore
    public ActionRequestNoReturn addPrincipalToQueue(Crmbaseentity principal) {
        Preconditions.checkNotNull(principal, "principal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Principal", "Microsoft.Dynamics.CRM.crmbaseentity", principal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddPrincipalToQueue"), _parameters);
    }

    @Action(name = "AddToQueue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AddToQueueResponse> addToQueue(Crmbaseentity target, Queue sourceQueue, Queueitem queueItemProperties) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("SourceQueue", "Microsoft.Dynamics.CRM.queue", sourceQueue)
            .put("QueueItemProperties", "Microsoft.Dynamics.CRM.queueitem", queueItemProperties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AddToQueueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddToQueue"), AddToQueueResponse.class, _parameters);
    }

}
