package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Connectionrole;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ConnectionroleCollectionRequest extends CollectionPageEntityRequest<Connectionrole, ConnectionroleRequest>{

    protected ContextPath contextPath;

    public ConnectionroleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Connectionrole.class, cp -> new ConnectionroleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest connectionRole_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("ConnectionRole_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest connectionRole_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ConnectionRole_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest connection_Role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Connection_Role_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest connection_Role_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Connection_Role_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("connection_role_connections2"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest connectionRole_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ConnectionRole_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest connectionRole_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ConnectionRole_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("connection_role_connections1"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association() {
        return new ConnectionroleCollectionRequest(contextPath.addSegment("connectionroleassociation_association"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association_referenced() {
        return new ConnectionroleCollectionRequest(contextPath.addSegment("connectionroleassociation_association_referenced"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association_referenced(String connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association_referenced").addKeys(new NameValue(connectionroleid.toString())), Optional.empty());
    }

}
