package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appmodule;
import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AppmodulecomponentRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;

public class AppmoduleCollectionRequest extends CollectionPageEntityRequest<Appmodule, AppmoduleRequest>{

    protected ContextPath contextPath;

    public AppmoduleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Appmodule.class, cp -> new AppmoduleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RoleCollectionRequest appmoduleroles_association() {
        return new RoleCollectionRequest(contextPath.addSegment("appmoduleroles_association"), Optional.empty());
    }

    public RoleRequest appmoduleroles_association(String roleid) {
        return new RoleRequest(contextPath.addSegment("appmoduleroles_association").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public AppconfigCollectionRequest appmodule_appconfig() {
        return new AppconfigCollectionRequest(contextPath.addSegment("appmodule_appconfig"), Optional.empty());
    }

    public AppconfigRequest appmodule_appconfig(String appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("appmodule_appconfig").addKeys(new NameValue(appconfigid.toString())), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest appmodule_appmodulecomponent() {
        return new AppmodulecomponentCollectionRequest(contextPath.addSegment("appmodule_appmodulecomponent"), Optional.empty());
    }

    public AppmodulecomponentRequest appmodule_appmodulecomponent(String appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodule_appmodulecomponent").addKeys(new NameValue(appmodulecomponentid.toString())), Optional.empty());
    }

    public ServiceplanCollectionRequest serviceplan_appmodule_association() {
        return new ServiceplanCollectionRequest(contextPath.addSegment("serviceplan_appmodule_association"), Optional.empty());
    }

    public ServiceplanRequest serviceplan_appmodule_association(String serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("serviceplan_appmodule_association").addKeys(new NameValue(serviceplanid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Appmodule> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Appmodule.class, _parameters);
    }

}
