package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedby_value", 
    "exchangerate", 
    "_modifiedonbehalfby_value", 
    "influencescore", 
    "createdon", 
    "profilelink", 
    "_createdonbehalfby_value", 
    "community", 
    "_transactioncurrencyid_value", 
    "_createdby_value", 
    "statecode", 
    "blocked", 
    "utcconversiontimezonecode", 
    "socialprofileid", 
    "modifiedon", 
    "profilefullname", 
    "uniqueprofileid", 
    "timezoneruleversionnumber", 
    "statuscode", 
    "_owninguser_value", 
    "_ownerid_value", 
    "profilename", 
    "importsequencenumber", 
    "overriddencreatedon", 
    "_owningteam_value", 
    "_owningbusinessunit_value", 
    "versionnumber", 
    "_customerid_value"})
@JsonInclude(Include.NON_NULL)
public class Socialprofile extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.socialprofile";
    }

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("influencescore")
    protected Double influencescore;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("profilelink")
    protected String profilelink;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("community")
    protected Integer community;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("blocked")
    protected Boolean blocked;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("socialprofileid")
    protected String socialprofileid;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("profilefullname")
    protected String profilefullname;

    @JsonProperty("uniqueprofileid")
    protected String uniqueprofileid;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("profilename")
    protected String profilename;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_customerid_value")
    protected String _customerid_value;

    protected Socialprofile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSocialprofile() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedby_value;
        private BigDecimal exchangerate;
        private String _modifiedonbehalfby_value;
        private Double influencescore;
        private OffsetDateTime createdon;
        private String profilelink;
        private String _createdonbehalfby_value;
        private Integer community;
        private String _transactioncurrencyid_value;
        private String _createdby_value;
        private Integer statecode;
        private Boolean blocked;
        private Integer utcconversiontimezonecode;
        private String socialprofileid;
        private OffsetDateTime modifiedon;
        private String profilefullname;
        private String uniqueprofileid;
        private Integer timezoneruleversionnumber;
        private Integer statuscode;
        private String _owninguser_value;
        private String _ownerid_value;
        private String profilename;
        private Integer importsequencenumber;
        private OffsetDateTime overriddencreatedon;
        private String _owningteam_value;
        private String _owningbusinessunit_value;
        private Long versionnumber;
        private String _customerid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder influencescore(Double influencescore) {
            this.influencescore = influencescore;
            this.changedFields = changedFields.add("influencescore");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder profilelink(String profilelink) {
            this.profilelink = profilelink;
            this.changedFields = changedFields.add("profilelink");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder community(Integer community) {
            this.community = community;
            this.changedFields = changedFields.add("community");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            this.changedFields = changedFields.add("blocked");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder socialprofileid(String socialprofileid) {
            this.socialprofileid = socialprofileid;
            this.changedFields = changedFields.add("socialprofileid");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder profilefullname(String profilefullname) {
            this.profilefullname = profilefullname;
            this.changedFields = changedFields.add("profilefullname");
            return this;
        }

        public Builder uniqueprofileid(String uniqueprofileid) {
            this.uniqueprofileid = uniqueprofileid;
            this.changedFields = changedFields.add("uniqueprofileid");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder profilename(String profilename) {
            this.profilename = profilename;
            this.changedFields = changedFields.add("profilename");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _customerid_value(String _customerid_value) {
            this._customerid_value = _customerid_value;
            this.changedFields = changedFields.add("_customerid_value");
            return this;
        }

        public Socialprofile build() {
            Socialprofile _x = new Socialprofile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.socialprofile";
            _x._modifiedby_value = _modifiedby_value;
            _x.exchangerate = exchangerate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.influencescore = influencescore;
            _x.createdon = createdon;
            _x.profilelink = profilelink;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.community = community;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._createdby_value = _createdby_value;
            _x.statecode = statecode;
            _x.blocked = blocked;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.socialprofileid = socialprofileid;
            _x.modifiedon = modifiedon;
            _x.profilefullname = profilefullname;
            _x.uniqueprofileid = uniqueprofileid;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.statuscode = statuscode;
            _x._owninguser_value = _owninguser_value;
            _x._ownerid_value = _ownerid_value;
            _x.profilename = profilename;
            _x.importsequencenumber = importsequencenumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x._owningteam_value = _owningteam_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.versionnumber = versionnumber;
            _x._customerid_value = _customerid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && socialprofileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(socialprofileid.toString()));
        }
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Socialprofile with_modifiedby_value(String _modifiedby_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Socialprofile withExchangerate(BigDecimal exchangerate) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Socialprofile with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="influencescore")
    @JsonIgnore
    public Optional<Double> getInfluencescore() {
        return Optional.ofNullable(influencescore);
    }

    public Socialprofile withInfluencescore(Double influencescore) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("influencescore");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.influencescore = influencescore;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Socialprofile withCreatedon(OffsetDateTime createdon) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="profilelink")
    @JsonIgnore
    public Optional<String> getProfilelink() {
        return Optional.ofNullable(profilelink);
    }

    public Socialprofile withProfilelink(String profilelink) {
        Checks.checkIsAscii(profilelink);
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("profilelink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.profilelink = profilelink;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Socialprofile with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="community")
    @JsonIgnore
    public Optional<Integer> getCommunity() {
        return Optional.ofNullable(community);
    }

    public Socialprofile withCommunity(Integer community) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("community");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.community = community;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Socialprofile with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Socialprofile with_createdby_value(String _createdby_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Socialprofile withStatecode(Integer statecode) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="blocked")
    @JsonIgnore
    public Optional<Boolean> getBlocked() {
        return Optional.ofNullable(blocked);
    }

    public Socialprofile withBlocked(Boolean blocked) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("blocked");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.blocked = blocked;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Socialprofile withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="socialprofileid")
    @JsonIgnore
    public Optional<String> getSocialprofileid() {
        return Optional.ofNullable(socialprofileid);
    }

    public Socialprofile withSocialprofileid(String socialprofileid) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("socialprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.socialprofileid = socialprofileid;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Socialprofile withModifiedon(OffsetDateTime modifiedon) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="profilefullname")
    @JsonIgnore
    public Optional<String> getProfilefullname() {
        return Optional.ofNullable(profilefullname);
    }

    public Socialprofile withProfilefullname(String profilefullname) {
        Checks.checkIsAscii(profilefullname);
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("profilefullname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.profilefullname = profilefullname;
        return _x;
    }

    @Property(name="uniqueprofileid")
    @JsonIgnore
    public Optional<String> getUniqueprofileid() {
        return Optional.ofNullable(uniqueprofileid);
    }

    public Socialprofile withUniqueprofileid(String uniqueprofileid) {
        Checks.checkIsAscii(uniqueprofileid);
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("uniqueprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.uniqueprofileid = uniqueprofileid;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Socialprofile withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Socialprofile withStatuscode(Integer statuscode) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Socialprofile with_owninguser_value(String _owninguser_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Socialprofile with_ownerid_value(String _ownerid_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="profilename")
    @JsonIgnore
    public Optional<String> getProfilename() {
        return Optional.ofNullable(profilename);
    }

    public Socialprofile withProfilename(String profilename) {
        Checks.checkIsAscii(profilename);
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("profilename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.profilename = profilename;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Socialprofile withImportsequencenumber(Integer importsequencenumber) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Socialprofile withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Socialprofile with_owningteam_value(String _owningteam_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Socialprofile with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Socialprofile withVersionnumber(Long versionnumber) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_customerid_value")
    @JsonIgnore
    public Optional<String> get_customerid_value() {
        return Optional.ofNullable(_customerid_value);
    }

    public Socialprofile with_customerid_value(String _customerid_value) {
        Socialprofile _x = _copy();
        _x.changedFields = changedFields.add("_customerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.socialprofile");
        _x._customerid_value = _customerid_value;
        return _x;
    }

    public Socialprofile withUnmappedField(String name, String value) {
        Socialprofile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="SocialProfile_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSocialProfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialProfile_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "SocialProfile_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="SocialProfile_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSocialProfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SocialProfile_AsyncOperations"), RequestHelper.getValue(unmappedFields, "SocialProfile_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="socialprofile_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getSocialprofile_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialprofile_connections1"), RequestHelper.getValue(unmappedFields, "socialprofile_connections1"));
    }

    @NavigationProperty(name="socialprofile_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getSocialprofile_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialprofile_connections2"), RequestHelper.getValue(unmappedFields, "socialprofile_connections2"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="customerid_contact")
    @JsonIgnore
    public ContactRequest getCustomerid_contact() {
        return new ContactRequest(contextPath.addSegment("customerid_contact"), RequestHelper.getValue(unmappedFields, "customerid_contact"));
    }

    @NavigationProperty(name="SocialProfile_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSocialProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SocialProfile_SyncErrors"), RequestHelper.getValue(unmappedFields, "SocialProfile_SyncErrors"));
    }

    @NavigationProperty(name="socialprofile_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getSocialprofile_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("socialprofile_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "socialprofile_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="Socialprofile_SocialActivities")
    @JsonIgnore
    public SocialactivityCollectionRequest getSocialprofile_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("Socialprofile_SocialActivities"), RequestHelper.getValue(unmappedFields, "Socialprofile_SocialActivities"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="SocialProfile_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSocialProfile_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SocialProfile_ProcessSessions"), RequestHelper.getValue(unmappedFields, "SocialProfile_ProcessSessions"));
    }

    @NavigationProperty(name="SocialProfile_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSocialProfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialProfile_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "SocialProfile_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="customerid_account")
    @JsonIgnore
    public AccountRequest getCustomerid_account() {
        return new AccountRequest(contextPath.addSegment("customerid_account"), RequestHelper.getValue(unmappedFields, "customerid_account"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Socialprofile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Socialprofile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Socialprofile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Socialprofile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Socialprofile _copy() {
        Socialprofile _x = new Socialprofile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedby_value = _modifiedby_value;
        _x.exchangerate = exchangerate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.influencescore = influencescore;
        _x.createdon = createdon;
        _x.profilelink = profilelink;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.community = community;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._createdby_value = _createdby_value;
        _x.statecode = statecode;
        _x.blocked = blocked;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.socialprofileid = socialprofileid;
        _x.modifiedon = modifiedon;
        _x.profilefullname = profilefullname;
        _x.uniqueprofileid = uniqueprofileid;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.statuscode = statuscode;
        _x._owninguser_value = _owninguser_value;
        _x._ownerid_value = _ownerid_value;
        _x.profilename = profilename;
        _x.importsequencenumber = importsequencenumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x._owningteam_value = _owningteam_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.versionnumber = versionnumber;
        _x._customerid_value = _customerid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Socialprofile[");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("influencescore=");
        b.append(this.influencescore);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("profilelink=");
        b.append(this.profilelink);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("community=");
        b.append(this.community);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("blocked=");
        b.append(this.blocked);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("socialprofileid=");
        b.append(this.socialprofileid);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("profilefullname=");
        b.append(this.profilefullname);
        b.append(", ");
        b.append("uniqueprofileid=");
        b.append(this.uniqueprofileid);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("profilename=");
        b.append(this.profilename);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_customerid_value=");
        b.append(this._customerid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
