package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "secureconfig", 
    "_createdby_value", 
    "customizationlevel", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "createdon", 
    "sdkmessageprocessingstepsecureconfigidunique", 
    "_organizationid_value", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "sdkmessageprocessingstepsecureconfigid"})
@JsonInclude(Include.NON_NULL)
public class Sdkmessageprocessingstepsecureconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig";
    }

    @JsonProperty("secureconfig")
    protected String secureconfig;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("sdkmessageprocessingstepsecureconfigidunique")
    protected String sdkmessageprocessingstepsecureconfigidunique;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("sdkmessageprocessingstepsecureconfigid")
    protected String sdkmessageprocessingstepsecureconfigid;

    protected Sdkmessageprocessingstepsecureconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSdkmessageprocessingstepsecureconfig() {
        return new Builder();
    }

    public static final class Builder {
        private String secureconfig;
        private String _createdby_value;
        private Integer customizationlevel;
        private String _modifiedby_value;
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private String sdkmessageprocessingstepsecureconfigidunique;
        private String _organizationid_value;
        private OffsetDateTime modifiedon;
        private String _modifiedonbehalfby_value;
        private String sdkmessageprocessingstepsecureconfigid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder secureconfig(String secureconfig) {
            this.secureconfig = secureconfig;
            this.changedFields = changedFields.add("secureconfig");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder sdkmessageprocessingstepsecureconfigidunique(String sdkmessageprocessingstepsecureconfigidunique) {
            this.sdkmessageprocessingstepsecureconfigidunique = sdkmessageprocessingstepsecureconfigidunique;
            this.changedFields = changedFields.add("sdkmessageprocessingstepsecureconfigidunique");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder sdkmessageprocessingstepsecureconfigid(String sdkmessageprocessingstepsecureconfigid) {
            this.sdkmessageprocessingstepsecureconfigid = sdkmessageprocessingstepsecureconfigid;
            this.changedFields = changedFields.add("sdkmessageprocessingstepsecureconfigid");
            return this;
        }

        public Sdkmessageprocessingstepsecureconfig build() {
            Sdkmessageprocessingstepsecureconfig _x = new Sdkmessageprocessingstepsecureconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig";
            _x.secureconfig = secureconfig;
            _x._createdby_value = _createdby_value;
            _x.customizationlevel = customizationlevel;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.sdkmessageprocessingstepsecureconfigidunique = sdkmessageprocessingstepsecureconfigidunique;
            _x._organizationid_value = _organizationid_value;
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.sdkmessageprocessingstepsecureconfigid = sdkmessageprocessingstepsecureconfigid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sdkmessageprocessingstepsecureconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid.toString()));
        }
    }

    @Property(name="secureconfig")
    @JsonIgnore
    public Optional<String> getSecureconfig() {
        return Optional.ofNullable(secureconfig);
    }

    public Sdkmessageprocessingstepsecureconfig withSecureconfig(String secureconfig) {
        Checks.checkIsAscii(secureconfig);
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("secureconfig");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.secureconfig = secureconfig;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sdkmessageprocessingstepsecureconfig with_createdby_value(String _createdby_value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Sdkmessageprocessingstepsecureconfig withCustomizationlevel(Integer customizationlevel) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sdkmessageprocessingstepsecureconfig with_modifiedby_value(String _modifiedby_value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sdkmessageprocessingstepsecureconfig with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sdkmessageprocessingstepsecureconfig withCreatedon(OffsetDateTime createdon) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepsecureconfigidunique")
    @JsonIgnore
    public Optional<String> getSdkmessageprocessingstepsecureconfigidunique() {
        return Optional.ofNullable(sdkmessageprocessingstepsecureconfigidunique);
    }

    public Sdkmessageprocessingstepsecureconfig withSdkmessageprocessingstepsecureconfigidunique(String sdkmessageprocessingstepsecureconfigidunique) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepsecureconfigidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.sdkmessageprocessingstepsecureconfigidunique = sdkmessageprocessingstepsecureconfigidunique;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Sdkmessageprocessingstepsecureconfig with_organizationid_value(String _organizationid_value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sdkmessageprocessingstepsecureconfig withModifiedon(OffsetDateTime modifiedon) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sdkmessageprocessingstepsecureconfig with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepsecureconfigid")
    @JsonIgnore
    public Optional<String> getSdkmessageprocessingstepsecureconfigid() {
        return Optional.ofNullable(sdkmessageprocessingstepsecureconfigid);
    }

    public Sdkmessageprocessingstepsecureconfig withSdkmessageprocessingstepsecureconfigid(String sdkmessageprocessingstepsecureconfigid) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepsecureconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepsecureconfig");
        _x.sdkmessageprocessingstepsecureconfigid = sdkmessageprocessingstepsecureconfigid;
        return _x;
    }

    public Sdkmessageprocessingstepsecureconfig withUnmappedField(String name, String value) {
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sdkmessageprocessingstepsecureconfigid_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getSdkmessageprocessingstepsecureconfigid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("sdkmessageprocessingstepsecureconfigid_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "sdkmessageprocessingstepsecureconfigid_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstepsecureconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstepsecureconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstepsecureconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sdkmessageprocessingstepsecureconfig _copy() {
        Sdkmessageprocessingstepsecureconfig _x = new Sdkmessageprocessingstepsecureconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.secureconfig = secureconfig;
        _x._createdby_value = _createdby_value;
        _x.customizationlevel = customizationlevel;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.sdkmessageprocessingstepsecureconfigidunique = sdkmessageprocessingstepsecureconfigidunique;
        _x._organizationid_value = _organizationid_value;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.sdkmessageprocessingstepsecureconfigid = sdkmessageprocessingstepsecureconfigid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sdkmessageprocessingstepsecureconfig[");
        b.append("secureconfig=");
        b.append(this.secureconfig);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("sdkmessageprocessingstepsecureconfigidunique=");
        b.append(this.sdkmessageprocessingstepsecureconfigidunique);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("sdkmessageprocessingstepsecureconfigid=");
        b.append(this.sdkmessageprocessingstepsecureconfigid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
