package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "roletemplateid", 
    "isdeep", 
    "roletemplateprivilegeid", 
    "isglobal", 
    "islocal", 
    "privilegeid", 
    "isbasic"})
@JsonInclude(Include.NON_NULL)
public class Roletemplateprivileges extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.roletemplateprivileges";
    }

    @JsonProperty("roletemplateid")
    protected String roletemplateid;

    @JsonProperty("isdeep")
    protected Boolean isdeep;

    @JsonProperty("roletemplateprivilegeid")
    protected String roletemplateprivilegeid;

    @JsonProperty("isglobal")
    protected Boolean isglobal;

    @JsonProperty("islocal")
    protected Boolean islocal;

    @JsonProperty("privilegeid")
    protected String privilegeid;

    @JsonProperty("isbasic")
    protected Boolean isbasic;

    protected Roletemplateprivileges() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoletemplateprivileges() {
        return new Builder();
    }

    public static final class Builder {
        private String roletemplateid;
        private Boolean isdeep;
        private String roletemplateprivilegeid;
        private Boolean isglobal;
        private Boolean islocal;
        private String privilegeid;
        private Boolean isbasic;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder roletemplateid(String roletemplateid) {
            this.roletemplateid = roletemplateid;
            this.changedFields = changedFields.add("roletemplateid");
            return this;
        }

        public Builder isdeep(Boolean isdeep) {
            this.isdeep = isdeep;
            this.changedFields = changedFields.add("isdeep");
            return this;
        }

        public Builder roletemplateprivilegeid(String roletemplateprivilegeid) {
            this.roletemplateprivilegeid = roletemplateprivilegeid;
            this.changedFields = changedFields.add("roletemplateprivilegeid");
            return this;
        }

        public Builder isglobal(Boolean isglobal) {
            this.isglobal = isglobal;
            this.changedFields = changedFields.add("isglobal");
            return this;
        }

        public Builder islocal(Boolean islocal) {
            this.islocal = islocal;
            this.changedFields = changedFields.add("islocal");
            return this;
        }

        public Builder privilegeid(String privilegeid) {
            this.privilegeid = privilegeid;
            this.changedFields = changedFields.add("privilegeid");
            return this;
        }

        public Builder isbasic(Boolean isbasic) {
            this.isbasic = isbasic;
            this.changedFields = changedFields.add("isbasic");
            return this;
        }

        public Roletemplateprivileges build() {
            Roletemplateprivileges _x = new Roletemplateprivileges();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.roletemplateprivileges";
            _x.roletemplateid = roletemplateid;
            _x.isdeep = isdeep;
            _x.roletemplateprivilegeid = roletemplateprivilegeid;
            _x.isglobal = isglobal;
            _x.islocal = islocal;
            _x.privilegeid = privilegeid;
            _x.isbasic = isbasic;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && roletemplateprivilegeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(roletemplateprivilegeid.toString()));
        }
    }

    @Property(name="roletemplateid")
    @JsonIgnore
    public Optional<String> getRoletemplateid() {
        return Optional.ofNullable(roletemplateid);
    }

    public Roletemplateprivileges withRoletemplateid(String roletemplateid) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("roletemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.roletemplateid = roletemplateid;
        return _x;
    }

    @Property(name="isdeep")
    @JsonIgnore
    public Optional<Boolean> getIsdeep() {
        return Optional.ofNullable(isdeep);
    }

    public Roletemplateprivileges withIsdeep(Boolean isdeep) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("isdeep");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.isdeep = isdeep;
        return _x;
    }

    @Property(name="roletemplateprivilegeid")
    @JsonIgnore
    public Optional<String> getRoletemplateprivilegeid() {
        return Optional.ofNullable(roletemplateprivilegeid);
    }

    public Roletemplateprivileges withRoletemplateprivilegeid(String roletemplateprivilegeid) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("roletemplateprivilegeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.roletemplateprivilegeid = roletemplateprivilegeid;
        return _x;
    }

    @Property(name="isglobal")
    @JsonIgnore
    public Optional<Boolean> getIsglobal() {
        return Optional.ofNullable(isglobal);
    }

    public Roletemplateprivileges withIsglobal(Boolean isglobal) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("isglobal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.isglobal = isglobal;
        return _x;
    }

    @Property(name="islocal")
    @JsonIgnore
    public Optional<Boolean> getIslocal() {
        return Optional.ofNullable(islocal);
    }

    public Roletemplateprivileges withIslocal(Boolean islocal) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("islocal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.islocal = islocal;
        return _x;
    }

    @Property(name="privilegeid")
    @JsonIgnore
    public Optional<String> getPrivilegeid() {
        return Optional.ofNullable(privilegeid);
    }

    public Roletemplateprivileges withPrivilegeid(String privilegeid) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("privilegeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.privilegeid = privilegeid;
        return _x;
    }

    @Property(name="isbasic")
    @JsonIgnore
    public Optional<Boolean> getIsbasic() {
        return Optional.ofNullable(isbasic);
    }

    public Roletemplateprivileges withIsbasic(Boolean isbasic) {
        Roletemplateprivileges _x = _copy();
        _x.changedFields = changedFields.add("isbasic");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplateprivileges");
        _x.isbasic = isbasic;
        return _x;
    }

    public Roletemplateprivileges withUnmappedField(String name, String value) {
        Roletemplateprivileges _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roletemplateprivileges patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Roletemplateprivileges _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roletemplateprivileges put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Roletemplateprivileges _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Roletemplateprivileges _copy() {
        Roletemplateprivileges _x = new Roletemplateprivileges();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.roletemplateid = roletemplateid;
        _x.isdeep = isdeep;
        _x.roletemplateprivilegeid = roletemplateprivilegeid;
        _x.isglobal = isglobal;
        _x.islocal = islocal;
        _x.privilegeid = privilegeid;
        _x.isbasic = isbasic;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Roletemplateprivileges[");
        b.append("roletemplateid=");
        b.append(this.roletemplateid);
        b.append(", ");
        b.append("isdeep=");
        b.append(this.isdeep);
        b.append(", ");
        b.append("roletemplateprivilegeid=");
        b.append(this.roletemplateprivilegeid);
        b.append(", ");
        b.append("isglobal=");
        b.append(this.isglobal);
        b.append(", ");
        b.append("islocal=");
        b.append(this.islocal);
        b.append(", ");
        b.append("privilegeid=");
        b.append(this.privilegeid);
        b.append(", ");
        b.append("isbasic=");
        b.append(this.isbasic);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
