package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.RelationshipattributeCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "solutionid", 
    "entitykeyid", 
    "overwritetime", 
    "relationshipid", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class Relationship extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.relationship";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("entitykeyid")
    protected String entitykeyid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("relationshipid")
    protected String relationshipid;

    @JsonProperty("name")
    protected String name;

    protected Relationship() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRelationship() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private String solutionid;
        private String entitykeyid;
        private OffsetDateTime overwritetime;
        private String relationshipid;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder entitykeyid(String entitykeyid) {
            this.entitykeyid = entitykeyid;
            this.changedFields = changedFields.add("entitykeyid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder relationshipid(String relationshipid) {
            this.relationshipid = relationshipid;
            this.changedFields = changedFields.add("relationshipid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Relationship build() {
            Relationship _x = new Relationship();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.relationship";
            _x.componentstate = componentstate;
            _x.solutionid = solutionid;
            _x.entitykeyid = entitykeyid;
            _x.overwritetime = overwritetime;
            _x.relationshipid = relationshipid;
            _x.name = name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && relationshipid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(relationshipid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Relationship withComponentstate(Integer componentstate) {
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Relationship withSolutionid(String solutionid) {
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="entitykeyid")
    @JsonIgnore
    public Optional<String> getEntitykeyid() {
        return Optional.ofNullable(entitykeyid);
    }

    public Relationship withEntitykeyid(String entitykeyid) {
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("entitykeyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.entitykeyid = entitykeyid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Relationship withOverwritetime(OffsetDateTime overwritetime) {
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="relationshipid")
    @JsonIgnore
    public Optional<String> getRelationshipid() {
        return Optional.ofNullable(relationshipid);
    }

    public Relationship withRelationshipid(String relationshipid) {
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("relationshipid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.relationshipid = relationshipid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Relationship withName(String name) {
        Checks.checkIsAscii(name);
        Relationship _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationship");
        _x.name = name;
        return _x;
    }

    public Relationship withUnmappedField(String name, String value) {
        Relationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="relationship_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeCollectionRequest getRelationship_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("relationship_relationshipattribute"), RequestHelper.getValue(unmappedFields, "relationship_relationshipattribute"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Relationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Relationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Relationship _copy() {
        Relationship _x = new Relationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.solutionid = solutionid;
        _x.entitykeyid = entitykeyid;
        _x.overwritetime = overwritetime;
        _x.relationshipid = relationshipid;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Relationship[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("entitykeyid=");
        b.append(this.entitykeyid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("relationshipid=");
        b.append(this.relationshipid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
