package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "gateway", 
    "outputs", 
    "createdon", 
    "statecode", 
    "outputs_name", 
    "_owninguser_value", 
    "overriddencreatedon", 
    "utcconversiontimezonecode", 
    "importsequencenumber", 
    "timezoneruleversionnumber", 
    "processversion", 
    "correlationid", 
    "_owningteam_value", 
    "_createdby_value", 
    "additionalcontext_name", 
    "_modifiedonbehalfby_value", 
    "_owningbusinessunit_value", 
    "modifiedon", 
    "versionnumber", 
    "statuscode", 
    "additionalcontext", 
    "errormessage", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "_ownerid_value", 
    "_regardingobjectid_value", 
    "context", 
    "completedon", 
    "startedon", 
    "flowsessionid", 
    "errorcode", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class Flowsession extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.flowsession";
    }

    @JsonProperty("gateway")
    protected String gateway;

    @JsonProperty("outputs")
    protected byte[] outputs;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("outputs_name")
    protected String outputs_name;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("processversion")
    protected String processversion;

    @JsonProperty("correlationid")
    protected String correlationid;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("additionalcontext_name")
    protected String additionalcontext_name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("additionalcontext")
    protected byte[] additionalcontext;

    @JsonProperty("errormessage")
    protected String errormessage;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("context")
    protected String context;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("startedon")
    protected OffsetDateTime startedon;

    @JsonProperty("flowsessionid")
    protected String flowsessionid;

    @JsonProperty("errorcode")
    protected String errorcode;

    @JsonProperty("name")
    protected String name;

    protected Flowsession() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFlowsession() {
        return new Builder();
    }

    public static final class Builder {
        private String gateway;
        private byte[] outputs;
        private OffsetDateTime createdon;
        private Integer statecode;
        private String outputs_name;
        private String _owninguser_value;
        private OffsetDateTime overriddencreatedon;
        private Integer utcconversiontimezonecode;
        private Integer importsequencenumber;
        private Integer timezoneruleversionnumber;
        private String processversion;
        private String correlationid;
        private String _owningteam_value;
        private String _createdby_value;
        private String additionalcontext_name;
        private String _modifiedonbehalfby_value;
        private String _owningbusinessunit_value;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private Integer statuscode;
        private byte[] additionalcontext;
        private String errormessage;
        private String _createdonbehalfby_value;
        private String _modifiedby_value;
        private String _ownerid_value;
        private String _regardingobjectid_value;
        private String context;
        private OffsetDateTime completedon;
        private OffsetDateTime startedon;
        private String flowsessionid;
        private String errorcode;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.changedFields = changedFields.add("gateway");
            return this;
        }

        public Builder outputs(byte[] outputs) {
            this.outputs = outputs;
            this.changedFields = changedFields.add("outputs");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder outputs_name(String outputs_name) {
            this.outputs_name = outputs_name;
            this.changedFields = changedFields.add("outputs_name");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder processversion(String processversion) {
            this.processversion = processversion;
            this.changedFields = changedFields.add("processversion");
            return this;
        }

        public Builder correlationid(String correlationid) {
            this.correlationid = correlationid;
            this.changedFields = changedFields.add("correlationid");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder additionalcontext_name(String additionalcontext_name) {
            this.additionalcontext_name = additionalcontext_name;
            this.changedFields = changedFields.add("additionalcontext_name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder additionalcontext(byte[] additionalcontext) {
            this.additionalcontext = additionalcontext;
            this.changedFields = changedFields.add("additionalcontext");
            return this;
        }

        public Builder errormessage(String errormessage) {
            this.errormessage = errormessage;
            this.changedFields = changedFields.add("errormessage");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            this.changedFields = changedFields.add("context");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder startedon(OffsetDateTime startedon) {
            this.startedon = startedon;
            this.changedFields = changedFields.add("startedon");
            return this;
        }

        public Builder flowsessionid(String flowsessionid) {
            this.flowsessionid = flowsessionid;
            this.changedFields = changedFields.add("flowsessionid");
            return this;
        }

        public Builder errorcode(String errorcode) {
            this.errorcode = errorcode;
            this.changedFields = changedFields.add("errorcode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Flowsession build() {
            Flowsession _x = new Flowsession();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.flowsession";
            _x.gateway = gateway;
            _x.outputs = outputs;
            _x.createdon = createdon;
            _x.statecode = statecode;
            _x.outputs_name = outputs_name;
            _x._owninguser_value = _owninguser_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.importsequencenumber = importsequencenumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.processversion = processversion;
            _x.correlationid = correlationid;
            _x._owningteam_value = _owningteam_value;
            _x._createdby_value = _createdby_value;
            _x.additionalcontext_name = additionalcontext_name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.statuscode = statuscode;
            _x.additionalcontext = additionalcontext;
            _x.errormessage = errormessage;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._ownerid_value = _ownerid_value;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.context = context;
            _x.completedon = completedon;
            _x.startedon = startedon;
            _x.flowsessionid = flowsessionid;
            _x.errorcode = errorcode;
            _x.name = name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && flowsessionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(flowsessionid.toString()));
        }
    }

    @Property(name="gateway")
    @JsonIgnore
    public Optional<String> getGateway() {
        return Optional.ofNullable(gateway);
    }

    public Flowsession withGateway(String gateway) {
        Checks.checkIsAscii(gateway);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("gateway");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.gateway = gateway;
        return _x;
    }

    @Property(name="outputs")
    @JsonIgnore
    public Optional<byte[]> getOutputs() {
        return Optional.ofNullable(outputs);
    }

    public Flowsession withOutputs(byte[] outputs) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("outputs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.outputs = outputs;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Flowsession withCreatedon(OffsetDateTime createdon) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Flowsession withStatecode(Integer statecode) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="outputs_name")
    @JsonIgnore
    public Optional<String> getOutputs_name() {
        return Optional.ofNullable(outputs_name);
    }

    public Flowsession withOutputs_name(String outputs_name) {
        Checks.checkIsAscii(outputs_name);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("outputs_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.outputs_name = outputs_name;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Flowsession with_owninguser_value(String _owninguser_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Flowsession withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Flowsession withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Flowsession withImportsequencenumber(Integer importsequencenumber) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Flowsession withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="processversion")
    @JsonIgnore
    public Optional<String> getProcessversion() {
        return Optional.ofNullable(processversion);
    }

    public Flowsession withProcessversion(String processversion) {
        Checks.checkIsAscii(processversion);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("processversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.processversion = processversion;
        return _x;
    }

    @Property(name="correlationid")
    @JsonIgnore
    public Optional<String> getCorrelationid() {
        return Optional.ofNullable(correlationid);
    }

    public Flowsession withCorrelationid(String correlationid) {
        Checks.checkIsAscii(correlationid);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("correlationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.correlationid = correlationid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Flowsession with_owningteam_value(String _owningteam_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Flowsession with_createdby_value(String _createdby_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="additionalcontext_name")
    @JsonIgnore
    public Optional<String> getAdditionalcontext_name() {
        return Optional.ofNullable(additionalcontext_name);
    }

    public Flowsession withAdditionalcontext_name(String additionalcontext_name) {
        Checks.checkIsAscii(additionalcontext_name);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("additionalcontext_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.additionalcontext_name = additionalcontext_name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Flowsession with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Flowsession with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Flowsession withModifiedon(OffsetDateTime modifiedon) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Flowsession withVersionnumber(Long versionnumber) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Flowsession withStatuscode(Integer statuscode) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="additionalcontext")
    @JsonIgnore
    public Optional<byte[]> getAdditionalcontext() {
        return Optional.ofNullable(additionalcontext);
    }

    public Flowsession withAdditionalcontext(byte[] additionalcontext) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("additionalcontext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.additionalcontext = additionalcontext;
        return _x;
    }

    @Property(name="errormessage")
    @JsonIgnore
    public Optional<String> getErrormessage() {
        return Optional.ofNullable(errormessage);
    }

    public Flowsession withErrormessage(String errormessage) {
        Checks.checkIsAscii(errormessage);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("errormessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.errormessage = errormessage;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Flowsession with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Flowsession with_modifiedby_value(String _modifiedby_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Flowsession with_ownerid_value(String _ownerid_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Flowsession with_regardingobjectid_value(String _regardingobjectid_value) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="context")
    @JsonIgnore
    public Optional<String> getContext() {
        return Optional.ofNullable(context);
    }

    public Flowsession withContext(String context) {
        Checks.checkIsAscii(context);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("context");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.context = context;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Flowsession withCompletedon(OffsetDateTime completedon) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="startedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedon() {
        return Optional.ofNullable(startedon);
    }

    public Flowsession withStartedon(OffsetDateTime startedon) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("startedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.startedon = startedon;
        return _x;
    }

    @Property(name="flowsessionid")
    @JsonIgnore
    public Optional<String> getFlowsessionid() {
        return Optional.ofNullable(flowsessionid);
    }

    public Flowsession withFlowsessionid(String flowsessionid) {
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("flowsessionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.flowsessionid = flowsessionid;
        return _x;
    }

    @Property(name="errorcode")
    @JsonIgnore
    public Optional<String> getErrorcode() {
        return Optional.ofNullable(errorcode);
    }

    public Flowsession withErrorcode(String errorcode) {
        Checks.checkIsAscii(errorcode);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("errorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.errorcode = errorcode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Flowsession withName(String name) {
        Checks.checkIsAscii(name);
        Flowsession _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.flowsession");
        _x.name = name;
        return _x;
    }

    public Flowsession withUnmappedField(String name, String value) {
        Flowsession _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="flowsession_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getFlowsession_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("flowsession_SyncErrors"), RequestHelper.getValue(unmappedFields, "flowsession_SyncErrors"));
    }

    @NavigationProperty(name="flowsession_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getFlowsession_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("flowsession_AsyncOperations"), RequestHelper.getValue(unmappedFields, "flowsession_AsyncOperations"));
    }

    @NavigationProperty(name="flowsession_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getFlowsession_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("flowsession_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "flowsession_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="flowsession_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getFlowsession_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("flowsession_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "flowsession_BulkDeleteFailures"));
    }

    @NavigationProperty(name="flowsession_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getFlowsession_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("flowsession_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "flowsession_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="flowsession_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getFlowsession_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("flowsession_FileAttachments"), RequestHelper.getValue(unmappedFields, "flowsession_FileAttachments"));
    }

    @NavigationProperty(name="flowsession_workflowbinary_FlowSessionId")
    @JsonIgnore
    public WorkflowbinaryCollectionRequest getFlowsession_workflowbinary_FlowSessionId() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("flowsession_workflowbinary_FlowSessionId"), RequestHelper.getValue(unmappedFields, "flowsession_workflowbinary_FlowSessionId"));
    }

    @NavigationProperty(name="regardingobjectid_process")
    @JsonIgnore
    public WorkflowRequest getRegardingobjectid_process() {
        return new WorkflowRequest(contextPath.addSegment("regardingobjectid_process"), RequestHelper.getValue(unmappedFields, "regardingobjectid_process"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Flowsession patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Flowsession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Flowsession put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Flowsession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Flowsession _copy() {
        Flowsession _x = new Flowsession();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.gateway = gateway;
        _x.outputs = outputs;
        _x.createdon = createdon;
        _x.statecode = statecode;
        _x.outputs_name = outputs_name;
        _x._owninguser_value = _owninguser_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.importsequencenumber = importsequencenumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.processversion = processversion;
        _x.correlationid = correlationid;
        _x._owningteam_value = _owningteam_value;
        _x._createdby_value = _createdby_value;
        _x.additionalcontext_name = additionalcontext_name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.statuscode = statuscode;
        _x.additionalcontext = additionalcontext;
        _x.errormessage = errormessage;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._ownerid_value = _ownerid_value;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.context = context;
        _x.completedon = completedon;
        _x.startedon = startedon;
        _x.flowsessionid = flowsessionid;
        _x.errorcode = errorcode;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Flowsession[");
        b.append("gateway=");
        b.append(this.gateway);
        b.append(", ");
        b.append("outputs=");
        b.append(this.outputs);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("outputs_name=");
        b.append(this.outputs_name);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("processversion=");
        b.append(this.processversion);
        b.append(", ");
        b.append("correlationid=");
        b.append(this.correlationid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("additionalcontext_name=");
        b.append(this.additionalcontext_name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("additionalcontext=");
        b.append(this.additionalcontext);
        b.append(", ");
        b.append("errormessage=");
        b.append(this.errormessage);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("context=");
        b.append(this.context);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("startedon=");
        b.append(this.startedon);
        b.append(", ");
        b.append("flowsessionid=");
        b.append(this.flowsessionid);
        b.append(", ");
        b.append("errorcode=");
        b.append(this.errorcode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
