package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleconditionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statuscode", 
    "modifiedon", 
    "_createdby_value", 
    "matchingentitymatchcodetable", 
    "matchingentitytypecode", 
    "_owninguser_value", 
    "statecode", 
    "timezoneruleversionnumber", 
    "baseentitytypecode", 
    "excludeinactiverecords", 
    "_owningbusinessunit_value", 
    "_modifiedonbehalfby_value", 
    "matchingentityname", 
    "baseentitymatchcodetable", 
    "_modifiedby_value", 
    "duplicateruleid", 
    "_owningteam_value", 
    "_ownerid_value", 
    "iscasesensitive", 
    "description", 
    "utcconversiontimezonecode", 
    "baseentityname", 
    "name", 
    "createdon", 
    "_createdonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Duplicaterule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.duplicaterule";
    }

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("matchingentitymatchcodetable")
    protected String matchingentitymatchcodetable;

    @JsonProperty("matchingentitytypecode")
    protected Integer matchingentitytypecode;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("baseentitytypecode")
    protected Integer baseentitytypecode;

    @JsonProperty("excludeinactiverecords")
    protected Boolean excludeinactiverecords;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("matchingentityname")
    protected String matchingentityname;

    @JsonProperty("baseentitymatchcodetable")
    protected String baseentitymatchcodetable;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("duplicateruleid")
    protected String duplicateruleid;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("iscasesensitive")
    protected Boolean iscasesensitive;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("baseentityname")
    protected String baseentityname;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    protected Duplicaterule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDuplicaterule() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statuscode;
        private OffsetDateTime modifiedon;
        private String _createdby_value;
        private String matchingentitymatchcodetable;
        private Integer matchingentitytypecode;
        private String _owninguser_value;
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private Integer baseentitytypecode;
        private Boolean excludeinactiverecords;
        private String _owningbusinessunit_value;
        private String _modifiedonbehalfby_value;
        private String matchingentityname;
        private String baseentitymatchcodetable;
        private String _modifiedby_value;
        private String duplicateruleid;
        private String _owningteam_value;
        private String _ownerid_value;
        private Boolean iscasesensitive;
        private String description;
        private Integer utcconversiontimezonecode;
        private String baseentityname;
        private String name;
        private OffsetDateTime createdon;
        private String _createdonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder matchingentitymatchcodetable(String matchingentitymatchcodetable) {
            this.matchingentitymatchcodetable = matchingentitymatchcodetable;
            this.changedFields = changedFields.add("matchingentitymatchcodetable");
            return this;
        }

        public Builder matchingentitytypecode(Integer matchingentitytypecode) {
            this.matchingentitytypecode = matchingentitytypecode;
            this.changedFields = changedFields.add("matchingentitytypecode");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder baseentitytypecode(Integer baseentitytypecode) {
            this.baseentitytypecode = baseentitytypecode;
            this.changedFields = changedFields.add("baseentitytypecode");
            return this;
        }

        public Builder excludeinactiverecords(Boolean excludeinactiverecords) {
            this.excludeinactiverecords = excludeinactiverecords;
            this.changedFields = changedFields.add("excludeinactiverecords");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder matchingentityname(String matchingentityname) {
            this.matchingentityname = matchingentityname;
            this.changedFields = changedFields.add("matchingentityname");
            return this;
        }

        public Builder baseentitymatchcodetable(String baseentitymatchcodetable) {
            this.baseentitymatchcodetable = baseentitymatchcodetable;
            this.changedFields = changedFields.add("baseentitymatchcodetable");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder duplicateruleid(String duplicateruleid) {
            this.duplicateruleid = duplicateruleid;
            this.changedFields = changedFields.add("duplicateruleid");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder iscasesensitive(Boolean iscasesensitive) {
            this.iscasesensitive = iscasesensitive;
            this.changedFields = changedFields.add("iscasesensitive");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder baseentityname(String baseentityname) {
            this.baseentityname = baseentityname;
            this.changedFields = changedFields.add("baseentityname");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Duplicaterule build() {
            Duplicaterule _x = new Duplicaterule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.duplicaterule";
            _x.statuscode = statuscode;
            _x.modifiedon = modifiedon;
            _x._createdby_value = _createdby_value;
            _x.matchingentitymatchcodetable = matchingentitymatchcodetable;
            _x.matchingentitytypecode = matchingentitytypecode;
            _x._owninguser_value = _owninguser_value;
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.baseentitytypecode = baseentitytypecode;
            _x.excludeinactiverecords = excludeinactiverecords;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.matchingentityname = matchingentityname;
            _x.baseentitymatchcodetable = baseentitymatchcodetable;
            _x._modifiedby_value = _modifiedby_value;
            _x.duplicateruleid = duplicateruleid;
            _x._owningteam_value = _owningteam_value;
            _x._ownerid_value = _ownerid_value;
            _x.iscasesensitive = iscasesensitive;
            _x.description = description;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.baseentityname = baseentityname;
            _x.name = name;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && duplicateruleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(duplicateruleid.toString()));
        }
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Duplicaterule withStatuscode(Integer statuscode) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Duplicaterule withModifiedon(OffsetDateTime modifiedon) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Duplicaterule with_createdby_value(String _createdby_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="matchingentitymatchcodetable")
    @JsonIgnore
    public Optional<String> getMatchingentitymatchcodetable() {
        return Optional.ofNullable(matchingentitymatchcodetable);
    }

    public Duplicaterule withMatchingentitymatchcodetable(String matchingentitymatchcodetable) {
        Checks.checkIsAscii(matchingentitymatchcodetable);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("matchingentitymatchcodetable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.matchingentitymatchcodetable = matchingentitymatchcodetable;
        return _x;
    }

    @Property(name="matchingentitytypecode")
    @JsonIgnore
    public Optional<Integer> getMatchingentitytypecode() {
        return Optional.ofNullable(matchingentitytypecode);
    }

    public Duplicaterule withMatchingentitytypecode(Integer matchingentitytypecode) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("matchingentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.matchingentitytypecode = matchingentitytypecode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Duplicaterule with_owninguser_value(String _owninguser_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Duplicaterule withStatecode(Integer statecode) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Duplicaterule withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="baseentitytypecode")
    @JsonIgnore
    public Optional<Integer> getBaseentitytypecode() {
        return Optional.ofNullable(baseentitytypecode);
    }

    public Duplicaterule withBaseentitytypecode(Integer baseentitytypecode) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("baseentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.baseentitytypecode = baseentitytypecode;
        return _x;
    }

    @Property(name="excludeinactiverecords")
    @JsonIgnore
    public Optional<Boolean> getExcludeinactiverecords() {
        return Optional.ofNullable(excludeinactiverecords);
    }

    public Duplicaterule withExcludeinactiverecords(Boolean excludeinactiverecords) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("excludeinactiverecords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.excludeinactiverecords = excludeinactiverecords;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Duplicaterule with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Duplicaterule with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="matchingentityname")
    @JsonIgnore
    public Optional<String> getMatchingentityname() {
        return Optional.ofNullable(matchingentityname);
    }

    public Duplicaterule withMatchingentityname(String matchingentityname) {
        Checks.checkIsAscii(matchingentityname);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("matchingentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.matchingentityname = matchingentityname;
        return _x;
    }

    @Property(name="baseentitymatchcodetable")
    @JsonIgnore
    public Optional<String> getBaseentitymatchcodetable() {
        return Optional.ofNullable(baseentitymatchcodetable);
    }

    public Duplicaterule withBaseentitymatchcodetable(String baseentitymatchcodetable) {
        Checks.checkIsAscii(baseentitymatchcodetable);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("baseentitymatchcodetable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.baseentitymatchcodetable = baseentitymatchcodetable;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Duplicaterule with_modifiedby_value(String _modifiedby_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="duplicateruleid")
    @JsonIgnore
    public Optional<String> getDuplicateruleid() {
        return Optional.ofNullable(duplicateruleid);
    }

    public Duplicaterule withDuplicateruleid(String duplicateruleid) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("duplicateruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.duplicateruleid = duplicateruleid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Duplicaterule with_owningteam_value(String _owningteam_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Duplicaterule with_ownerid_value(String _ownerid_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="iscasesensitive")
    @JsonIgnore
    public Optional<Boolean> getIscasesensitive() {
        return Optional.ofNullable(iscasesensitive);
    }

    public Duplicaterule withIscasesensitive(Boolean iscasesensitive) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("iscasesensitive");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.iscasesensitive = iscasesensitive;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Duplicaterule withDescription(String description) {
        Checks.checkIsAscii(description);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.description = description;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Duplicaterule withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="baseentityname")
    @JsonIgnore
    public Optional<String> getBaseentityname() {
        return Optional.ofNullable(baseentityname);
    }

    public Duplicaterule withBaseentityname(String baseentityname) {
        Checks.checkIsAscii(baseentityname);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("baseentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.baseentityname = baseentityname;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Duplicaterule withName(String name) {
        Checks.checkIsAscii(name);
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.name = name;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Duplicaterule withCreatedon(OffsetDateTime createdon) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Duplicaterule with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Duplicaterule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    public Duplicaterule withUnmappedField(String name, String value) {
        Duplicaterule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="DuplicateRule_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getDuplicateRule_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("DuplicateRule_SyncErrors"), RequestHelper.getValue(unmappedFields, "DuplicateRule_SyncErrors"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="DuplicateRule_DuplicateRuleConditions")
    @JsonIgnore
    public DuplicateruleconditionCollectionRequest getDuplicateRule_DuplicateRuleConditions() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("DuplicateRule_DuplicateRuleConditions"), RequestHelper.getValue(unmappedFields, "DuplicateRule_DuplicateRuleConditions"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="DuplicateRule_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getDuplicateRule_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("DuplicateRule_Annotation"), RequestHelper.getValue(unmappedFields, "DuplicateRule_Annotation"));
    }

    @NavigationProperty(name="DuplicateRule_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getDuplicateRule_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("DuplicateRule_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "DuplicateRule_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Duplicaterule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Duplicaterule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Duplicaterule _copy() {
        Duplicaterule _x = new Duplicaterule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statuscode = statuscode;
        _x.modifiedon = modifiedon;
        _x._createdby_value = _createdby_value;
        _x.matchingentitymatchcodetable = matchingentitymatchcodetable;
        _x.matchingentitytypecode = matchingentitytypecode;
        _x._owninguser_value = _owninguser_value;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.baseentitytypecode = baseentitytypecode;
        _x.excludeinactiverecords = excludeinactiverecords;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.matchingentityname = matchingentityname;
        _x.baseentitymatchcodetable = baseentitymatchcodetable;
        _x._modifiedby_value = _modifiedby_value;
        _x.duplicateruleid = duplicateruleid;
        _x._owningteam_value = _owningteam_value;
        _x._ownerid_value = _ownerid_value;
        _x.iscasesensitive = iscasesensitive;
        _x.description = description;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.baseentityname = baseentityname;
        _x.name = name;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Action(name = "PublishDuplicateRule")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> publishDuplicateRule() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishDuplicateRule"), Asyncoperation.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Duplicaterule[");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("matchingentitymatchcodetable=");
        b.append(this.matchingentitymatchcodetable);
        b.append(", ");
        b.append("matchingentitytypecode=");
        b.append(this.matchingentitytypecode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("baseentitytypecode=");
        b.append(this.baseentitytypecode);
        b.append(", ");
        b.append("excludeinactiverecords=");
        b.append(this.excludeinactiverecords);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("matchingentityname=");
        b.append(this.matchingentityname);
        b.append(", ");
        b.append("baseentitymatchcodetable=");
        b.append(this.baseentitymatchcodetable);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("duplicateruleid=");
        b.append(this.duplicateruleid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("iscasesensitive=");
        b.append(this.iscasesensitive);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("baseentityname=");
        b.append(this.baseentityname);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
