package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ValidationSuccess", 
    "TraceInfo", 
    "ActivityId"})
@JsonInclude(Include.NON_NULL)
public class ValidationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidationSuccess")
    protected Boolean validationSuccess;

    @JsonProperty("TraceInfo")
    protected TraceInfo traceInfo;

    @JsonProperty("ActivityId")
    protected String activityId;

    protected ValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidationResult";
    }

    @Property(name="ValidationSuccess")
    @JsonIgnore
    public Optional<Boolean> getValidationSuccess() {
        return Optional.ofNullable(validationSuccess);
    }

    public ValidationResult withValidationSuccess(Boolean validationSuccess) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidationResult");
        _x.validationSuccess = validationSuccess;
        return _x;
    }

    @Property(name="TraceInfo")
    @JsonIgnore
    public Optional<TraceInfo> getTraceInfo() {
        return Optional.ofNullable(traceInfo);
    }

    public ValidationResult withTraceInfo(TraceInfo traceInfo) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidationResult");
        _x.traceInfo = traceInfo;
        return _x;
    }

    @Property(name="ActivityId")
    @JsonIgnore
    public Optional<String> getActivityId() {
        return Optional.ofNullable(activityId);
    }

    public ValidationResult withActivityId(String activityId) {
        ValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidationResult");
        _x.activityId = activityId;
        return _x;
    }

    public ValidationResult withUnmappedField(String name, String value) {
        ValidationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean validationSuccess;
        private TraceInfo traceInfo;
        private String activityId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder validationSuccess(Boolean validationSuccess) {
            this.validationSuccess = validationSuccess;
            this.changedFields = changedFields.add("ValidationSuccess");
            return this;
        }

        public Builder traceInfo(TraceInfo traceInfo) {
            this.traceInfo = traceInfo;
            this.changedFields = changedFields.add("TraceInfo");
            return this;
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            this.changedFields = changedFields.add("ActivityId");
            return this;
        }

        public ValidationResult build() {
            ValidationResult _x = new ValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidationResult";
            _x.validationSuccess = validationSuccess;
            _x.traceInfo = traceInfo;
            _x.activityId = activityId;
            return _x;
        }
    }

    private ValidationResult _copy() {
        ValidationResult _x = new ValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.validationSuccess = validationSuccess;
        _x.traceInfo = traceInfo;
        _x.activityId = activityId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidationResult[");
        b.append("ValidationSuccess=");
        b.append(this.validationSuccess);
        b.append(", ");
        b.append("TraceInfo=");
        b.append(this.traceInfo);
        b.append(", ");
        b.append("ActivityId=");
        b.append(this.activityId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
