package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "countOfPhrases"})
@JsonInclude(Include.NON_NULL)
public class ExtractKeyPhrasesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("countOfPhrases")
    protected BigDecimal countOfPhrases;

    protected ExtractKeyPhrasesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ExtractKeyPhrasesResponse";
    }

    @Property(name="countOfPhrases")
    @JsonIgnore
    public Optional<BigDecimal> getCountOfPhrases() {
        return Optional.ofNullable(countOfPhrases);
    }

    public ExtractKeyPhrasesResponse withCountOfPhrases(BigDecimal countOfPhrases) {
        ExtractKeyPhrasesResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ExtractKeyPhrasesResponse");
        _x.countOfPhrases = countOfPhrases;
        return _x;
    }

    public ExtractKeyPhrasesResponse withUnmappedField(String name, String value) {
        ExtractKeyPhrasesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BigDecimal countOfPhrases;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder countOfPhrases(BigDecimal countOfPhrases) {
            this.countOfPhrases = countOfPhrases;
            this.changedFields = changedFields.add("countOfPhrases");
            return this;
        }

        public ExtractKeyPhrasesResponse build() {
            ExtractKeyPhrasesResponse _x = new ExtractKeyPhrasesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ExtractKeyPhrasesResponse";
            _x.countOfPhrases = countOfPhrases;
            return _x;
        }
    }

    private ExtractKeyPhrasesResponse _copy() {
        ExtractKeyPhrasesResponse _x = new ExtractKeyPhrasesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.countOfPhrases = countOfPhrases;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractKeyPhrasesResponse[");
        b.append("countOfPhrases=");
        b.append(this.countOfPhrases);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
