package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Name", 
    "Value", 
    "DataType"})
@JsonInclude(Include.NON_NULL)
public class AppSettingDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Value")
    protected String value;

    @JsonProperty("DataType")
    protected Integer dataType;

    protected AppSettingDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppSettingDetails";
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AppSettingDetails withName(String name) {
        Checks.checkIsAscii(name);
        AppSettingDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetails");
        _x.name = name;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public AppSettingDetails withValue(String value) {
        Checks.checkIsAscii(value);
        AppSettingDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetails");
        _x.value = value;
        return _x;
    }

    @Property(name="DataType")
    @JsonIgnore
    public Optional<Integer> getDataType() {
        return Optional.ofNullable(dataType);
    }

    public AppSettingDetails withDataType(Integer dataType) {
        AppSettingDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppSettingDetails");
        _x.dataType = dataType;
        return _x;
    }

    public AppSettingDetails withUnmappedField(String name, String value) {
        AppSettingDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String value;
        private Integer dataType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder dataType(Integer dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("DataType");
            return this;
        }

        public AppSettingDetails build() {
            AppSettingDetails _x = new AppSettingDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppSettingDetails";
            _x.name = name;
            _x.value = value;
            _x.dataType = dataType;
            return _x;
        }
    }

    private AppSettingDetails _copy() {
        AppSettingDetails _x = new AppSettingDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.value = value;
        _x.dataType = dataType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppSettingDetails[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("DataType=");
        b.append(this.dataType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
