/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ColumnSet;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.OrderExpression;
import microsoft.dynamics.crm.complex.PagingInfo;
import microsoft.dynamics.crm.complex.QueryBase;

@JsonPropertyOrder(value={"@odata.type", "EntityName", "Attributes", "Values", "PageInfo", "ColumnSet", "Orders", "TopCount"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueryByAttribute
extends QueryBase
implements ODataType {
    @JsonProperty(value="EntityName")
    protected String entityName;
    @JsonProperty(value="Attributes")
    protected List<String> attributes;
    @JsonProperty(value="Attributes@nextLink")
    protected String attributesNextLink;
    @JsonProperty(value="Values")
    protected List<Object> values;
    @JsonProperty(value="Values@nextLink")
    protected String valuesNextLink;
    @JsonProperty(value="PageInfo")
    protected PagingInfo pageInfo;
    @JsonProperty(value="ColumnSet")
    protected ColumnSet columnSet;
    @JsonProperty(value="Orders")
    protected List<OrderExpression> orders;
    @JsonProperty(value="Orders@nextLink")
    protected String ordersNextLink;
    @JsonProperty(value="TopCount")
    protected Integer topCount;

    protected QueryByAttribute() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryByAttribute";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public QueryByAttribute withEntityName(String entityName) {
        Checks.checkIsAscii((String)entityName);
        QueryByAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes() {
        return new CollectionPage(this.contextPath, String.class, this.attributes, Optional.ofNullable(this.attributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.attributes, Optional.ofNullable(this.attributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues() {
        return new CollectionPage(this.contextPath, Object.class, this.values, Optional.ofNullable(this.valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, Object.class, this.values, Optional.ofNullable(this.valuesNextLink), Collections.emptyList(), options);
    }

    @Property(name="PageInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPageInfo() {
        return Optional.ofNullable(this.pageInfo);
    }

    public QueryByAttribute withPageInfo(PagingInfo pageInfo) {
        QueryByAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.pageInfo = pageInfo;
        return _x;
    }

    @Property(name="ColumnSet")
    @JsonIgnore
    public Optional<ColumnSet> getColumnSet() {
        return Optional.ofNullable(this.columnSet);
    }

    public QueryByAttribute withColumnSet(ColumnSet columnSet) {
        QueryByAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.columnSet = columnSet;
        return _x;
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders() {
        return new CollectionPage(this.contextPath, OrderExpression.class, this.orders, Optional.ofNullable(this.ordersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, OrderExpression.class, this.orders, Optional.ofNullable(this.ordersNextLink), Collections.emptyList(), options);
    }

    @Property(name="TopCount")
    @JsonIgnore
    public Optional<Integer> getTopCount() {
        return Optional.ofNullable(this.topCount);
    }

    public QueryByAttribute withTopCount(Integer topCount) {
        QueryByAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryByAttribute");
        _x.topCount = topCount;
        return _x;
    }

    @Override
    public QueryByAttribute withUnmappedField(String name, String value) {
        QueryByAttribute _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, java.lang.Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builderQueryByAttribute() {
        return new Builder();
    }

    private QueryByAttribute _copy() {
        QueryByAttribute _x = new QueryByAttribute();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityName = this.entityName;
        _x.attributes = this.attributes;
        _x.values = this.values;
        _x.pageInfo = this.pageInfo;
        _x.columnSet = this.columnSet;
        _x.orders = this.orders;
        _x.topCount = this.topCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryByAttribute[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append(", ");
        b.append("PageInfo=");
        b.append(this.pageInfo);
        b.append(", ");
        b.append("ColumnSet=");
        b.append(this.columnSet);
        b.append(", ");
        b.append("Orders=");
        b.append(this.orders);
        b.append(", ");
        b.append("TopCount=");
        b.append(this.topCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityName;
        private List<String> attributes;
        private String attributesNextLink;
        private List<Object> values;
        private String valuesNextLink;
        private PagingInfo pageInfo;
        private ColumnSet columnSet;
        private List<OrderExpression> orders;
        private String ordersNextLink;
        private Integer topCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public Builder attributes(List<String> attributes) {
            this.attributes = attributes;
            this.changedFields = this.changedFields.add("Attributes");
            return this;
        }

        public Builder attributes(String ... attributes) {
            return this.attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = this.changedFields.add("Attributes");
            return this;
        }

        public Builder values(List<Object> values) {
            this.values = values;
            this.changedFields = this.changedFields.add("Values");
            return this;
        }

        public Builder values(Object ... values) {
            return this.values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = this.changedFields.add("Values");
            return this;
        }

        public Builder pageInfo(PagingInfo pageInfo) {
            this.pageInfo = pageInfo;
            this.changedFields = this.changedFields.add("PageInfo");
            return this;
        }

        public Builder columnSet(ColumnSet columnSet) {
            this.columnSet = columnSet;
            this.changedFields = this.changedFields.add("ColumnSet");
            return this;
        }

        public Builder orders(List<OrderExpression> orders) {
            this.orders = orders;
            this.changedFields = this.changedFields.add("Orders");
            return this;
        }

        public Builder orders(OrderExpression ... orders) {
            return this.orders(Arrays.asList(orders));
        }

        public Builder ordersNextLink(String ordersNextLink) {
            this.ordersNextLink = ordersNextLink;
            this.changedFields = this.changedFields.add("Orders");
            return this;
        }

        public Builder topCount(Integer topCount) {
            this.topCount = topCount;
            this.changedFields = this.changedFields.add("TopCount");
            return this;
        }

        public QueryByAttribute build() {
            QueryByAttribute _x = new QueryByAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryByAttribute";
            _x.entityName = this.entityName;
            _x.attributes = this.attributes;
            _x.attributesNextLink = this.attributesNextLink;
            _x.values = this.values;
            _x.valuesNextLink = this.valuesNextLink;
            _x.pageInfo = this.pageInfo;
            _x.columnSet = this.columnSet;
            _x.orders = this.orders;
            _x.ordersNextLink = this.ordersNextLink;
            _x.topCount = this.topCount;
            return _x;
        }
    }
}

