/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.DependentOptionMetadata;
import microsoft.dynamics.crm.complex.DependentOptionMetadataCollection;

@JsonPropertyOrder(value={"@odata.type", "Name", "Type", "TrueOption", "FalseOption", "Options"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DependentOptionSetMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Name")
    protected String name;
    @JsonProperty(value="Type")
    protected String type;
    @JsonProperty(value="TrueOption")
    protected DependentOptionMetadata trueOption;
    @JsonProperty(value="FalseOption")
    protected DependentOptionMetadata falseOption;
    @JsonProperty(value="Options")
    protected DependentOptionMetadataCollection options;

    protected DependentOptionSetMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentOptionSetMetadata";
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public DependentOptionSetMetadata withName(String name) {
        Checks.checkIsAscii((String)name);
        DependentOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public DependentOptionSetMetadata withType(String type) {
        Checks.checkIsAscii((String)type);
        DependentOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.type = type;
        return _x;
    }

    @Property(name="TrueOption")
    @JsonIgnore
    public Optional<DependentOptionMetadata> getTrueOption() {
        return Optional.ofNullable(this.trueOption);
    }

    public DependentOptionSetMetadata withTrueOption(DependentOptionMetadata trueOption) {
        DependentOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.trueOption = trueOption;
        return _x;
    }

    @Property(name="FalseOption")
    @JsonIgnore
    public Optional<DependentOptionMetadata> getFalseOption() {
        return Optional.ofNullable(this.falseOption);
    }

    public DependentOptionSetMetadata withFalseOption(DependentOptionMetadata falseOption) {
        DependentOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.falseOption = falseOption;
        return _x;
    }

    @Property(name="Options")
    @JsonIgnore
    public Optional<DependentOptionMetadataCollection> getOptions() {
        return Optional.ofNullable(this.options);
    }

    public DependentOptionSetMetadata withOptions(DependentOptionMetadataCollection options) {
        DependentOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.options = options;
        return _x;
    }

    public DependentOptionSetMetadata withUnmappedField(String name, String value) {
        DependentOptionSetMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private DependentOptionSetMetadata _copy() {
        DependentOptionSetMetadata _x = new DependentOptionSetMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.name = this.name;
        _x.type = this.type;
        _x.trueOption = this.trueOption;
        _x.falseOption = this.falseOption;
        _x.options = this.options;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentOptionSetMetadata[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("TrueOption=");
        b.append(this.trueOption);
        b.append(", ");
        b.append("FalseOption=");
        b.append(this.falseOption);
        b.append(", ");
        b.append("Options=");
        b.append(this.options);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String name;
        private String type;
        private DependentOptionMetadata trueOption;
        private DependentOptionMetadata falseOption;
        private DependentOptionMetadataCollection options;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = this.changedFields.add("Type");
            return this;
        }

        public Builder trueOption(DependentOptionMetadata trueOption) {
            this.trueOption = trueOption;
            this.changedFields = this.changedFields.add("TrueOption");
            return this;
        }

        public Builder falseOption(DependentOptionMetadata falseOption) {
            this.falseOption = falseOption;
            this.changedFields = this.changedFields.add("FalseOption");
            return this;
        }

        public Builder options(DependentOptionMetadataCollection options) {
            this.options = options;
            this.changedFields = this.changedFields.add("Options");
            return this;
        }

        public DependentOptionSetMetadata build() {
            DependentOptionSetMetadata _x = new DependentOptionSetMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentOptionSetMetadata";
            _x.name = this.name;
            _x.type = this.type;
            _x.trueOption = this.trueOption;
            _x.falseOption = this.falseOption;
            _x.options = this.options;
            return _x;
        }
    }
}

