/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AuditDetail;

@JsonPropertyOrder(value={"@odata.type", "RelationshipName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RelationshipAuditDetail
extends AuditDetail
implements ODataType {
    @JsonProperty(value="RelationshipName")
    protected String relationshipName;

    protected RelationshipAuditDetail() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RelationshipAuditDetail";
    }

    @Property(name="RelationshipName")
    @JsonIgnore
    public Optional<String> getRelationshipName() {
        return Optional.ofNullable(this.relationshipName);
    }

    public RelationshipAuditDetail withRelationshipName(String relationshipName) {
        Checks.checkIsAscii((String)relationshipName);
        RelationshipAuditDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipAuditDetail");
        _x.relationshipName = relationshipName;
        return _x;
    }

    @Override
    public RelationshipAuditDetail withUnmappedField(String name, String value) {
        RelationshipAuditDetail _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builderRelationshipAuditDetail() {
        return new Builder();
    }

    private RelationshipAuditDetail _copy() {
        RelationshipAuditDetail _x = new RelationshipAuditDetail();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.relationshipName = this.relationshipName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelationshipAuditDetail[");
        b.append("RelationshipName=");
        b.append(this.relationshipName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String relationshipName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder relationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            this.changedFields = this.changedFields.add("RelationshipName");
            return this;
        }

        public RelationshipAuditDetail build() {
            RelationshipAuditDetail _x = new RelationshipAuditDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RelationshipAuditDetail";
            _x.relationshipName = this.relationshipName;
            return _x;
        }
    }
}

