package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Processsession;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class ProcesssessionRequest extends EntityRequest<Processsession> {

    public ProcesssessionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Processsession.class, contextPath, value);
    }

    public ThemeRequest regardingobjectid_theme() {
        return new ThemeRequest(contextPath.addSegment("regardingobjectid_theme"), Optional.empty());
    }

    public UsermappingRequest regardingobjectid_usermapping() {
        return new UsermappingRequest(contextPath.addSegment("regardingobjectid_usermapping"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public PositionRequest regardingobjectid_position() {
        return new PositionRequest(contextPath.addSegment("regardingobjectid_position"), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord"), Optional.empty());
    }

    public QueueRequest regardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), Optional.empty());
    }

    public SystemuserRequest canceledby() {
        return new SystemuserRequest(contextPath.addSegment("canceledby"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_processsession() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_processsession"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_processsession(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_processsession").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_processsession_childworkflow() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_processsession_childworkflow"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_processsession_childworkflow(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_processsession_childworkflow").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public KbarticletemplateRequest regardingobjectid_kbarticletemplate() {
        return new KbarticletemplateRequest(contextPath.addSegment("regardingobjectid_kbarticletemplate"), Optional.empty());
    }

    public QueueitemRequest regardingobjectid_queueitem() {
        return new QueueitemRequest(contextPath.addSegment("regardingobjectid_queueitem"), Optional.empty());
    }

    public ExpiredprocessRequest regardingobjectid_expiredprocess() {
        return new ExpiredprocessRequest(contextPath.addSegment("regardingobjectid_expiredprocess"), Optional.empty());
    }

    public SystemuserRequest regardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), Optional.empty());
    }

    public ReportRequest regardingobjectid_report() {
        return new ReportRequest(contextPath.addSegment("regardingobjectid_report"), Optional.empty());
    }

    public ProcesssessionRequest previouslinkedsessionid() {
        return new ProcesssessionRequest(contextPath.addSegment("previouslinkedsessionid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_previouslinkedsessionid() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_previouslinkedsessionid"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_previouslinkedsessionid(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_previouslinkedsessionid").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionRequest nextlinkedsessionid() {
        return new ProcesssessionRequest(contextPath.addSegment("nextlinkedsessionid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_nextlinkedsessionid() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_nextlinkedsessionid"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_nextlinkedsessionid(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_nextlinkedsessionid").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionRequest originatingsessionid() {
        return new ProcesssessionRequest(contextPath.addSegment("originatingsessionid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_originatingsessionid() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_originatingsessionid"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_originatingsessionid(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_originatingsessionid").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public LetterRequest regardingobjectid_letter() {
        return new LetterRequest(contextPath.addSegment("regardingobjectid_letter"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public TransactioncurrencyRequest regardingobjectid_transactioncurrency() {
        return new TransactioncurrencyRequest(contextPath.addSegment("regardingobjectid_transactioncurrency"), Optional.empty());
    }

    public SharepointsiteRequest regardingobjectid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("regardingobjectid_sharepointsite"), Optional.empty());
    }

    public SubjectRequest regardingobjectid_subject() {
        return new SubjectRequest(contextPath.addSegment("regardingobjectid_subject"), Optional.empty());
    }

    public RollupfieldRequest regardingobjectid_rollupfield() {
        return new RollupfieldRequest(contextPath.addSegment("regardingobjectid_rollupfield"), Optional.empty());
    }

    public SyncerrorCollectionRequest processSession_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ProcessSession_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest processSession_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ProcessSession_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SocialactivityRequest regardingobjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regardingobjectid_socialactivity"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public ConnectionroleRequest regardingobjectid_connectionrole() {
        return new ConnectionroleRequest(contextPath.addSegment("regardingobjectid_connectionrole"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SlaRequest regardingobjectid_sla() {
        return new SlaRequest(contextPath.addSegment("regardingobjectid_sla"), Optional.empty());
    }

    public CustomeraddressRequest regardingobjectid_customeraddress() {
        return new CustomeraddressRequest(contextPath.addSegment("regardingobjectid_customeraddress"), Optional.empty());
    }

    public KbarticleRequest regardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), Optional.empty());
    }

    public NewprocessRequest regardingobjectid_newprocess() {
        return new NewprocessRequest(contextPath.addSegment("regardingobjectid_newprocess"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest executedby() {
        return new SystemuserRequest(contextPath.addSegment("executedby"), Optional.empty());
    }

    public BusinessunitRequest regardingobjectid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectid_businessunit"), Optional.empty());
    }

    public ConnectionCollectionRequest processsession_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("processsession_connections1"), Optional.empty());
    }

    public ConnectionRequest processsession_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("processsession_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public MailmergetemplateRequest regardingobjectid_mailmergetemplate() {
        return new MailmergetemplateRequest(contextPath.addSegment("regardingobjectid_mailmergetemplate"), Optional.empty());
    }

    public ConnectionRequest regardingobjectid_connection() {
        return new ConnectionRequest(contextPath.addSegment("regardingobjectid_connection"), Optional.empty());
    }

    public MetricRequest regardingobjectid_metric() {
        return new MetricRequest(contextPath.addSegment("regardingobjectid_metric"), Optional.empty());
    }

    public PhonecallRequest regardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), Optional.empty());
    }

    public TemplateRequest regardingobjectid_template() {
        return new TemplateRequest(contextPath.addSegment("regardingobjectid_template"), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public EmailRequest regardingobjectid_email() {
        return new EmailRequest(contextPath.addSegment("regardingobjectid_email"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public FaxRequest regardingobjectid_fax() {
        return new FaxRequest(contextPath.addSegment("regardingobjectid_fax"), Optional.empty());
    }

    public TaskRequest regardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public PostfollowCollectionRequest processsession_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("processsession_PostFollows"), Optional.empty());
    }

    public PostfollowRequest processsession_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("processsession_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public TeamRequest regardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), Optional.empty());
    }

    public AnnotationRequest regardingobjectid_annotation() {
        return new AnnotationRequest(contextPath.addSegment("regardingobjectid_annotation"), Optional.empty());
    }

    public AppointmentRequest regardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), Optional.empty());
    }

    public SystemuserRequest startedby() {
        return new SystemuserRequest(contextPath.addSegment("startedby"), Optional.empty());
    }

    public ConnectionCollectionRequest processsession_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("processsession_connections2"), Optional.empty());
    }

    public ConnectionRequest processsession_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("processsession_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public BusinessunitnewsarticleRequest regardingobjectid_businessunitnewsarticle() {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("regardingobjectid_businessunitnewsarticle"), Optional.empty());
    }

    public KbarticlecommentRequest regardingobjectid_kbarticlecomment() {
        return new KbarticlecommentRequest(contextPath.addSegment("regardingobjectid_kbarticlecomment"), Optional.empty());
    }

    public SocialprofileRequest regardingobjectid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("regardingobjectid_socialprofile"), Optional.empty());
    }

    public SharepointdocumentlocationRequest regardingobjectid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("regardingobjectid_sharepointdocumentlocation"), Optional.empty());
    }

    public GoalrollupqueryRequest regardingobjectid_goalrollupquery() {
        return new GoalrollupqueryRequest(contextPath.addSegment("regardingobjectid_goalrollupquery"), Optional.empty());
    }

    public PostregardingCollectionRequest processsession_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("processsession_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest processsession_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("processsession_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public GoalRequest regardingobjectid_goal() {
        return new GoalRequest(contextPath.addSegment("regardingobjectid_goal"), Optional.empty());
    }

    public TranslationprocessRequest regardingobjectid_translationprocess() {
        return new TranslationprocessRequest(contextPath.addSegment("regardingobjectid_translationprocess"), Optional.empty());
    }

    public MailboxRequest regardingobjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("regardingobjectid_mailbox"), Optional.empty());
    }

    public RecurringappointmentmasterRequest regardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest completedby() {
        return new SystemuserRequest(contextPath.addSegment("completedby"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest regardingobjectid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentattributeconfiguration"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest regardingobjectid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentconfiguration"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest regardingobjectid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentrelationshipconfiguration"), Optional.empty());
    }

    public StagesolutionuploadRequest regardingobjectid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("regardingobjectid_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest regardingobjectid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("regardingobjectid_exportsolutionupload"), Optional.empty());
    }

    public DatalakeworkspaceRequest regardingobjectid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("regardingobjectid_datalakeworkspace"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest regardingobjectid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("regardingobjectid_datalakeworkspacepermission"), Optional.empty());
    }

    public ApplicationuserRequest regardingobjectid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("regardingobjectid_applicationuser"), Optional.empty());
    }

    public ServiceplanRequest regardingobjectid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("regardingobjectid_serviceplan"), Optional.empty());
    }

    public ConnectorRequest regardingobjectid_connector() {
        return new ConnectorRequest(contextPath.addSegment("regardingobjectid_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest regardingobjectid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("regardingobjectid_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest regardingobjectid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("regardingobjectid_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest regardingobjectid_processstageparameter() {
        return new ProcessstageparameterRequest(contextPath.addSegment("regardingobjectid_processstageparameter"), Optional.empty());
    }

    public WorkflowbinaryRequest regardingobjectid_workflowbinary() {
        return new WorkflowbinaryRequest(contextPath.addSegment("regardingobjectid_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest regardingobjectid_connectionreference() {
        return new ConnectionreferenceRequest(contextPath.addSegment("regardingobjectid_connectionreference"), Optional.empty());
    }

    public Msdyn_helppageRequest regardingobjectid_msdyn_helppage() {
        return new Msdyn_helppageRequest(contextPath.addSegment("regardingobjectid_msdyn_helppage"), Optional.empty());
    }

    public TerritoryRequest regardingobjectid_territory() {
        return new TerritoryRequest(contextPath.addSegment("regardingobjectid_territory"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest regardingobjectid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest regardingobjectid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("regardingobjectid_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest regardingobjectid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest regardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest regardingobjectid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("regardingobjectid_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest regardingobjectid_msdyn_richtextfile() {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("regardingobjectid_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest regardingobjectid_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest regardingobjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("regardingobjectid_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest regardingobjectid_msdyn_aitemplate() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest regardingobjectid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest regardingobjectid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest regardingobjectid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest regardingobjectid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest regardingobjectid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest regardingobjectid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest regardingobjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("regardingobjectid_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest regardingobjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest regardingobjectid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest regardingobjectid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest regardingobjectid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest regardingobjectid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("regardingobjectid_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest regardingobjectid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest regardingobjectid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest regardingobjectid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest regardingobjectid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest regardingobjectid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest regardingobjectid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleset"), Optional.empty());
    }

    public Ggw_eventRequest regardingobjectid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("regardingobjectid_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest regardingobjectid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("regardingobjectid_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest regardingobjectid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("regardingobjectid_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest regardingobjectid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("regardingobjectid_ggw_team_application"), Optional.empty());
    }

    public CascadegrantrevokeaccessrecordstrackerRequest regardingobjectid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessrecordstracker"), Optional.empty());
    }

    public CascadegrantrevokeaccessversiontrackerRequest regardingobjectid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessversiontracker"), Optional.empty());
    }

}
