package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Bulkdeleteoperation;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;

@JsonIgnoreType
public class BulkdeleteoperationRequest extends EntityRequest<Bulkdeleteoperation> {

    public BulkdeleteoperationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Bulkdeleteoperation.class, contextPath, value);
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public AsyncoperationRequest asyncoperationid() {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperationid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest bulkDeleteOperation_BulkDeleteFailure() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure"), Optional.empty());
    }

    public BulkdeletefailureRequest bulkDeleteOperation_BulkDeleteFailure(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
