package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SubjectCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "importsequencenumber", 
    "description", 
    "createdon", 
    "_modifiedbyexternalparty_value", 
    "_parentsubject_value", 
    "_organizationid_value", 
    "_createdbyexternalparty_value", 
    "versionnumber", 
    "_modifiedby_value", 
    "subjectid", 
    "_createdonbehalfby_value", 
    "title", 
    "modifiedon", 
    "featuremask", 
    "_modifiedonbehalfby_value", 
    "overriddencreatedon", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Subject extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.subject";
    }

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedbyexternalparty_value")
    protected String _modifiedbyexternalparty_value;

    @JsonProperty("_parentsubject_value")
    protected String _parentsubject_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdbyexternalparty_value")
    protected String _createdbyexternalparty_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("subjectid")
    protected String subjectid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("featuremask")
    protected Integer featuremask;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Subject() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubject() {
        return new Builder();
    }

    public static final class Builder {
        private Integer importsequencenumber;
        private String description;
        private OffsetDateTime createdon;
        private String _modifiedbyexternalparty_value;
        private String _parentsubject_value;
        private String _organizationid_value;
        private String _createdbyexternalparty_value;
        private Long versionnumber;
        private String _modifiedby_value;
        private String subjectid;
        private String _createdonbehalfby_value;
        private String title;
        private OffsetDateTime modifiedon;
        private Integer featuremask;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime overriddencreatedon;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedbyexternalparty_value(String _modifiedbyexternalparty_value) {
            this._modifiedbyexternalparty_value = _modifiedbyexternalparty_value;
            this.changedFields = changedFields.add("_modifiedbyexternalparty_value");
            return this;
        }

        public Builder _parentsubject_value(String _parentsubject_value) {
            this._parentsubject_value = _parentsubject_value;
            this.changedFields = changedFields.add("_parentsubject_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdbyexternalparty_value(String _createdbyexternalparty_value) {
            this._createdbyexternalparty_value = _createdbyexternalparty_value;
            this.changedFields = changedFields.add("_createdbyexternalparty_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder subjectid(String subjectid) {
            this.subjectid = subjectid;
            this.changedFields = changedFields.add("subjectid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder featuremask(Integer featuremask) {
            this.featuremask = featuremask;
            this.changedFields = changedFields.add("featuremask");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Subject build() {
            Subject _x = new Subject();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.subject";
            _x.importsequencenumber = importsequencenumber;
            _x.description = description;
            _x.createdon = createdon;
            _x._modifiedbyexternalparty_value = _modifiedbyexternalparty_value;
            _x._parentsubject_value = _parentsubject_value;
            _x._organizationid_value = _organizationid_value;
            _x._createdbyexternalparty_value = _createdbyexternalparty_value;
            _x.versionnumber = versionnumber;
            _x._modifiedby_value = _modifiedby_value;
            _x.subjectid = subjectid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.title = title;
            _x.modifiedon = modifiedon;
            _x.featuremask = featuremask;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && subjectid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(subjectid.toString()));
        }
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Subject withImportsequencenumber(Integer importsequencenumber) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Subject withDescription(String description) {
        Checks.checkIsAscii(description);
        Subject _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.description = description;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Subject withCreatedon(OffsetDateTime createdon) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedbyexternalparty_value")
    @JsonIgnore
    public Optional<String> get_modifiedbyexternalparty_value() {
        return Optional.ofNullable(_modifiedbyexternalparty_value);
    }

    public Subject with_modifiedbyexternalparty_value(String _modifiedbyexternalparty_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_modifiedbyexternalparty_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._modifiedbyexternalparty_value = _modifiedbyexternalparty_value;
        return _x;
    }

    @Property(name="_parentsubject_value")
    @JsonIgnore
    public Optional<String> get_parentsubject_value() {
        return Optional.ofNullable(_parentsubject_value);
    }

    public Subject with_parentsubject_value(String _parentsubject_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_parentsubject_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._parentsubject_value = _parentsubject_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Subject with_organizationid_value(String _organizationid_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdbyexternalparty_value")
    @JsonIgnore
    public Optional<String> get_createdbyexternalparty_value() {
        return Optional.ofNullable(_createdbyexternalparty_value);
    }

    public Subject with_createdbyexternalparty_value(String _createdbyexternalparty_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_createdbyexternalparty_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._createdbyexternalparty_value = _createdbyexternalparty_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Subject withVersionnumber(Long versionnumber) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Subject with_modifiedby_value(String _modifiedby_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="subjectid")
    @JsonIgnore
    public Optional<String> getSubjectid() {
        return Optional.ofNullable(subjectid);
    }

    public Subject withSubjectid(String subjectid) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("subjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.subjectid = subjectid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Subject with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Subject withTitle(String title) {
        Checks.checkIsAscii(title);
        Subject _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.title = title;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Subject withModifiedon(OffsetDateTime modifiedon) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="featuremask")
    @JsonIgnore
    public Optional<Integer> getFeaturemask() {
        return Optional.ofNullable(featuremask);
    }

    public Subject withFeaturemask(Integer featuremask) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("featuremask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.featuremask = featuremask;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Subject with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Subject withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Subject with_createdby_value(String _createdby_value) {
        Subject _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subject");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Subject withUnmappedField(String name, String value) {
        Subject _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Subject_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSubject_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Subject_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Subject_ProcessSessions"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="parentsubject")
    @JsonIgnore
    public SubjectRequest getParentsubject() {
        return new SubjectRequest(contextPath.addSegment("parentsubject"), RequestHelper.getValue(unmappedFields, "parentsubject"));
    }

    @NavigationProperty(name="subject_parent_subject")
    @JsonIgnore
    public SubjectCollectionRequest getSubject_parent_subject() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("subject_parent_subject"), RequestHelper.getValue(unmappedFields, "subject_parent_subject"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="Subject_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSubject_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Subject_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Subject_AsyncOperations"));
    }

    @NavigationProperty(name="Subject_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSubject_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Subject_SyncErrors"), RequestHelper.getValue(unmappedFields, "Subject_SyncErrors"));
    }

    @NavigationProperty(name="subject_kb_articles")
    @JsonIgnore
    public KbarticleCollectionRequest getSubject_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("subject_kb_articles"), RequestHelper.getValue(unmappedFields, "subject_kb_articles"));
    }

    @NavigationProperty(name="subject_knowledgearticles")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getSubject_knowledgearticles() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("subject_knowledgearticles"), RequestHelper.getValue(unmappedFields, "subject_knowledgearticles"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="Subject_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getSubject_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Subject_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Subject_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_subject_knowledgearticletemplate_subjectid")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateCollectionRequest getMsdyn_subject_knowledgearticletemplate_subjectid() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("msdyn_subject_knowledgearticletemplate_subjectid"), RequestHelper.getValue(unmappedFields, "msdyn_subject_knowledgearticletemplate_subjectid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subject patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subject put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subject _copy() {
        Subject _x = new Subject();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.importsequencenumber = importsequencenumber;
        _x.description = description;
        _x.createdon = createdon;
        _x._modifiedbyexternalparty_value = _modifiedbyexternalparty_value;
        _x._parentsubject_value = _parentsubject_value;
        _x._organizationid_value = _organizationid_value;
        _x._createdbyexternalparty_value = _createdbyexternalparty_value;
        _x.versionnumber = versionnumber;
        _x._modifiedby_value = _modifiedby_value;
        _x.subjectid = subjectid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.title = title;
        _x.modifiedon = modifiedon;
        _x.featuremask = featuremask;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Function(name = "RetrieveByTopIncidentSubjectKbArticle")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Kbarticle> retrieveByTopIncidentSubjectKbArticle() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveByTopIncidentSubjectKbArticle"), Kbarticle.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subject[");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedbyexternalparty_value=");
        b.append(this._modifiedbyexternalparty_value);
        b.append(", ");
        b.append("_parentsubject_value=");
        b.append(this._parentsubject_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdbyexternalparty_value=");
        b.append(this._createdbyexternalparty_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("subjectid=");
        b.append(this.subjectid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("featuremask=");
        b.append(this.featuremask);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
