package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "name", 
    "statecode", 
    "processstageparameterid", 
    "statuscode", 
    "_owninguser_value", 
    "_processstageid_value", 
    "_createdonbehalfby_value", 
    "utcconversiontimezonecode", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "createdon", 
    "_owningteam_value", 
    "versionnumber", 
    "overriddencreatedon", 
    "importsequencenumber", 
    "value", 
    "modifiedon", 
    "_ownerid_value", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Processstageparameter extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.processstageparameter";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("processstageparameterid")
    protected String processstageparameterid;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_processstageid_value")
    protected String _processstageid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("value")
    protected String value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Processstageparameter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProcessstageparameter() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private String name;
        private Integer statecode;
        private String processstageparameterid;
        private Integer statuscode;
        private String _owninguser_value;
        private String _processstageid_value;
        private String _createdonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private String _modifiedby_value;
        private String _owningbusinessunit_value;
        private OffsetDateTime createdon;
        private String _owningteam_value;
        private Long versionnumber;
        private OffsetDateTime overriddencreatedon;
        private Integer importsequencenumber;
        private String value;
        private OffsetDateTime modifiedon;
        private String _ownerid_value;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder processstageparameterid(String processstageparameterid) {
            this.processstageparameterid = processstageparameterid;
            this.changedFields = changedFields.add("processstageparameterid");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _processstageid_value(String _processstageid_value) {
            this._processstageid_value = _processstageid_value;
            this.changedFields = changedFields.add("_processstageid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Processstageparameter build() {
            Processstageparameter _x = new Processstageparameter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.processstageparameter";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.name = name;
            _x.statecode = statecode;
            _x.processstageparameterid = processstageparameterid;
            _x.statuscode = statuscode;
            _x._owninguser_value = _owninguser_value;
            _x._processstageid_value = _processstageid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.createdon = createdon;
            _x._owningteam_value = _owningteam_value;
            _x.versionnumber = versionnumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.importsequencenumber = importsequencenumber;
            _x.value = value;
            _x.modifiedon = modifiedon;
            _x._ownerid_value = _ownerid_value;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && processstageparameterid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(processstageparameterid.toString()));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Processstageparameter with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Processstageparameter withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Processstageparameter withName(String name) {
        Checks.checkIsAscii(name);
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.name = name;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Processstageparameter withStatecode(Integer statecode) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="processstageparameterid")
    @JsonIgnore
    public Optional<String> getProcessstageparameterid() {
        return Optional.ofNullable(processstageparameterid);
    }

    public Processstageparameter withProcessstageparameterid(String processstageparameterid) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("processstageparameterid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.processstageparameterid = processstageparameterid;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Processstageparameter withStatuscode(Integer statuscode) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Processstageparameter with_owninguser_value(String _owninguser_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_processstageid_value")
    @JsonIgnore
    public Optional<String> get_processstageid_value() {
        return Optional.ofNullable(_processstageid_value);
    }

    public Processstageparameter with_processstageid_value(String _processstageid_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_processstageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._processstageid_value = _processstageid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Processstageparameter with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Processstageparameter withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Processstageparameter with_modifiedby_value(String _modifiedby_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Processstageparameter with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Processstageparameter withCreatedon(OffsetDateTime createdon) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Processstageparameter with_owningteam_value(String _owningteam_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Processstageparameter withVersionnumber(Long versionnumber) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Processstageparameter withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Processstageparameter withImportsequencenumber(Integer importsequencenumber) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public Processstageparameter withValue(String value) {
        Checks.checkIsAscii(value);
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.value = value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Processstageparameter withModifiedon(OffsetDateTime modifiedon) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Processstageparameter with_ownerid_value(String _ownerid_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Processstageparameter with_createdby_value(String _createdby_value) {
        Processstageparameter _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.processstageparameter");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Processstageparameter withUnmappedField(String name, String value) {
        Processstageparameter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="processstageparameter_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getProcessstageparameter_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("processstageparameter_SyncErrors"), RequestHelper.getValue(unmappedFields, "processstageparameter_SyncErrors"));
    }

    @NavigationProperty(name="processstageparameter_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getProcessstageparameter_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("processstageparameter_AsyncOperations"), RequestHelper.getValue(unmappedFields, "processstageparameter_AsyncOperations"));
    }

    @NavigationProperty(name="processstageparameter_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getProcessstageparameter_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("processstageparameter_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "processstageparameter_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="processstageparameter_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getProcessstageparameter_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("processstageparameter_ProcessSession"), RequestHelper.getValue(unmappedFields, "processstageparameter_ProcessSession"));
    }

    @NavigationProperty(name="processstageparameter_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getProcessstageparameter_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("processstageparameter_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "processstageparameter_BulkDeleteFailures"));
    }

    @NavigationProperty(name="processstageparameter_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getProcessstageparameter_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("processstageparameter_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "processstageparameter_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="ProcessStageId")
    @JsonIgnore
    public ProcessstageRequest getProcessStageId() {
        return new ProcessstageRequest(contextPath.addSegment("ProcessStageId"), RequestHelper.getValue(unmappedFields, "ProcessStageId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Processstageparameter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Processstageparameter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Processstageparameter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Processstageparameter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Processstageparameter _copy() {
        Processstageparameter _x = new Processstageparameter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.name = name;
        _x.statecode = statecode;
        _x.processstageparameterid = processstageparameterid;
        _x.statuscode = statuscode;
        _x._owninguser_value = _owninguser_value;
        _x._processstageid_value = _processstageid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.createdon = createdon;
        _x._owningteam_value = _owningteam_value;
        _x.versionnumber = versionnumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.importsequencenumber = importsequencenumber;
        _x.value = value;
        _x.modifiedon = modifiedon;
        _x._ownerid_value = _ownerid_value;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Processstageparameter[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("processstageparameterid=");
        b.append(this.processstageparameterid);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_processstageid_value=");
        b.append(this._processstageid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
