package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_aiodlabel_msdyn_aiconfigurationid", 
    "msdyn_aiconfigurationid", 
    "msdyn_aiodlabelid", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aiodlabel_msdyn_aiconfiguration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration";
    }

    @JsonProperty("msdyn_aiodlabel_msdyn_aiconfigurationid")
    protected String msdyn_aiodlabel_msdyn_aiconfigurationid;

    @JsonProperty("msdyn_aiconfigurationid")
    protected String msdyn_aiconfigurationid;

    @JsonProperty("msdyn_aiodlabelid")
    protected String msdyn_aiodlabelid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Msdyn_aiodlabel_msdyn_aiconfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aiodlabel_msdyn_aiconfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_aiodlabel_msdyn_aiconfigurationid;
        private String msdyn_aiconfigurationid;
        private String msdyn_aiodlabelid;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_aiodlabel_msdyn_aiconfigurationid(String msdyn_aiodlabel_msdyn_aiconfigurationid) {
            this.msdyn_aiodlabel_msdyn_aiconfigurationid = msdyn_aiodlabel_msdyn_aiconfigurationid;
            this.changedFields = changedFields.add("msdyn_aiodlabel_msdyn_aiconfigurationid");
            return this;
        }

        public Builder msdyn_aiconfigurationid(String msdyn_aiconfigurationid) {
            this.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
            this.changedFields = changedFields.add("msdyn_aiconfigurationid");
            return this;
        }

        public Builder msdyn_aiodlabelid(String msdyn_aiodlabelid) {
            this.msdyn_aiodlabelid = msdyn_aiodlabelid;
            this.changedFields = changedFields.add("msdyn_aiodlabelid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Msdyn_aiodlabel_msdyn_aiconfiguration build() {
            Msdyn_aiodlabel_msdyn_aiconfiguration _x = new Msdyn_aiodlabel_msdyn_aiconfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration";
            _x.msdyn_aiodlabel_msdyn_aiconfigurationid = msdyn_aiodlabel_msdyn_aiconfigurationid;
            _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
            _x.msdyn_aiodlabelid = msdyn_aiodlabelid;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aiodlabel_msdyn_aiconfigurationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aiodlabel_msdyn_aiconfigurationid.toString()));
        }
    }

    @Property(name="msdyn_aiodlabel_msdyn_aiconfigurationid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiodlabel_msdyn_aiconfigurationid() {
        return Optional.ofNullable(msdyn_aiodlabel_msdyn_aiconfigurationid);
    }

    public Msdyn_aiodlabel_msdyn_aiconfiguration withMsdyn_aiodlabel_msdyn_aiconfigurationid(String msdyn_aiodlabel_msdyn_aiconfigurationid) {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiodlabel_msdyn_aiconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration");
        _x.msdyn_aiodlabel_msdyn_aiconfigurationid = msdyn_aiodlabel_msdyn_aiconfigurationid;
        return _x;
    }

    @Property(name="msdyn_aiconfigurationid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiconfigurationid() {
        return Optional.ofNullable(msdyn_aiconfigurationid);
    }

    public Msdyn_aiodlabel_msdyn_aiconfiguration withMsdyn_aiconfigurationid(String msdyn_aiconfigurationid) {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration");
        _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
        return _x;
    }

    @Property(name="msdyn_aiodlabelid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiodlabelid() {
        return Optional.ofNullable(msdyn_aiodlabelid);
    }

    public Msdyn_aiodlabel_msdyn_aiconfiguration withMsdyn_aiodlabelid(String msdyn_aiodlabelid) {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiodlabelid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration");
        _x.msdyn_aiodlabelid = msdyn_aiodlabelid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aiodlabel_msdyn_aiconfiguration withVersionnumber(Long versionnumber) {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodlabel_msdyn_aiconfiguration");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Msdyn_aiodlabel_msdyn_aiconfiguration withUnmappedField(String name, String value) {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodlabel_msdyn_aiconfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodlabel_msdyn_aiconfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aiodlabel_msdyn_aiconfiguration _copy() {
        Msdyn_aiodlabel_msdyn_aiconfiguration _x = new Msdyn_aiodlabel_msdyn_aiconfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_aiodlabel_msdyn_aiconfigurationid = msdyn_aiodlabel_msdyn_aiconfigurationid;
        _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
        _x.msdyn_aiodlabelid = msdyn_aiodlabelid;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aiodlabel_msdyn_aiconfiguration[");
        b.append("msdyn_aiodlabel_msdyn_aiconfigurationid=");
        b.append(this.msdyn_aiodlabel_msdyn_aiconfigurationid);
        b.append(", ");
        b.append("msdyn_aiconfigurationid=");
        b.append(this.msdyn_aiconfigurationid);
        b.append(", ");
        b.append("msdyn_aiodlabelid=");
        b.append(this.msdyn_aiodlabelid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
