package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "managedpropertyid", 
    "solutionid", 
    "managedpropertyrowid", 
    "enablesattributename", 
    "componentstate", 
    "logicalname", 
    "overwritetime", 
    "enablesentityname"})
@JsonInclude(Include.NON_NULL)
public class Managedproperty extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.managedproperty";
    }

    @JsonProperty("managedpropertyid")
    protected String managedpropertyid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("managedpropertyrowid")
    protected String managedpropertyrowid;

    @JsonProperty("enablesattributename")
    protected String enablesattributename;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("logicalname")
    protected String logicalname;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("enablesentityname")
    protected String enablesentityname;

    protected Managedproperty() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedproperty() {
        return new Builder();
    }

    public static final class Builder {
        private String managedpropertyid;
        private String solutionid;
        private String managedpropertyrowid;
        private String enablesattributename;
        private Integer componentstate;
        private String logicalname;
        private OffsetDateTime overwritetime;
        private String enablesentityname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder managedpropertyid(String managedpropertyid) {
            this.managedpropertyid = managedpropertyid;
            this.changedFields = changedFields.add("managedpropertyid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder managedpropertyrowid(String managedpropertyrowid) {
            this.managedpropertyrowid = managedpropertyrowid;
            this.changedFields = changedFields.add("managedpropertyrowid");
            return this;
        }

        public Builder enablesattributename(String enablesattributename) {
            this.enablesattributename = enablesattributename;
            this.changedFields = changedFields.add("enablesattributename");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder logicalname(String logicalname) {
            this.logicalname = logicalname;
            this.changedFields = changedFields.add("logicalname");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder enablesentityname(String enablesentityname) {
            this.enablesentityname = enablesentityname;
            this.changedFields = changedFields.add("enablesentityname");
            return this;
        }

        public Managedproperty build() {
            Managedproperty _x = new Managedproperty();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.managedproperty";
            _x.managedpropertyid = managedpropertyid;
            _x.solutionid = solutionid;
            _x.managedpropertyrowid = managedpropertyrowid;
            _x.enablesattributename = enablesattributename;
            _x.componentstate = componentstate;
            _x.logicalname = logicalname;
            _x.overwritetime = overwritetime;
            _x.enablesentityname = enablesentityname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && managedpropertyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(managedpropertyid.toString()));
        }
    }

    @Property(name="managedpropertyid")
    @JsonIgnore
    public Optional<String> getManagedpropertyid() {
        return Optional.ofNullable(managedpropertyid);
    }

    public Managedproperty withManagedpropertyid(String managedpropertyid) {
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("managedpropertyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.managedpropertyid = managedpropertyid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Managedproperty withSolutionid(String solutionid) {
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="managedpropertyrowid")
    @JsonIgnore
    public Optional<String> getManagedpropertyrowid() {
        return Optional.ofNullable(managedpropertyrowid);
    }

    public Managedproperty withManagedpropertyrowid(String managedpropertyrowid) {
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("managedpropertyrowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.managedpropertyrowid = managedpropertyrowid;
        return _x;
    }

    @Property(name="enablesattributename")
    @JsonIgnore
    public Optional<String> getEnablesattributename() {
        return Optional.ofNullable(enablesattributename);
    }

    public Managedproperty withEnablesattributename(String enablesattributename) {
        Checks.checkIsAscii(enablesattributename);
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("enablesattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.enablesattributename = enablesattributename;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Managedproperty withComponentstate(Integer componentstate) {
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="logicalname")
    @JsonIgnore
    public Optional<String> getLogicalname() {
        return Optional.ofNullable(logicalname);
    }

    public Managedproperty withLogicalname(String logicalname) {
        Checks.checkIsAscii(logicalname);
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("logicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.logicalname = logicalname;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Managedproperty withOverwritetime(OffsetDateTime overwritetime) {
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="enablesentityname")
    @JsonIgnore
    public Optional<String> getEnablesentityname() {
        return Optional.ofNullable(enablesentityname);
    }

    public Managedproperty withEnablesentityname(String enablesentityname) {
        Checks.checkIsAscii(enablesentityname);
        Managedproperty _x = _copy();
        _x.changedFields = changedFields.add("enablesentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.managedproperty");
        _x.enablesentityname = enablesentityname;
        return _x;
    }

    public Managedproperty withUnmappedField(String name, String value) {
        Managedproperty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Managedproperty patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Managedproperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Managedproperty put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Managedproperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Managedproperty _copy() {
        Managedproperty _x = new Managedproperty();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.managedpropertyid = managedpropertyid;
        _x.solutionid = solutionid;
        _x.managedpropertyrowid = managedpropertyrowid;
        _x.enablesattributename = enablesattributename;
        _x.componentstate = componentstate;
        _x.logicalname = logicalname;
        _x.overwritetime = overwritetime;
        _x.enablesentityname = enablesentityname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Managedproperty[");
        b.append("managedpropertyid=");
        b.append(this.managedpropertyid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("managedpropertyrowid=");
        b.append(this.managedpropertyrowid);
        b.append(", ");
        b.append("enablesattributename=");
        b.append(this.enablesattributename);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("logicalname=");
        b.append(this.logicalname);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("enablesentityname=");
        b.append(this.enablesentityname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
