package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "region", 
    "languagelocaleid", 
    "language", 
    "code", 
    "versionnumber", 
    "statecode", 
    "statuscode", 
    "_organizationid_value", 
    "name", 
    "localeid"})
@JsonInclude(Include.NON_NULL)
public class Languagelocale extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.languagelocale";
    }

    @JsonProperty("region")
    protected String region;

    @JsonProperty("languagelocaleid")
    protected String languagelocaleid;

    @JsonProperty("language")
    protected String language;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("localeid")
    protected Integer localeid;

    protected Languagelocale() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLanguagelocale() {
        return new Builder();
    }

    public static final class Builder {
        private String region;
        private String languagelocaleid;
        private String language;
        private String code;
        private Long versionnumber;
        private Integer statecode;
        private Integer statuscode;
        private String _organizationid_value;
        private String name;
        private Integer localeid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder region(String region) {
            this.region = region;
            this.changedFields = changedFields.add("region");
            return this;
        }

        public Builder languagelocaleid(String languagelocaleid) {
            this.languagelocaleid = languagelocaleid;
            this.changedFields = changedFields.add("languagelocaleid");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder localeid(Integer localeid) {
            this.localeid = localeid;
            this.changedFields = changedFields.add("localeid");
            return this;
        }

        public Languagelocale build() {
            Languagelocale _x = new Languagelocale();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.languagelocale";
            _x.region = region;
            _x.languagelocaleid = languagelocaleid;
            _x.language = language;
            _x.code = code;
            _x.versionnumber = versionnumber;
            _x.statecode = statecode;
            _x.statuscode = statuscode;
            _x._organizationid_value = _organizationid_value;
            _x.name = name;
            _x.localeid = localeid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && languagelocaleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(languagelocaleid.toString()));
        }
    }

    @Property(name="region")
    @JsonIgnore
    public Optional<String> getRegion() {
        return Optional.ofNullable(region);
    }

    public Languagelocale withRegion(String region) {
        Checks.checkIsAscii(region);
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("region");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.region = region;
        return _x;
    }

    @Property(name="languagelocaleid")
    @JsonIgnore
    public Optional<String> getLanguagelocaleid() {
        return Optional.ofNullable(languagelocaleid);
    }

    public Languagelocale withLanguagelocaleid(String languagelocaleid) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("languagelocaleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.languagelocaleid = languagelocaleid;
        return _x;
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    public Languagelocale withLanguage(String language) {
        Checks.checkIsAscii(language);
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("language");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.language = language;
        return _x;
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public Languagelocale withCode(String code) {
        Checks.checkIsAscii(code);
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.code = code;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Languagelocale withVersionnumber(Long versionnumber) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Languagelocale withStatecode(Integer statecode) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Languagelocale withStatuscode(Integer statuscode) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Languagelocale with_organizationid_value(String _organizationid_value) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Languagelocale withName(String name) {
        Checks.checkIsAscii(name);
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.name = name;
        return _x;
    }

    @Property(name="localeid")
    @JsonIgnore
    public Optional<Integer> getLocaleid() {
        return Optional.ofNullable(localeid);
    }

    public Languagelocale withLocaleid(Integer localeid) {
        Languagelocale _x = _copy();
        _x.changedFields = changedFields.add("localeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languagelocale");
        _x.localeid = localeid;
        return _x;
    }

    public Languagelocale withUnmappedField(String name, String value) {
        Languagelocale _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="knowledgearticle_languagelocaleid")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getKnowledgearticle_languagelocaleid() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("knowledgearticle_languagelocaleid"), RequestHelper.getValue(unmappedFields, "knowledgearticle_languagelocaleid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Languagelocale patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Languagelocale _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Languagelocale put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Languagelocale _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Languagelocale _copy() {
        Languagelocale _x = new Languagelocale();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.region = region;
        _x.languagelocaleid = languagelocaleid;
        _x.language = language;
        _x.code = code;
        _x.versionnumber = versionnumber;
        _x.statecode = statecode;
        _x.statuscode = statuscode;
        _x._organizationid_value = _organizationid_value;
        _x.name = name;
        _x.localeid = localeid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Languagelocale[");
        b.append("region=");
        b.append(this.region);
        b.append(", ");
        b.append("languagelocaleid=");
        b.append(this.languagelocaleid);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("localeid=");
        b.append(this.localeid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
