package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "knowledgearticlecategoryid", 
    "categoryid", 
    "knowledgearticleid", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Knowledgearticlescategories extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.knowledgearticlescategories";
    }

    @JsonProperty("knowledgearticlecategoryid")
    protected String knowledgearticlecategoryid;

    @JsonProperty("categoryid")
    protected String categoryid;

    @JsonProperty("knowledgearticleid")
    protected String knowledgearticleid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Knowledgearticlescategories() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKnowledgearticlescategories() {
        return new Builder();
    }

    public static final class Builder {
        private String knowledgearticlecategoryid;
        private String categoryid;
        private String knowledgearticleid;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder knowledgearticlecategoryid(String knowledgearticlecategoryid) {
            this.knowledgearticlecategoryid = knowledgearticlecategoryid;
            this.changedFields = changedFields.add("knowledgearticlecategoryid");
            return this;
        }

        public Builder categoryid(String categoryid) {
            this.categoryid = categoryid;
            this.changedFields = changedFields.add("categoryid");
            return this;
        }

        public Builder knowledgearticleid(String knowledgearticleid) {
            this.knowledgearticleid = knowledgearticleid;
            this.changedFields = changedFields.add("knowledgearticleid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Knowledgearticlescategories build() {
            Knowledgearticlescategories _x = new Knowledgearticlescategories();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.knowledgearticlescategories";
            _x.knowledgearticlecategoryid = knowledgearticlecategoryid;
            _x.categoryid = categoryid;
            _x.knowledgearticleid = knowledgearticleid;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && knowledgearticlecategoryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(knowledgearticlecategoryid.toString()));
        }
    }

    @Property(name="knowledgearticlecategoryid")
    @JsonIgnore
    public Optional<String> getKnowledgearticlecategoryid() {
        return Optional.ofNullable(knowledgearticlecategoryid);
    }

    public Knowledgearticlescategories withKnowledgearticlecategoryid(String knowledgearticlecategoryid) {
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = changedFields.add("knowledgearticlecategoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticlescategories");
        _x.knowledgearticlecategoryid = knowledgearticlecategoryid;
        return _x;
    }

    @Property(name="categoryid")
    @JsonIgnore
    public Optional<String> getCategoryid() {
        return Optional.ofNullable(categoryid);
    }

    public Knowledgearticlescategories withCategoryid(String categoryid) {
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = changedFields.add("categoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticlescategories");
        _x.categoryid = categoryid;
        return _x;
    }

    @Property(name="knowledgearticleid")
    @JsonIgnore
    public Optional<String> getKnowledgearticleid() {
        return Optional.ofNullable(knowledgearticleid);
    }

    public Knowledgearticlescategories withKnowledgearticleid(String knowledgearticleid) {
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = changedFields.add("knowledgearticleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticlescategories");
        _x.knowledgearticleid = knowledgearticleid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Knowledgearticlescategories withVersionnumber(Long versionnumber) {
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.knowledgearticlescategories");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Knowledgearticlescategories withUnmappedField(String name, String value) {
        Knowledgearticlescategories _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgearticlescategories patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Knowledgearticlescategories put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Knowledgearticlescategories _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Knowledgearticlescategories _copy() {
        Knowledgearticlescategories _x = new Knowledgearticlescategories();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.knowledgearticlecategoryid = knowledgearticlecategoryid;
        _x.categoryid = categoryid;
        _x.knowledgearticleid = knowledgearticleid;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Knowledgearticlescategories[");
        b.append("knowledgearticlecategoryid=");
        b.append(this.knowledgearticlecategoryid);
        b.append(", ");
        b.append("categoryid=");
        b.append(this.categoryid);
        b.append(", ");
        b.append("knowledgearticleid=");
        b.append(this.knowledgearticleid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
