package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentrelationshipconfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "entityrelationshipid", 
    "componentstate", 
    "schemaname", 
    "solutionid", 
    "overwritetime"})
@JsonInclude(Include.NON_NULL)
public class Entityrelationship extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entityrelationship";
    }

    @JsonProperty("entityrelationshipid")
    protected String entityrelationshipid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("schemaname")
    protected String schemaname;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    protected Entityrelationship() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityrelationship() {
        return new Builder();
    }

    public static final class Builder {
        private String entityrelationshipid;
        private Integer componentstate;
        private String schemaname;
        private String solutionid;
        private OffsetDateTime overwritetime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityrelationshipid(String entityrelationshipid) {
            this.entityrelationshipid = entityrelationshipid;
            this.changedFields = changedFields.add("entityrelationshipid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder schemaname(String schemaname) {
            this.schemaname = schemaname;
            this.changedFields = changedFields.add("schemaname");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Entityrelationship build() {
            Entityrelationship _x = new Entityrelationship();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entityrelationship";
            _x.entityrelationshipid = entityrelationshipid;
            _x.componentstate = componentstate;
            _x.schemaname = schemaname;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entityrelationshipid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entityrelationshipid.toString()));
        }
    }

    @Property(name="entityrelationshipid")
    @JsonIgnore
    public Optional<String> getEntityrelationshipid() {
        return Optional.ofNullable(entityrelationshipid);
    }

    public Entityrelationship withEntityrelationshipid(String entityrelationshipid) {
        Entityrelationship _x = _copy();
        _x.changedFields = changedFields.add("entityrelationshipid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityrelationship");
        _x.entityrelationshipid = entityrelationshipid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entityrelationship withComponentstate(Integer componentstate) {
        Entityrelationship _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityrelationship");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="schemaname")
    @JsonIgnore
    public Optional<String> getSchemaname() {
        return Optional.ofNullable(schemaname);
    }

    public Entityrelationship withSchemaname(String schemaname) {
        Checks.checkIsAscii(schemaname);
        Entityrelationship _x = _copy();
        _x.changedFields = changedFields.add("schemaname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityrelationship");
        _x.schemaname = schemaname;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entityrelationship withSolutionid(String solutionid) {
        Entityrelationship _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityrelationship");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entityrelationship withOverwritetime(OffsetDateTime overwritetime) {
        Entityrelationship _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entityrelationship");
        _x.overwritetime = overwritetime;
        return _x;
    }

    public Entityrelationship withUnmappedField(String name, String value) {
        Entityrelationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="entityrelationship_config")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationCollectionRequest getEntityrelationship_config() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("entityrelationship_config"), RequestHelper.getValue(unmappedFields, "entityrelationship_config"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityrelationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entityrelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entityrelationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entityrelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entityrelationship _copy() {
        Entityrelationship _x = new Entityrelationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityrelationshipid = entityrelationshipid;
        _x.componentstate = componentstate;
        _x.schemaname = schemaname;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entityrelationship[");
        b.append("entityrelationshipid=");
        b.append(this.entityrelationshipid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("schemaname=");
        b.append(this.schemaname);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
