package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_organizationid_value", 
    "versionnumber", 
    "statuscode", 
    "componentstate", 
    "importsequencenumber", 
    "description", 
    "overwritetime", 
    "createdon", 
    "modifiedon", 
    "name", 
    "solutionid", 
    "_modifiedonbehalfby_value", 
    "category", 
    "_modifiedby_value", 
    "statecode", 
    "iscustomizable", 
    "connectionroleid", 
    "connectionroleidunique", 
    "ismanaged", 
    "_createdonbehalfby_value", 
    "introducedversion", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Connectionrole extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.connectionrole";
    }

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("category")
    protected Integer category;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("connectionroleid")
    protected String connectionroleid;

    @JsonProperty("connectionroleidunique")
    protected String connectionroleidunique;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Connectionrole() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectionrole() {
        return new Builder();
    }

    public static final class Builder {
        private String _organizationid_value;
        private Long versionnumber;
        private Integer statuscode;
        private Integer componentstate;
        private Integer importsequencenumber;
        private String description;
        private OffsetDateTime overwritetime;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private String name;
        private String solutionid;
        private String _modifiedonbehalfby_value;
        private Integer category;
        private String _modifiedby_value;
        private Integer statecode;
        private BooleanManagedProperty iscustomizable;
        private String connectionroleid;
        private String connectionroleidunique;
        private Boolean ismanaged;
        private String _createdonbehalfby_value;
        private String introducedversion;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder category(Integer category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder connectionroleid(String connectionroleid) {
            this.connectionroleid = connectionroleid;
            this.changedFields = changedFields.add("connectionroleid");
            return this;
        }

        public Builder connectionroleidunique(String connectionroleidunique) {
            this.connectionroleidunique = connectionroleidunique;
            this.changedFields = changedFields.add("connectionroleidunique");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Connectionrole build() {
            Connectionrole _x = new Connectionrole();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.connectionrole";
            _x._organizationid_value = _organizationid_value;
            _x.versionnumber = versionnumber;
            _x.statuscode = statuscode;
            _x.componentstate = componentstate;
            _x.importsequencenumber = importsequencenumber;
            _x.description = description;
            _x.overwritetime = overwritetime;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x.name = name;
            _x.solutionid = solutionid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.category = category;
            _x._modifiedby_value = _modifiedby_value;
            _x.statecode = statecode;
            _x.iscustomizable = iscustomizable;
            _x.connectionroleid = connectionroleid;
            _x.connectionroleidunique = connectionroleidunique;
            _x.ismanaged = ismanaged;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.introducedversion = introducedversion;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && connectionroleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(connectionroleid.toString()));
        }
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Connectionrole with_organizationid_value(String _organizationid_value) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Connectionrole withVersionnumber(Long versionnumber) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Connectionrole withStatuscode(Integer statuscode) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Connectionrole withComponentstate(Integer componentstate) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Connectionrole withImportsequencenumber(Integer importsequencenumber) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Connectionrole withDescription(String description) {
        Checks.checkIsAscii(description);
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.description = description;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Connectionrole withOverwritetime(OffsetDateTime overwritetime) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Connectionrole withCreatedon(OffsetDateTime createdon) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Connectionrole withModifiedon(OffsetDateTime modifiedon) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Connectionrole withName(String name) {
        Checks.checkIsAscii(name);
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.name = name;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Connectionrole withSolutionid(String solutionid) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Connectionrole with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<Integer> getCategory() {
        return Optional.ofNullable(category);
    }

    public Connectionrole withCategory(Integer category) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.category = category;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Connectionrole with_modifiedby_value(String _modifiedby_value) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Connectionrole withStatecode(Integer statecode) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Connectionrole withIscustomizable(BooleanManagedProperty iscustomizable) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="connectionroleid")
    @JsonIgnore
    public Optional<String> getConnectionroleid() {
        return Optional.ofNullable(connectionroleid);
    }

    public Connectionrole withConnectionroleid(String connectionroleid) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("connectionroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.connectionroleid = connectionroleid;
        return _x;
    }

    @Property(name="connectionroleidunique")
    @JsonIgnore
    public Optional<String> getConnectionroleidunique() {
        return Optional.ofNullable(connectionroleidunique);
    }

    public Connectionrole withConnectionroleidunique(String connectionroleidunique) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("connectionroleidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.connectionroleidunique = connectionroleidunique;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Connectionrole withIsmanaged(Boolean ismanaged) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Connectionrole with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Connectionrole withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Connectionrole with_createdby_value(String _createdby_value) {
        Connectionrole _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionrole");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Connectionrole withUnmappedField(String name, String value) {
        Connectionrole _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="ConnectionRole_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getConnectionRole_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ConnectionRole_ProcessSessions"), RequestHelper.getValue(unmappedFields, "ConnectionRole_ProcessSessions"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="Connection_Role_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getConnection_Role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Connection_Role_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Connection_Role_AsyncOperations"));
    }

    @NavigationProperty(name="connection_role_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getConnection_role_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections2"), RequestHelper.getValue(unmappedFields, "connection_role_connections2"));
    }

    @NavigationProperty(name="ConnectionRole_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getConnectionRole_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ConnectionRole_SyncErrors"), RequestHelper.getValue(unmappedFields, "ConnectionRole_SyncErrors"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="connection_role_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getConnection_role_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections1"), RequestHelper.getValue(unmappedFields, "connection_role_connections1"));
    }

    @NavigationProperty(name="connectionroleassociation_association")
    @JsonIgnore
    public ConnectionroleCollectionRequest getConnectionroleassociation_association() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association"), RequestHelper.getValue(unmappedFields, "connectionroleassociation_association"));
    }

    @NavigationProperty(name="connectionroleassociation_association_referenced")
    @JsonIgnore
    public ConnectionroleCollectionRequest getConnectionroleassociation_association_referenced() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association_referenced"), RequestHelper.getValue(unmappedFields, "connectionroleassociation_association_referenced"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionrole patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connectionrole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionrole put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connectionrole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connectionrole _copy() {
        Connectionrole _x = new Connectionrole();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._organizationid_value = _organizationid_value;
        _x.versionnumber = versionnumber;
        _x.statuscode = statuscode;
        _x.componentstate = componentstate;
        _x.importsequencenumber = importsequencenumber;
        _x.description = description;
        _x.overwritetime = overwritetime;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x.name = name;
        _x.solutionid = solutionid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.category = category;
        _x._modifiedby_value = _modifiedby_value;
        _x.statecode = statecode;
        _x.iscustomizable = iscustomizable;
        _x.connectionroleid = connectionroleid;
        _x.connectionroleidunique = connectionroleidunique;
        _x.ismanaged = ismanaged;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.introducedversion = introducedversion;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connectionrole[");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("connectionroleid=");
        b.append(this.connectionroleid);
        b.append(", ");
        b.append("connectionroleidunique=");
        b.append(this.connectionroleidunique);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
