package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.CategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "createdon", 
    "title", 
    "description", 
    "overriddencreatedon", 
    "_ownerid_value", 
    "categorynumber", 
    "_modifiedonbehalfby_value", 
    "_owningteam_value", 
    "_parentcategoryid_value", 
    "sequencenumber", 
    "_createdby_value", 
    "_transactioncurrencyid_value", 
    "exchangerate", 
    "_owningbusinessunit_value", 
    "versionnumber", 
    "importsequencenumber", 
    "_owninguser_value", 
    "categoryid"})
@JsonInclude(Include.NON_NULL)
public class Category extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.category";
    }

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("categorynumber")
    protected String categorynumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_parentcategoryid_value")
    protected String _parentcategoryid_value;

    @JsonProperty("sequencenumber")
    protected Integer sequencenumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("categoryid")
    protected String categoryid;

    protected Category() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedby_value;
        private String _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private String title;
        private String description;
        private OffsetDateTime overriddencreatedon;
        private String _ownerid_value;
        private String categorynumber;
        private String _modifiedonbehalfby_value;
        private String _owningteam_value;
        private String _parentcategoryid_value;
        private Integer sequencenumber;
        private String _createdby_value;
        private String _transactioncurrencyid_value;
        private BigDecimal exchangerate;
        private String _owningbusinessunit_value;
        private Long versionnumber;
        private Integer importsequencenumber;
        private String _owninguser_value;
        private String categoryid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder categorynumber(String categorynumber) {
            this.categorynumber = categorynumber;
            this.changedFields = changedFields.add("categorynumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _parentcategoryid_value(String _parentcategoryid_value) {
            this._parentcategoryid_value = _parentcategoryid_value;
            this.changedFields = changedFields.add("_parentcategoryid_value");
            return this;
        }

        public Builder sequencenumber(Integer sequencenumber) {
            this.sequencenumber = sequencenumber;
            this.changedFields = changedFields.add("sequencenumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder categoryid(String categoryid) {
            this.categoryid = categoryid;
            this.changedFields = changedFields.add("categoryid");
            return this;
        }

        public Category build() {
            Category _x = new Category();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.category";
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x.title = title;
            _x.description = description;
            _x.overriddencreatedon = overriddencreatedon;
            _x._ownerid_value = _ownerid_value;
            _x.categorynumber = categorynumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningteam_value = _owningteam_value;
            _x._parentcategoryid_value = _parentcategoryid_value;
            _x.sequencenumber = sequencenumber;
            _x._createdby_value = _createdby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.exchangerate = exchangerate;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._owninguser_value = _owninguser_value;
            _x.categoryid = categoryid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && categoryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(categoryid.toString()));
        }
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Category with_modifiedby_value(String _modifiedby_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Category with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Category withModifiedon(OffsetDateTime modifiedon) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Category withCreatedon(OffsetDateTime createdon) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Category withTitle(String title) {
        Checks.checkIsAscii(title);
        Category _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.title = title;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Category withDescription(String description) {
        Checks.checkIsAscii(description);
        Category _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.description = description;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Category withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Category with_ownerid_value(String _ownerid_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="categorynumber")
    @JsonIgnore
    public Optional<String> getCategorynumber() {
        return Optional.ofNullable(categorynumber);
    }

    public Category withCategorynumber(String categorynumber) {
        Checks.checkIsAscii(categorynumber);
        Category _x = _copy();
        _x.changedFields = changedFields.add("categorynumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.categorynumber = categorynumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Category with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Category with_owningteam_value(String _owningteam_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_parentcategoryid_value")
    @JsonIgnore
    public Optional<String> get_parentcategoryid_value() {
        return Optional.ofNullable(_parentcategoryid_value);
    }

    public Category with_parentcategoryid_value(String _parentcategoryid_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_parentcategoryid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._parentcategoryid_value = _parentcategoryid_value;
        return _x;
    }

    @Property(name="sequencenumber")
    @JsonIgnore
    public Optional<Integer> getSequencenumber() {
        return Optional.ofNullable(sequencenumber);
    }

    public Category withSequencenumber(Integer sequencenumber) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("sequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.sequencenumber = sequencenumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Category with_createdby_value(String _createdby_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Category with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Category withExchangerate(BigDecimal exchangerate) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Category with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Category withVersionnumber(Long versionnumber) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Category withImportsequencenumber(Integer importsequencenumber) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Category with_owninguser_value(String _owninguser_value) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="categoryid")
    @JsonIgnore
    public Optional<String> getCategoryid() {
        return Optional.ofNullable(categoryid);
    }

    public Category withCategoryid(String categoryid) {
        Category _x = _copy();
        _x.changedFields = changedFields.add("categoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.category");
        _x.categoryid = categoryid;
        return _x;
    }

    public Category withUnmappedField(String name, String value) {
        Category _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="parentcategoryid")
    @JsonIgnore
    public CategoryRequest getParentcategoryid() {
        return new CategoryRequest(contextPath.addSegment("parentcategoryid"), RequestHelper.getValue(unmappedFields, "parentcategoryid"));
    }

    @NavigationProperty(name="category_parent_category")
    @JsonIgnore
    public CategoryCollectionRequest getCategory_parent_category() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("category_parent_category"), RequestHelper.getValue(unmappedFields, "category_parent_category"));
    }

    @NavigationProperty(name="Category_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getCategory_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Category_SyncErrors"), RequestHelper.getValue(unmappedFields, "Category_SyncErrors"));
    }

    @NavigationProperty(name="lk_category_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getLk_category_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "lk_category_modifiedonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="lk_category_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getLk_category_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "lk_category_createdonbehalfby"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="lk_category_modifiedby")
    @JsonIgnore
    public SystemuserRequest getLk_category_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_modifiedby"), RequestHelper.getValue(unmappedFields, "lk_category_modifiedby"));
    }

    @NavigationProperty(name="knowledgearticle_category")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getKnowledgearticle_category() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("knowledgearticle_category"), RequestHelper.getValue(unmappedFields, "knowledgearticle_category"));
    }

    @NavigationProperty(name="lk_category_createdby")
    @JsonIgnore
    public SystemuserRequest getLk_category_createdby() {
        return new SystemuserRequest(contextPath.addSegment("lk_category_createdby"), RequestHelper.getValue(unmappedFields, "lk_category_createdby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Category patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Category _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Category put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Category _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Category _copy() {
        Category _x = new Category();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x.title = title;
        _x.description = description;
        _x.overriddencreatedon = overriddencreatedon;
        _x._ownerid_value = _ownerid_value;
        _x.categorynumber = categorynumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningteam_value = _owningteam_value;
        _x._parentcategoryid_value = _parentcategoryid_value;
        _x.sequencenumber = sequencenumber;
        _x._createdby_value = _createdby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.exchangerate = exchangerate;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._owninguser_value = _owninguser_value;
        _x.categoryid = categoryid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Category[");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("categorynumber=");
        b.append(this.categorynumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_parentcategoryid_value=");
        b.append(this._parentcategoryid_value);
        b.append(", ");
        b.append("sequencenumber=");
        b.append(this.sequencenumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("categoryid=");
        b.append(this.categoryid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
