package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.XrmAggregateType;
import microsoft.dynamics.crm.enums.XrmDateTimeGrouping;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeName", 
    "AggregateType", 
    "Alias", 
    "HasGroupBy", 
    "DateTimeGrouping"})
@JsonInclude(Include.NON_NULL)
public class XrmAttributeExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributeName")
    protected String attributeName;

    @JsonProperty("AggregateType")
    protected XrmAggregateType aggregateType;

    @JsonProperty("Alias")
    protected String alias;

    @JsonProperty("HasGroupBy")
    protected Boolean hasGroupBy;

    @JsonProperty("DateTimeGrouping")
    protected XrmDateTimeGrouping dateTimeGrouping;

    protected XrmAttributeExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.XrmAttributeExpression";
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(attributeName);
    }

    public XrmAttributeExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii(attributeName);
        XrmAttributeExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="AggregateType")
    @JsonIgnore
    public Optional<XrmAggregateType> getAggregateType() {
        return Optional.ofNullable(aggregateType);
    }

    public XrmAttributeExpression withAggregateType(XrmAggregateType aggregateType) {
        XrmAttributeExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.aggregateType = aggregateType;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    public XrmAttributeExpression withAlias(String alias) {
        Checks.checkIsAscii(alias);
        XrmAttributeExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.alias = alias;
        return _x;
    }

    @Property(name="HasGroupBy")
    @JsonIgnore
    public Optional<Boolean> getHasGroupBy() {
        return Optional.ofNullable(hasGroupBy);
    }

    public XrmAttributeExpression withHasGroupBy(Boolean hasGroupBy) {
        XrmAttributeExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.hasGroupBy = hasGroupBy;
        return _x;
    }

    @Property(name="DateTimeGrouping")
    @JsonIgnore
    public Optional<XrmDateTimeGrouping> getDateTimeGrouping() {
        return Optional.ofNullable(dateTimeGrouping);
    }

    public XrmAttributeExpression withDateTimeGrouping(XrmDateTimeGrouping dateTimeGrouping) {
        XrmAttributeExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.dateTimeGrouping = dateTimeGrouping;
        return _x;
    }

    public XrmAttributeExpression withUnmappedField(String name, String value) {
        XrmAttributeExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String attributeName;
        private XrmAggregateType aggregateType;
        private String alias;
        private Boolean hasGroupBy;
        private XrmDateTimeGrouping dateTimeGrouping;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = changedFields.add("AttributeName");
            return this;
        }

        public Builder aggregateType(XrmAggregateType aggregateType) {
            this.aggregateType = aggregateType;
            this.changedFields = changedFields.add("AggregateType");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = changedFields.add("Alias");
            return this;
        }

        public Builder hasGroupBy(Boolean hasGroupBy) {
            this.hasGroupBy = hasGroupBy;
            this.changedFields = changedFields.add("HasGroupBy");
            return this;
        }

        public Builder dateTimeGrouping(XrmDateTimeGrouping dateTimeGrouping) {
            this.dateTimeGrouping = dateTimeGrouping;
            this.changedFields = changedFields.add("DateTimeGrouping");
            return this;
        }

        public XrmAttributeExpression build() {
            XrmAttributeExpression _x = new XrmAttributeExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.XrmAttributeExpression";
            _x.attributeName = attributeName;
            _x.aggregateType = aggregateType;
            _x.alias = alias;
            _x.hasGroupBy = hasGroupBy;
            _x.dateTimeGrouping = dateTimeGrouping;
            return _x;
        }
    }

    private XrmAttributeExpression _copy() {
        XrmAttributeExpression _x = new XrmAttributeExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeName = attributeName;
        _x.aggregateType = aggregateType;
        _x.alias = alias;
        _x.hasGroupBy = hasGroupBy;
        _x.dateTimeGrouping = dateTimeGrouping;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XrmAttributeExpression[");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("AggregateType=");
        b.append(this.aggregateType);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append(", ");
        b.append("HasGroupBy=");
        b.append(this.hasGroupBy);
        b.append(", ");
        b.append("DateTimeGrouping=");
        b.append(this.dateTimeGrouping);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
