package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "UniqueName", 
    "WebResourceId", 
    "MetadataVersionNumber"})
@JsonInclude(Include.NON_NULL)
public class WebResourceDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("UniqueName")
    protected String uniqueName;

    @JsonProperty("WebResourceId")
    protected String webResourceId;

    @JsonProperty("MetadataVersionNumber")
    protected Long metadataVersionNumber;

    protected WebResourceDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.WebResourceDetails";
    }

    @Property(name="UniqueName")
    @JsonIgnore
    public Optional<String> getUniqueName() {
        return Optional.ofNullable(uniqueName);
    }

    public WebResourceDetails withUniqueName(String uniqueName) {
        Checks.checkIsAscii(uniqueName);
        WebResourceDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceDetails");
        _x.uniqueName = uniqueName;
        return _x;
    }

    @Property(name="WebResourceId")
    @JsonIgnore
    public Optional<String> getWebResourceId() {
        return Optional.ofNullable(webResourceId);
    }

    public WebResourceDetails withWebResourceId(String webResourceId) {
        WebResourceDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceDetails");
        _x.webResourceId = webResourceId;
        return _x;
    }

    @Property(name="MetadataVersionNumber")
    @JsonIgnore
    public Optional<Long> getMetadataVersionNumber() {
        return Optional.ofNullable(metadataVersionNumber);
    }

    public WebResourceDetails withMetadataVersionNumber(Long metadataVersionNumber) {
        WebResourceDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceDetails");
        _x.metadataVersionNumber = metadataVersionNumber;
        return _x;
    }

    public WebResourceDetails withUnmappedField(String name, String value) {
        WebResourceDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String uniqueName;
        private String webResourceId;
        private Long metadataVersionNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("UniqueName");
            return this;
        }

        public Builder webResourceId(String webResourceId) {
            this.webResourceId = webResourceId;
            this.changedFields = changedFields.add("WebResourceId");
            return this;
        }

        public Builder metadataVersionNumber(Long metadataVersionNumber) {
            this.metadataVersionNumber = metadataVersionNumber;
            this.changedFields = changedFields.add("MetadataVersionNumber");
            return this;
        }

        public WebResourceDetails build() {
            WebResourceDetails _x = new WebResourceDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.WebResourceDetails";
            _x.uniqueName = uniqueName;
            _x.webResourceId = webResourceId;
            _x.metadataVersionNumber = metadataVersionNumber;
            return _x;
        }
    }

    private WebResourceDetails _copy() {
        WebResourceDetails _x = new WebResourceDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.uniqueName = uniqueName;
        _x.webResourceId = webResourceId;
        _x.metadataVersionNumber = metadataVersionNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WebResourceDetails[");
        b.append("UniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("WebResourceId=");
        b.append(this.webResourceId);
        b.append(", ");
        b.append("MetadataVersionNumber=");
        b.append(this.metadataVersionNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
