package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityLogicalName", 
    "AttributeLogicalName", 
    "DataType", 
    "Format", 
    "Alias"})
@JsonInclude(Include.NON_NULL)
public class ViewColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("AttributeLogicalName")
    protected String attributeLogicalName;

    @JsonProperty("DataType")
    protected String dataType;

    @JsonProperty("Format")
    protected String format;

    @JsonProperty("Alias")
    protected String alias;

    protected ViewColumn() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ViewColumn";
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public ViewColumn withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        ViewColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ViewColumn");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="AttributeLogicalName")
    @JsonIgnore
    public Optional<String> getAttributeLogicalName() {
        return Optional.ofNullable(attributeLogicalName);
    }

    public ViewColumn withAttributeLogicalName(String attributeLogicalName) {
        Checks.checkIsAscii(attributeLogicalName);
        ViewColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ViewColumn");
        _x.attributeLogicalName = attributeLogicalName;
        return _x;
    }

    @Property(name="DataType")
    @JsonIgnore
    public Optional<String> getDataType() {
        return Optional.ofNullable(dataType);
    }

    public ViewColumn withDataType(String dataType) {
        Checks.checkIsAscii(dataType);
        ViewColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ViewColumn");
        _x.dataType = dataType;
        return _x;
    }

    @Property(name="Format")
    @JsonIgnore
    public Optional<String> getFormat() {
        return Optional.ofNullable(format);
    }

    public ViewColumn withFormat(String format) {
        Checks.checkIsAscii(format);
        ViewColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ViewColumn");
        _x.format = format;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    public ViewColumn withAlias(String alias) {
        Checks.checkIsAscii(alias);
        ViewColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ViewColumn");
        _x.alias = alias;
        return _x;
    }

    public ViewColumn withUnmappedField(String name, String value) {
        ViewColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityLogicalName;
        private String attributeLogicalName;
        private String dataType;
        private String format;
        private String alias;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder attributeLogicalName(String attributeLogicalName) {
            this.attributeLogicalName = attributeLogicalName;
            this.changedFields = changedFields.add("AttributeLogicalName");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("DataType");
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            this.changedFields = changedFields.add("Format");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = changedFields.add("Alias");
            return this;
        }

        public ViewColumn build() {
            ViewColumn _x = new ViewColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ViewColumn";
            _x.entityLogicalName = entityLogicalName;
            _x.attributeLogicalName = attributeLogicalName;
            _x.dataType = dataType;
            _x.format = format;
            _x.alias = alias;
            return _x;
        }
    }

    private ViewColumn _copy() {
        ViewColumn _x = new ViewColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityLogicalName = entityLogicalName;
        _x.attributeLogicalName = attributeLogicalName;
        _x.dataType = dataType;
        _x.format = format;
        _x.alias = alias;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ViewColumn[");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("AttributeLogicalName=");
        b.append(this.attributeLogicalName);
        b.append(", ");
        b.append("DataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("Format=");
        b.append(this.format);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
