package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Id", 
    "VersionNumber", 
    "SolutionUniqueName", 
    "FriendlyName", 
    "PublisherId", 
    "PublisherIdName", 
    "PublisherUniqueName"})
@JsonInclude(Include.NON_NULL)
public class Solution implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Id")
    protected String id;

    @JsonProperty("VersionNumber")
    protected String versionNumber;

    @JsonProperty("SolutionUniqueName")
    protected String solutionUniqueName;

    @JsonProperty("FriendlyName")
    protected String friendlyName;

    @JsonProperty("PublisherId")
    protected String publisherId;

    @JsonProperty("PublisherIdName")
    protected String publisherIdName;

    @JsonProperty("PublisherUniqueName")
    protected String publisherUniqueName;

    protected Solution() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Solution";
    }

    @Property(name="Id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public Solution withId(String id) {
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.id = id;
        return _x;
    }

    @Property(name="VersionNumber")
    @JsonIgnore
    public Optional<String> getVersionNumber() {
        return Optional.ofNullable(versionNumber);
    }

    public Solution withVersionNumber(String versionNumber) {
        Checks.checkIsAscii(versionNumber);
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.versionNumber = versionNumber;
        return _x;
    }

    @Property(name="SolutionUniqueName")
    @JsonIgnore
    public Optional<String> getSolutionUniqueName() {
        return Optional.ofNullable(solutionUniqueName);
    }

    public Solution withSolutionUniqueName(String solutionUniqueName) {
        Checks.checkIsAscii(solutionUniqueName);
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.solutionUniqueName = solutionUniqueName;
        return _x;
    }

    @Property(name="FriendlyName")
    @JsonIgnore
    public Optional<String> getFriendlyName() {
        return Optional.ofNullable(friendlyName);
    }

    public Solution withFriendlyName(String friendlyName) {
        Checks.checkIsAscii(friendlyName);
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.friendlyName = friendlyName;
        return _x;
    }

    @Property(name="PublisherId")
    @JsonIgnore
    public Optional<String> getPublisherId() {
        return Optional.ofNullable(publisherId);
    }

    public Solution withPublisherId(String publisherId) {
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.publisherId = publisherId;
        return _x;
    }

    @Property(name="PublisherIdName")
    @JsonIgnore
    public Optional<String> getPublisherIdName() {
        return Optional.ofNullable(publisherIdName);
    }

    public Solution withPublisherIdName(String publisherIdName) {
        Checks.checkIsAscii(publisherIdName);
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.publisherIdName = publisherIdName;
        return _x;
    }

    @Property(name="PublisherUniqueName")
    @JsonIgnore
    public Optional<String> getPublisherUniqueName() {
        return Optional.ofNullable(publisherUniqueName);
    }

    public Solution withPublisherUniqueName(String publisherUniqueName) {
        Checks.checkIsAscii(publisherUniqueName);
        Solution _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Solution");
        _x.publisherUniqueName = publisherUniqueName;
        return _x;
    }

    public Solution withUnmappedField(String name, String value) {
        Solution _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String versionNumber;
        private String solutionUniqueName;
        private String friendlyName;
        private String publisherId;
        private String publisherIdName;
        private String publisherUniqueName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("Id");
            return this;
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.changedFields = changedFields.add("VersionNumber");
            return this;
        }

        public Builder solutionUniqueName(String solutionUniqueName) {
            this.solutionUniqueName = solutionUniqueName;
            this.changedFields = changedFields.add("SolutionUniqueName");
            return this;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            this.changedFields = changedFields.add("FriendlyName");
            return this;
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            this.changedFields = changedFields.add("PublisherId");
            return this;
        }

        public Builder publisherIdName(String publisherIdName) {
            this.publisherIdName = publisherIdName;
            this.changedFields = changedFields.add("PublisherIdName");
            return this;
        }

        public Builder publisherUniqueName(String publisherUniqueName) {
            this.publisherUniqueName = publisherUniqueName;
            this.changedFields = changedFields.add("PublisherUniqueName");
            return this;
        }

        public Solution build() {
            Solution _x = new Solution();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.Solution";
            _x.id = id;
            _x.versionNumber = versionNumber;
            _x.solutionUniqueName = solutionUniqueName;
            _x.friendlyName = friendlyName;
            _x.publisherId = publisherId;
            _x.publisherIdName = publisherIdName;
            _x.publisherUniqueName = publisherUniqueName;
            return _x;
        }
    }

    private Solution _copy() {
        Solution _x = new Solution();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.versionNumber = versionNumber;
        _x.solutionUniqueName = solutionUniqueName;
        _x.friendlyName = friendlyName;
        _x.publisherId = publisherId;
        _x.publisherIdName = publisherIdName;
        _x.publisherUniqueName = publisherUniqueName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solution[");
        b.append("Id=");
        b.append(this.id);
        b.append(", ");
        b.append("VersionNumber=");
        b.append(this.versionNumber);
        b.append(", ");
        b.append("SolutionUniqueName=");
        b.append(this.solutionUniqueName);
        b.append(", ");
        b.append("FriendlyName=");
        b.append(this.friendlyName);
        b.append(", ");
        b.append("PublisherId=");
        b.append(this.publisherId);
        b.append(", ");
        b.append("PublisherIdName=");
        b.append(this.publisherIdName);
        b.append(", ");
        b.append("PublisherUniqueName=");
        b.append(this.publisherUniqueName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
