package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "IsReadOnlyInMobileClient", 
    "IsEnabledInUnifiedInterface", 
    "DisplayName", 
    "PrimaryNameAttribute", 
    "PrimaryIdAttribute", 
    "LogicalName", 
    "DisplayCollectionName", 
    "IconVectorName"})
@JsonInclude(Include.NON_NULL)
public class LookupEntityMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IsReadOnlyInMobileClient")
    protected Boolean isReadOnlyInMobileClient;

    @JsonProperty("IsEnabledInUnifiedInterface")
    protected Boolean isEnabledInUnifiedInterface;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("PrimaryNameAttribute")
    protected String primaryNameAttribute;

    @JsonProperty("PrimaryIdAttribute")
    protected String primaryIdAttribute;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("DisplayCollectionName")
    protected String displayCollectionName;

    @JsonProperty("IconVectorName")
    protected String iconVectorName;

    protected LookupEntityMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupEntityMetadata";
    }

    @Property(name="IsReadOnlyInMobileClient")
    @JsonIgnore
    public Optional<Boolean> getIsReadOnlyInMobileClient() {
        return Optional.ofNullable(isReadOnlyInMobileClient);
    }

    public LookupEntityMetadata withIsReadOnlyInMobileClient(Boolean isReadOnlyInMobileClient) {
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        return _x;
    }

    @Property(name="IsEnabledInUnifiedInterface")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledInUnifiedInterface() {
        return Optional.ofNullable(isEnabledInUnifiedInterface);
    }

    public LookupEntityMetadata withIsEnabledInUnifiedInterface(Boolean isEnabledInUnifiedInterface) {
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.isEnabledInUnifiedInterface = isEnabledInUnifiedInterface;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public LookupEntityMetadata withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(primaryNameAttribute);
    }

    public LookupEntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii(primaryNameAttribute);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(primaryIdAttribute);
    }

    public LookupEntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii(primaryIdAttribute);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public LookupEntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="DisplayCollectionName")
    @JsonIgnore
    public Optional<String> getDisplayCollectionName() {
        return Optional.ofNullable(displayCollectionName);
    }

    public LookupEntityMetadata withDisplayCollectionName(String displayCollectionName) {
        Checks.checkIsAscii(displayCollectionName);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.displayCollectionName = displayCollectionName;
        return _x;
    }

    @Property(name="IconVectorName")
    @JsonIgnore
    public Optional<String> getIconVectorName() {
        return Optional.ofNullable(iconVectorName);
    }

    public LookupEntityMetadata withIconVectorName(String iconVectorName) {
        Checks.checkIsAscii(iconVectorName);
        LookupEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupEntityMetadata");
        _x.iconVectorName = iconVectorName;
        return _x;
    }

    public LookupEntityMetadata withUnmappedField(String name, String value) {
        LookupEntityMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isReadOnlyInMobileClient;
        private Boolean isEnabledInUnifiedInterface;
        private String displayName;
        private String primaryNameAttribute;
        private String primaryIdAttribute;
        private String logicalName;
        private String displayCollectionName;
        private String iconVectorName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isReadOnlyInMobileClient(Boolean isReadOnlyInMobileClient) {
            this.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            this.changedFields = changedFields.add("IsReadOnlyInMobileClient");
            return this;
        }

        public Builder isEnabledInUnifiedInterface(Boolean isEnabledInUnifiedInterface) {
            this.isEnabledInUnifiedInterface = isEnabledInUnifiedInterface;
            this.changedFields = changedFields.add("IsEnabledInUnifiedInterface");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder displayCollectionName(String displayCollectionName) {
            this.displayCollectionName = displayCollectionName;
            this.changedFields = changedFields.add("DisplayCollectionName");
            return this;
        }

        public Builder iconVectorName(String iconVectorName) {
            this.iconVectorName = iconVectorName;
            this.changedFields = changedFields.add("IconVectorName");
            return this;
        }

        public LookupEntityMetadata build() {
            LookupEntityMetadata _x = new LookupEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupEntityMetadata";
            _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            _x.isEnabledInUnifiedInterface = isEnabledInUnifiedInterface;
            _x.displayName = displayName;
            _x.primaryNameAttribute = primaryNameAttribute;
            _x.primaryIdAttribute = primaryIdAttribute;
            _x.logicalName = logicalName;
            _x.displayCollectionName = displayCollectionName;
            _x.iconVectorName = iconVectorName;
            return _x;
        }
    }

    private LookupEntityMetadata _copy() {
        LookupEntityMetadata _x = new LookupEntityMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        _x.isEnabledInUnifiedInterface = isEnabledInUnifiedInterface;
        _x.displayName = displayName;
        _x.primaryNameAttribute = primaryNameAttribute;
        _x.primaryIdAttribute = primaryIdAttribute;
        _x.logicalName = logicalName;
        _x.displayCollectionName = displayCollectionName;
        _x.iconVectorName = iconVectorName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupEntityMetadata[");
        b.append("IsReadOnlyInMobileClient=");
        b.append(this.isReadOnlyInMobileClient);
        b.append(", ");
        b.append("IsEnabledInUnifiedInterface=");
        b.append(this.isEnabledInUnifiedInterface);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("DisplayCollectionName=");
        b.append(this.displayCollectionName);
        b.append(", ");
        b.append("IconVectorName=");
        b.append(this.iconVectorName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
