package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityResponses"})
@JsonInclude(Include.NON_NULL)
public class LookupDataResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityResponses")
    protected List<LookupEntityResponse> entityResponses;

    @JsonProperty("EntityResponses@nextLink")
    protected String entityResponsesNextLink;

    protected LookupDataResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupDataResponse";
    }

    @Property(name="EntityResponses")
    @JsonIgnore
    public CollectionPage<LookupEntityResponse> getEntityResponses() {
        return new CollectionPage<LookupEntityResponse>(contextPath, LookupEntityResponse.class, this.entityResponses, Optional.ofNullable(entityResponsesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityResponses")
    @JsonIgnore
    public CollectionPage<LookupEntityResponse> getEntityResponses(HttpRequestOptions options) {
        return new CollectionPage<LookupEntityResponse>(contextPath, LookupEntityResponse.class, this.entityResponses, Optional.ofNullable(entityResponsesNextLink), Collections.emptyList(), options);
    }

    public LookupDataResponse withUnmappedField(String name, String value) {
        LookupDataResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<LookupEntityResponse> entityResponses;
        private String entityResponsesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityResponses(List<LookupEntityResponse> entityResponses) {
            this.entityResponses = entityResponses;
            this.changedFields = changedFields.add("EntityResponses");
            return this;
        }

        public Builder entityResponses(LookupEntityResponse... entityResponses) {
            return entityResponses(Arrays.asList(entityResponses));
        }

        public Builder entityResponsesNextLink(String entityResponsesNextLink) {
            this.entityResponsesNextLink = entityResponsesNextLink;
            this.changedFields = changedFields.add("EntityResponses");
            return this;
        }

        public LookupDataResponse build() {
            LookupDataResponse _x = new LookupDataResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupDataResponse";
            _x.entityResponses = entityResponses;
            _x.entityResponsesNextLink = entityResponsesNextLink;
            return _x;
        }
    }

    private LookupDataResponse _copy() {
        LookupDataResponse _x = new LookupDataResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityResponses = entityResponses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupDataResponse[");
        b.append("EntityResponses=");
        b.append(this.entityResponses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
