package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AllColumns", 
    "Columns", 
    "AttributeExpressions"})
@JsonInclude(Include.NON_NULL)
public class ColumnSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AllColumns")
    protected Boolean allColumns;

    @JsonProperty("Columns")
    protected List<String> columns;

    @JsonProperty("Columns@nextLink")
    protected String columnsNextLink;

    @JsonProperty("AttributeExpressions")
    protected List<XrmAttributeExpression> attributeExpressions;

    @JsonProperty("AttributeExpressions@nextLink")
    protected String attributeExpressionsNextLink;

    protected ColumnSet() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ColumnSet";
    }

    @Property(name="AllColumns")
    @JsonIgnore
    public Optional<Boolean> getAllColumns() {
        return Optional.ofNullable(allColumns);
    }

    public ColumnSet withAllColumns(Boolean allColumns) {
        ColumnSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ColumnSet");
        _x.allColumns = allColumns;
        return _x;
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns() {
        return new CollectionPage<String>(contextPath, String.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), options);
    }

    @Property(name="AttributeExpressions")
    @JsonIgnore
    public CollectionPage<XrmAttributeExpression> getAttributeExpressions() {
        return new CollectionPage<XrmAttributeExpression>(contextPath, XrmAttributeExpression.class, this.attributeExpressions, Optional.ofNullable(attributeExpressionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributeExpressions")
    @JsonIgnore
    public CollectionPage<XrmAttributeExpression> getAttributeExpressions(HttpRequestOptions options) {
        return new CollectionPage<XrmAttributeExpression>(contextPath, XrmAttributeExpression.class, this.attributeExpressions, Optional.ofNullable(attributeExpressionsNextLink), Collections.emptyList(), options);
    }

    public ColumnSet withUnmappedField(String name, String value) {
        ColumnSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allColumns;
        private List<String> columns;
        private String columnsNextLink;
        private List<XrmAttributeExpression> attributeExpressions;
        private String attributeExpressionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allColumns(Boolean allColumns) {
            this.allColumns = allColumns;
            this.changedFields = changedFields.add("AllColumns");
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder columns(String... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder attributeExpressions(List<XrmAttributeExpression> attributeExpressions) {
            this.attributeExpressions = attributeExpressions;
            this.changedFields = changedFields.add("AttributeExpressions");
            return this;
        }

        public Builder attributeExpressions(XrmAttributeExpression... attributeExpressions) {
            return attributeExpressions(Arrays.asList(attributeExpressions));
        }

        public Builder attributeExpressionsNextLink(String attributeExpressionsNextLink) {
            this.attributeExpressionsNextLink = attributeExpressionsNextLink;
            this.changedFields = changedFields.add("AttributeExpressions");
            return this;
        }

        public ColumnSet build() {
            ColumnSet _x = new ColumnSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ColumnSet";
            _x.allColumns = allColumns;
            _x.columns = columns;
            _x.columnsNextLink = columnsNextLink;
            _x.attributeExpressions = attributeExpressions;
            _x.attributeExpressionsNextLink = attributeExpressionsNextLink;
            return _x;
        }
    }

    private ColumnSet _copy() {
        ColumnSet _x = new ColumnSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allColumns = allColumns;
        _x.columns = columns;
        _x.attributeExpressions = attributeExpressions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ColumnSet[");
        b.append("AllColumns=");
        b.append(this.allColumns);
        b.append(", ");
        b.append("Columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("AttributeExpressions=");
        b.append(this.attributeExpressions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
