package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ErrorType implements Enum {

    @JsonProperty("Error")
    ERROR("Error", "1"),

    @JsonProperty("Warning")
    WARNING("Warning", "2");

    private final String name;
    private final String value;

    private ErrorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
