package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Solution;
import microsoft.dynamics.crm.entity.collection.request.CanvasappCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldpermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SolutionRequest extends EntityRequest<Solution> {

    public SolutionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Solution.class, contextPath, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public WebresourceRequest configurationpageid() {
        return new WebresourceRequest(contextPath.addSegment("configurationpageid"), Optional.empty());
    }

    public SolutioncomponentCollectionRequest solution_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("solution_solutioncomponent"), Optional.empty());
    }

    public SolutioncomponentRequest solution_solutioncomponent(String solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solution_solutioncomponent").addKeys(new NameValue(solutioncomponentid.toString())), Optional.empty());
    }

    public PublisherRequest publisherid() {
        return new PublisherRequest(contextPath.addSegment("publisherid"), Optional.empty());
    }

    public SyncerrorCollectionRequest solution_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Solution_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest solution_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Solution_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SolutionRequest parentsolutionid() {
        return new SolutionRequest(contextPath.addSegment("parentsolutionid"), Optional.empty());
    }

    public SolutionCollectionRequest solution_parent_solution() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("solution_parent_solution"), Optional.empty());
    }

    public SolutionRequest solution_parent_solution(String solutionid) {
        return new SolutionRequest(contextPath.addSegment("solution_parent_solution").addKeys(new NameValue(solutionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public FileattachmentCollectionRequest regardingobjectid_fileattachment_solution() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("regardingobjectid_fileattachment_solution"), Optional.empty());
    }

    public FileattachmentRequest regardingobjectid_fileattachment_solution(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("regardingobjectid_fileattachment_solution").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public CanvasappCollectionRequest fK_CanvasApp_Solution() {
        return new CanvasappCollectionRequest(
                        contextPath.addSegment("FK_CanvasApp_Solution"), Optional.empty());
    }

    public CanvasappRequest fK_CanvasApp_Solution(String canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("FK_CanvasApp_Solution").addKeys(new NameValue(canvasappid.toString())), Optional.empty());
    }

    public FieldpermissionCollectionRequest solution_fieldpermission() {
        return new FieldpermissionCollectionRequest(
                        contextPath.addSegment("solution_fieldpermission"), Optional.empty());
    }

    public FieldpermissionRequest solution_fieldpermission(String fieldpermissionid) {
        return new FieldpermissionRequest(contextPath.addSegment("solution_fieldpermission").addKeys(new NameValue(fieldpermissionid.toString())), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest solution_fieldsecurityprofile() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("solution_fieldsecurityprofile"), Optional.empty());
    }

    public FieldsecurityprofileRequest solution_fieldsecurityprofile(String fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("solution_fieldsecurityprofile").addKeys(new NameValue(fieldsecurityprofileid.toString())), Optional.empty());
    }

    public PrivilegeCollectionRequest solution_privilege() {
        return new PrivilegeCollectionRequest(
                        contextPath.addSegment("solution_privilege"), Optional.empty());
    }

    public PrivilegeRequest solution_privilege(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("solution_privilege").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public RoleCollectionRequest solution_role() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("solution_role"), Optional.empty());
    }

    public RoleRequest solution_role(String roleid) {
        return new RoleRequest(contextPath.addSegment("solution_role").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public FileattachmentRequest fileid() {
        return new FileattachmentRequest(contextPath.addSegment("fileid"), Optional.empty());
    }

}
