package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Plugintype;
import microsoft.dynamics.crm.entity.collection.request.PlugintypestatisticCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;

@JsonIgnoreType
public class PlugintypeRequest extends EntityRequest<Plugintype> {

    public PlugintypeRequest(ContextPath contextPath, Optional<Object> value) {
        super(Plugintype.class, contextPath, value);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public PluginassemblyRequest pluginassemblyid() {
        return new PluginassemblyRequest(contextPath.addSegment("pluginassemblyid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest plugintypeid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("plugintypeid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest plugintypeid_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("plugintypeid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest plugintype_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("plugintype_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest plugintype_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("plugintype_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest plugintype_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("plugintype_plugintypestatistic"), Optional.empty());
    }

    public PlugintypestatisticRequest plugintype_plugintypestatistic(String plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("plugintype_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid.toString())), Optional.empty());
    }

}
