package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BatchPredictionResponse;
import microsoft.dynamics.crm.complex.PredictResponse;
import microsoft.dynamics.crm.complex.PredictionSchemaResponse;
import microsoft.dynamics.crm.complex.SchedulePredictionResponse;
import microsoft.dynamics.crm.complex.ScheduleRetrainResponse;
import microsoft.dynamics.crm.complex.UnschedulePredictionResponse;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Msdyn_aimodel;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class Msdyn_aimodelRequest extends EntityRequest<Msdyn_aimodel> {

    public Msdyn_aimodelRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_aimodel.class, contextPath, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aimodel_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_aimodel_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aimodel_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aimodel_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aimodel_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aimodel_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aimodel_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aimodel_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aimodel_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aimodel_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aimodel_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aimodel_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aimodel_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aimodel_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aimodel_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aimodel_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aimodel_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aimodel_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest msdyn_aimodel_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_Annotations"), Optional.empty());
    }

    public AnnotationRequest msdyn_aimodel_Annotations(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("msdyn_aimodel_Annotations").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest msdyn_aimodel_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest msdyn_aimodel_msdyn_aiconfiguration(String msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aimodel_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid.toString())), Optional.empty());
    }

    public WorkflowRequest msdyn_retrainworkflowid() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_retrainworkflowid"), Optional.empty());
    }

    public Msdyn_aitemplateRequest msdyn_TemplateId() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("msdyn_TemplateId"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest msdyn_AIBDatasetsContainer_msdyn_AIModelI() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("msdyn_AIBDatasetsContainer_msdyn_AIModelI"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest msdyn_AIBDatasetsContainer_msdyn_AIModelI(String msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("msdyn_AIBDatasetsContainer_msdyn_AIModelI").addKeys(new NameValue(msdyn_aibdatasetscontainerid.toString())), Optional.empty());
    }

    public WorkflowRequest msdyn_scheduleinferenceworkflowid() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_scheduleinferenceworkflowid"), Optional.empty());
    }

    @Action(name = "BatchPrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BatchPredictionResponse> batchPrediction(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BatchPredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BatchPrediction"), BatchPredictionResponse.class, _parameters);
    }

    @Action(name = "Predict")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PredictResponse> predict(String version, String request, Crmbaseentity recordId, Crmbaseentity requestv2) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("request", "Edm.String", Checks.checkIsAscii(request))
            .put("recordId", "Microsoft.Dynamics.CRM.crmbaseentity", recordId)
            .put("requestv2", "Microsoft.Dynamics.CRM.crmbaseentity", requestv2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PredictResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Predict"), PredictResponse.class, _parameters);
    }

    @Action(name = "PredictByReference")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> predictByReference(String version, String targetRecordId) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Preconditions.checkNotNull(targetRecordId, "targetRecordId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("targetRecordId", "Edm.String", Checks.checkIsAscii(targetRecordId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PredictByReference"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "PredictionSchema")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PredictionSchemaResponse> predictionSchema(String version, String predictionMode) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("predictionMode", "Edm.String", Checks.checkIsAscii(predictionMode))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PredictionSchemaResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PredictionSchema"), PredictionSchemaResponse.class, _parameters);
    }

    @Action(name = "SchedulePrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SchedulePredictionResponse> schedulePrediction(String version, Boolean predictImmediately, Boolean cleanupRequired) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("predictImmediately", "Edm.Boolean", predictImmediately)
            .put("cleanupRequired", "Edm.Boolean", cleanupRequired)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SchedulePredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SchedulePrediction"), SchedulePredictionResponse.class, _parameters);
    }

    @Action(name = "ScheduleRetrain")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ScheduleRetrainResponse> scheduleRetrain(String recurrence, String version) {
        Preconditions.checkNotNull(recurrence, "recurrence cannot be null");
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("recurrence", "Edm.String", Checks.checkIsAscii(recurrence))
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ScheduleRetrainResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ScheduleRetrain"), ScheduleRetrainResponse.class, _parameters);
    }

    @Action(name = "UnschedulePrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnschedulePredictionResponse> unschedulePrediction(String version, Boolean skipStatusUpdate) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("skipStatusUpdate", "Edm.Boolean", skipStatusUpdate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnschedulePredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnschedulePrediction"), UnschedulePredictionResponse.class, _parameters);
    }

}
