package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Goalrollupquery;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class GoalrollupqueryRequest extends EntityRequest<Goalrollupquery> {

    public GoalrollupqueryRequest(ContextPath contextPath, Optional<Object> value) {
        super(Goalrollupquery.class, contextPath, value);
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public GoalCollectionRequest goalrollupquery_actualint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goalrollupquery_actualint"), Optional.empty());
    }

    public GoalRequest goalrollupquery_actualint(String goalid) {
        return new GoalRequest(contextPath.addSegment("goalrollupquery_actualint").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_actualmoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_actualmoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_actualmoney(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_actualmoney").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_actualdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_actualdecimal"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_actualdecimal(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_actualdecimal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_customint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_customint"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_customint(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_customint").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_custommoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_custommoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_custommoney(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_custommoney").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_customdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_customdecimal"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_customdecimal(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_customdecimal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressint() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressint"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressint(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressint").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressmoney() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressmoney"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressmoney(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressmoney").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_rollupquery_inprogressdecimal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_rollupquery_inprogressdecimal"), Optional.empty());
    }

    public GoalRequest goal_rollupquery_inprogressdecimal(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_rollupquery_inprogressdecimal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goalRollupQuery_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest goalRollupQuery_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("GoalRollupQuery_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public AsyncoperationCollectionRequest goalrollupquery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("goalrollupquery_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest goalrollupquery_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("goalrollupquery_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goalRollupQuery_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest goalRollupQuery_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("GoalRollupQuery_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest goalrollupquery_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("goalrollupquery_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest goalrollupquery_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("goalrollupquery_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest goalRollupQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("GoalRollupQuery_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest goalRollupQuery_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("GoalRollupQuery_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

}
