package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Transformationparametermapping;
import microsoft.dynamics.crm.entity.request.LookupmappingRequest;
import microsoft.dynamics.crm.entity.request.TransformationparametermappingRequest;

public class TransformationparametermappingCollectionRequest extends CollectionPageEntityRequest<Transformationparametermapping, TransformationparametermappingRequest>{

    protected ContextPath contextPath;

    public TransformationparametermappingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Transformationparametermapping.class, cp -> new TransformationparametermappingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public LookupmappingCollectionRequest lookUpMapping_TransformationParameterMapping() {
        return new LookupmappingCollectionRequest(contextPath.addSegment("LookUpMapping_TransformationParameterMapping"), Optional.empty());
    }

    public LookupmappingRequest lookUpMapping_TransformationParameterMapping(String lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("LookUpMapping_TransformationParameterMapping").addKeys(new NameValue(lookupmappingid.toString())), Optional.empty());
    }

}
