package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sdkmessageprocessingstep;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepimageRequest;

public class SdkmessageprocessingstepCollectionRequest extends CollectionPageEntityRequest<Sdkmessageprocessingstep, SdkmessageprocessingstepRequest>{

    protected ContextPath contextPath;

    public SdkmessageprocessingstepCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sdkmessageprocessingstep.class, cp -> new SdkmessageprocessingstepRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest sdkMessageProcessingStep_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SdkMessageProcessingStep_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest sdkMessageProcessingStep_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SdkMessageProcessingStep_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest sdkmessageprocessingstepid_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(contextPath.addSegment("sdkmessageprocessingstepid_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest sdkmessageprocessingstepid_sdkmessageprocessingstepimage(String sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("sdkmessageprocessingstepid_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid.toString())), Optional.empty());
    }

}
