package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Quarterlyfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;

public class QuarterlyfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Quarterlyfiscalcalendar, QuarterlyfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public QuarterlyfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Quarterlyfiscalcalendar.class, cp -> new QuarterlyfiscalcalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest quarterlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest quarterlyFiscalCalendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("QuarterlyFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest quarterlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest quarterlyFiscalCalendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("QuarterlyFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
